/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.deps.com.google.common.util.concurrent.AtomicDouble;
import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.StatsBase;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ResponseTimeStatsImpl
extends AbstractStats
implements ResponseTimeStats {
    private static final long NANOSECONDS_PER_SECOND_SQUARED = 1000000000000000000L;
    private final AtomicLong total;
    private final AtomicLong totalExclusive;
    private final AtomicLong minValue;
    private final AtomicLong maxValue;
    private final AtomicDouble sumOfSquares;

    protected ResponseTimeStatsImpl() {
        this.total = new AtomicLong(0L);
        this.totalExclusive = new AtomicLong(0L);
        this.minValue = new AtomicLong(0L);
        this.maxValue = new AtomicLong(0L);
        this.sumOfSquares = new AtomicDouble(0.0);
    }

    private ResponseTimeStatsImpl(int count, long total, long totalExclusive, long minValue, long maxValue, double sumOfSquares) {
        super(count);
        this.total = new AtomicLong(total);
        this.totalExclusive = new AtomicLong(totalExclusive);
        this.minValue = new AtomicLong(minValue);
        this.maxValue = new AtomicLong(maxValue);
        this.sumOfSquares = new AtomicDouble(sumOfSquares);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new ResponseTimeStatsImpl(this.count.get(), this.total.get(), this.totalExclusive.get(), this.minValue.get(), this.maxValue.get(), this.sumOfSquares.get());
    }

    @Override
    public void recordResponseTime(long responseTime, TimeUnit timeUnit) {
        long responseTimeInNanos = TimeUnit.NANOSECONDS.convert(responseTime, timeUnit);
        this.recordResponseTimeInNanos(responseTimeInNanos, responseTimeInNanos);
    }

    @Override
    public void recordResponseTime(long responseTime, long exclusiveTime, TimeUnit timeUnit) {
        long responseTimeInNanos = TimeUnit.NANOSECONDS.convert(responseTime, timeUnit);
        long exclusiveTimeInNanos = TimeUnit.NANOSECONDS.convert(exclusiveTime, timeUnit);
        this.recordResponseTimeInNanos(responseTimeInNanos, exclusiveTimeInNanos);
    }

    @Override
    public void recordResponseTimeInNanos(long responseTime) {
        this.recordResponseTimeInNanos(responseTime, responseTime);
    }

    @Override
    public void recordResponseTimeInNanos(long responseTime, long exclusiveTime) {
        double responseTimeAsDouble = responseTime;
        responseTimeAsDouble *= responseTimeAsDouble;
        this.sumOfSquares.addAndGet(responseTimeAsDouble);
        if (this.count.get() > 0) {
            this.minValue.set(Math.min(responseTime, this.minValue.get()));
        } else {
            this.minValue.set(responseTime);
        }
        this.count.incrementAndGet();
        this.total.addAndGet(responseTime);
        this.maxValue.set(Math.max(responseTime, this.maxValue.get()));
        this.totalExclusive.addAndGet(exclusiveTime);
    }

    @Override
    public boolean hasData() {
        return this.count.get() > 0 || this.total.get() > 0L || this.totalExclusive.get() > 0L;
    }

    @Override
    public void reset() {
        this.count.set(0);
        this.total.set(0L);
        this.totalExclusive.set(0L);
        this.minValue.set(0L);
        this.maxValue.set(0L);
        this.sumOfSquares.set(0.0);
    }

    @Override
    public float getTotal() {
        return (float)this.total.get() / 1.0E9f;
    }

    @Override
    public float getTotalExclusiveTime() {
        return (float)this.totalExclusive.get() / 1.0E9f;
    }

    @Override
    public float getMaxCallTime() {
        return (float)this.maxValue.get() / 1.0E9f;
    }

    @Override
    public float getMinCallTime() {
        return (float)this.minValue.get() / 1.0E9f;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquares.get() / 1.0E18;
    }

    @Override
    public final void merge(StatsBase statsObj) {
        if (statsObj instanceof ResponseTimeStatsImpl) {
            ResponseTimeStatsImpl stats = (ResponseTimeStatsImpl)statsObj;
            if (stats.count.get() > 0) {
                if (this.count.get() > 0) {
                    this.minValue.set(Math.min(this.minValue.get(), stats.minValue.get()));
                } else {
                    this.minValue.set(stats.minValue.get());
                }
            }
            this.count.addAndGet(stats.count.get());
            this.total.addAndGet(stats.total.get());
            this.totalExclusive.addAndGet(stats.totalExclusive.get());
            this.maxValue.set(Math.max(this.maxValue.get(), stats.maxValue.get()));
            this.sumOfSquares.addAndGet(stats.sumOfSquares.get());
        }
    }

    @Override
    public void recordResponseTime(int count, long totalTime, long minTime, long maxTime, TimeUnit unit) {
        long totalTimeInNanos = TimeUnit.NANOSECONDS.convert(totalTime, unit);
        this.count.set(count);
        this.total.set(totalTimeInNanos);
        this.totalExclusive.set(totalTimeInNanos);
        this.minValue.set(TimeUnit.NANOSECONDS.convert(minTime, unit));
        this.maxValue.set(TimeUnit.NANOSECONDS.convert(maxTime, unit));
        double totalTimeInNanosAsDouble = totalTimeInNanos;
        totalTimeInNanosAsDouble *= totalTimeInNanosAsDouble;
        this.sumOfSquares.addAndGet(totalTimeInNanosAsDouble);
    }

    public String toString() {
        return "ResponseTimeStatsImpl [total=" + this.total + ", totalExclusive=" + this.totalExclusive + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", sumOfSquares=" + this.sumOfSquares + "]";
    }
}

