/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Harvestable;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.attributes.AttributesUtils;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.CacheLoader;
import com.newrelic.agent.deps.com.google.common.cache.LoadingCache;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.DistributedSamplingAwareReservoir;
import com.newrelic.agent.service.analytics.FixedSizeArrayList;
import com.newrelic.agent.service.analytics.ReservoirSampledArrayList;
import com.newrelic.agent.service.analytics.TransactionEvent;
import com.newrelic.agent.service.analytics.TransactionEventBuilder;
import com.newrelic.agent.service.analytics.TransactionEventHarvestableImpl;
import com.newrelic.agent.service.analytics.TransactionEventsConfigUtils;
import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.CountStats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.api.agent.NewRelic;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class TransactionEventsService
extends AbstractService
implements Service,
TransactionListener,
AgentConfigListener {
    private final boolean enabled;
    private final int target;
    protected volatile int maxSamplesStored;
    private final ConcurrentHashMap<String, DistributedSamplingAwareReservoir<TransactionEvent>> reservoirForApp = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DistributedSamplingAwareReservoir<TransactionEvent>> syntheticsListForApp = new ConcurrentHashMap();
    private final ConcurrentMap<String, Boolean> isEnabledForApp = new ConcurrentHashMap<String, Boolean>();
    final ArrayDeque<FixedSizeArrayList<TransactionEvent>> pendingSyntheticsArrays = new ArrayDeque();
    static final int MAX_UNSENT_SYNTHETICS_HOLDERS = 25;
    static final int MAX_SYNTHETIC_EVENTS_PER_APP = 200;
    private LoadingCache<String, String> transactionNameCache;
    private List<Harvestable> harvestables = new ArrayList<Harvestable>();

    public TransactionEventsService() {
        super(TransactionEventsService.class.getSimpleName());
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.maxSamplesStored = TransactionEventsConfigUtils.getMaxSamplesStored(config);
        this.target = 10;
        this.enabled = TransactionEventsConfigUtils.isTransactionEventsEnabled(config, this.maxSamplesStored);
        this.isEnabledForApp.put(config.getApplicationName(), this.enabled);
        this.transactionNameCache = TransactionEventsService.createTransactionNameCache(this.maxSamplesStored);
    }

    public void setTransactionNameCache(int maxSamplesStoredFromHarvestable) {
        this.transactionNameCache = TransactionEventsService.createTransactionNameCache(maxSamplesStoredFromHarvestable);
    }

    public void addHarvestableToService(String appName) {
        TransactionEventHarvestableImpl harvestable = new TransactionEventHarvestableImpl(this, appName);
        ServiceFactory.getHarvestService().addHarvestable(harvestable);
        this.harvestables.add(harvestable);
    }

    private static LoadingCache<String, String> createTransactionNameCache(int maxSamplesStored) {
        return CacheBuilder.newBuilder().maximumSize(maxSamplesStored).expireAfterAccess(5L, TimeUnit.MINUTES).build(new CacheLoader<String, String>(){

            @Override
            public String load(String key) throws Exception {
                return key;
            }
        });
    }

    @VisibleForTesting
    public void configureHarvestables(Map<String, Object> config) {
        for (Harvestable h : this.harvestables) {
            h.configure(config);
        }
    }

    public void clearReservoirForApp() {
        this.reservoirForApp.clear();
    }

    public void harvestPendingEvents() {
        for (String appName : this.reservoirForApp.keySet()) {
            this.harvest(appName);
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.enabled) {
            ServiceFactory.getTransactionService().addTransactionListener(this);
            ServiceFactory.getConfigService().addIAgentConfigListener(this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.removeHarvestables();
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        ServiceFactory.getConfigService().removeIAgentConfigListener(this);
        this.reservoirForApp.clear();
    }

    private void removeHarvestables() {
        for (Harvestable harvestable : this.harvestables) {
            ServiceFactory.getHarvestService().removeHarvestable(harvestable);
        }
    }

    public void setMaxSamplesStored(int newMax) {
        this.maxSamplesStored = newMax;
    }

    public void harvest(final String appName) {
        long startTimeInNanos = System.nanoTime();
        this.beforeHarvestSynthetics(appName);
        DistributedSamplingAwareReservoir<TransactionEvent> currentReservoir = this.reservoirForApp.get(appName);
        int seenLast = this.adaptiveSampling(currentReservoir);
        final DistributedSamplingAwareReservoir reservoirToSend = this.reservoirForApp.put(appName, new DistributedSamplingAwareReservoir(this.maxSamplesStored, seenLast, this.target));
        if (reservoirToSend != null && reservoirToSend.size() > 0) {
            try {
                ServiceFactory.getRPMService(appName).sendAnalyticsEvents(this.maxSamplesStored, reservoirToSend.getNumberOfTries(), Collections.unmodifiableList(reservoirToSend));
                final long durationInNanos = System.nanoTime() - startTimeInNanos;
                ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

                    @Override
                    public void doWork(StatsEngine statsEngine) {
                        TransactionEventsService.this.recordSupportabilityMetrics(statsEngine, durationInNanos, reservoirToSend);
                    }

                    @Override
                    public String getAppName() {
                        return appName;
                    }
                });
            }
            catch (Exception e) {
                Agent.LOG.fine("Unable to send events for regular transactions. This operation will be retried.");
                currentReservoir = this.reservoirForApp.get(appName);
                currentReservoir.retryAll(reservoirToSend);
            }
        }
    }

    private void recordSupportabilityMetrics(StatsEngine statsEngine, long durationInNanos, ReservoirSampledArrayList<TransactionEvent> reservoir) {
        statsEngine.getStats("Supportability/Events/TransactionEvent/Sent").incrementCallCount(reservoir.size());
        statsEngine.getStats("Supportability/Events/TransactionEvent/Seen").incrementCallCount(reservoir.getNumberOfTries());
        statsEngine.getResponseTimeStats("Supportability/EventHarvest/TransactionEvent/transmit").recordResponseTime(durationInNanos, TimeUnit.NANOSECONDS);
    }

    private void beforeHarvestSynthetics(String appName) {
        FixedSizeArrayList<TransactionEvent> toSend;
        DistributedSamplingAwareReservoir<TransactionEvent> currentReservoir = this.syntheticsListForApp.get(appName);
        int seenLast = this.adaptiveSampling(currentReservoir);
        DistributedSamplingAwareReservoir current = this.syntheticsListForApp.put(appName, new DistributedSamplingAwareReservoir(200, seenLast, this.target));
        if (current != null && current.size() > 0) {
            if (this.pendingSyntheticsArrays.size() < 25) {
                this.pendingSyntheticsArrays.add(current);
            } else {
                Agent.LOG.fine("Some synthetic transaction events were discarded.");
            }
        }
        int maxToSend = 5;
        for (int nSent = 0; nSent < 5 && (toSend = this.pendingSyntheticsArrays.poll()) != null; ++nSent) {
            try {
                ServiceFactory.getRPMService(appName).sendAnalyticsEvents(200, toSend.size(), Collections.unmodifiableList(toSend));
                ++nSent;
                continue;
            }
            catch (Exception e) {
                Agent.LOG.fine("Unable to send events for synthetic transactions. This operation will be retried.");
                this.pendingSyntheticsArrays.add(toSend);
                break;
            }
        }
    }

    private int adaptiveSampling(DistributedSamplingAwareReservoir<TransactionEvent> currentReservoir) {
        int seenLast = this.target << 8;
        if (currentReservoir != null && currentReservoir.size() > 0) {
            seenLast = currentReservoir.getSeenLast();
            int seen = currentReservoir.getNumberOfTries();
            int recorded = currentReservoir.getRecorded();
            if (seen > 0) {
                Agent.LOG.log(Level.FINE, "Saw {0} events, sampled {1} of them with a target of {2}, saw {3} last time", seen, recorded, this.target, seenLast);
            }
            if ((seenLast = seen) == 0) {
                seenLast = this.target << 8;
            }
        }
        return seenLast;
    }

    private boolean getIsEnabledForApp(AgentConfig config, String currentAppName) {
        Boolean appEnabled = (Boolean)this.isEnabledForApp.get(currentAppName);
        if (appEnabled == null) {
            appEnabled = TransactionEventsConfigUtils.isTransactionEventsEnabled(config, TransactionEventsConfigUtils.getMaxSamplesStored(config));
            this.isEnabledForApp.put(currentAppName, appEnabled);
        }
        return appEnabled;
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        Integer slot;
        String name = transactionData.getApplicationName();
        if (!this.getIsEnabledForApp(transactionData.getAgentConfig(), name)) {
            this.reservoirForApp.remove(name);
            return;
        }
        boolean persisted = false;
        if (transactionData.isSyntheticTransaction()) {
            DistributedSamplingAwareReservoir<TransactionEvent> currentSyntheticsList = this.syntheticsListForApp.get(name);
            while (currentSyntheticsList == null) {
                this.syntheticsListForApp.putIfAbsent(name, new DistributedSamplingAwareReservoir(200, this.target << 8, this.target));
                currentSyntheticsList = this.syntheticsListForApp.get(name);
            }
            slot = currentSyntheticsList.getSlot(transactionData.getSampled());
            if (slot != null) {
                currentSyntheticsList.set(slot, TransactionEventsService.createEvent(transactionData, transactionStats, this.getMetricName(transactionData)));
                persisted = true;
            } else if (transactionData.getSampled()) {
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/Sampled/Synthetics/Full");
            }
            String msg = MessageFormat.format("Added Synthetics transaction event: {0}, persisted: {1}", transactionData, persisted);
            Agent.LOG.finest(msg);
        }
        if (!persisted) {
            DistributedSamplingAwareReservoir<TransactionEvent> currentReservoir = this.reservoirForApp.get(name);
            while (currentReservoir == null) {
                this.reservoirForApp.putIfAbsent(name, new DistributedSamplingAwareReservoir(this.maxSamplesStored, this.target << 8, this.target));
                currentReservoir = this.reservoirForApp.get(name);
            }
            slot = currentReservoir.getSlot(transactionData.getSampled());
            if (slot != null) {
                currentReservoir.set(slot, TransactionEventsService.createEvent(transactionData, transactionStats, this.getMetricName(transactionData)));
            } else if (transactionData.getSampled()) {
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/Sampled/Full");
            }
        }
    }

    private String getMetricName(TransactionData transactionData) {
        String metricName = transactionData.getBlameOrRootMetricName();
        try {
            metricName = this.transactionNameCache.get(metricName);
        }
        catch (ExecutionException e) {
            Agent.LOG.finest("Error fetching cached transaction name: " + e.toString());
        }
        return metricName;
    }

    public static TransactionEvent createEvent(TransactionData transactionData, TransactionStats transactionStats, String metricName) {
        PriorityTransactionName transactionName;
        String otherCategory;
        long startTime = transactionData.getWallClockStartTimeMs();
        long durationInNanos = transactionData.getLegacyDuration();
        boolean distributedTracingEnabled = ServiceFactory.getDistributedTraceService().isEnabled();
        Integer port = ServiceFactory.getEnvironmentService().getEnvironment().getAgentIdentity().getServerPort();
        String subType = "Web";
        if (!transactionData.isWebTransaction() && (otherCategory = (transactionName = transactionData.getPriorityTransactionName()).getCategory()) != null) {
            subType = otherCategory;
        }
        TransactionEventBuilder eventBuilder = new TransactionEventBuilder().setAppName(transactionData.getApplicationName()).setSubType(subType).setTimestamp(startTime).setName(metricName).setDuration((float)durationInNanos / 1.0E9f).setGuid(transactionData.getGuid()).setReferringGuid(transactionData.getReferrerGuid()).setPort(port).setTripId(transactionData.getTripId()).setReferringPathHash(transactionData.getReferringPathHash()).setAlternatePathHashes(transactionData.getAlternatePathHashes()).setApdexPerfZone(transactionData.getApdexPerfZone()).setSyntheticsResourceId(transactionData.getSyntheticsResourceId()).setSyntheticsMonitorId(transactionData.getSyntheticsMonitorId()).setSyntheticsJobId(transactionData.getSyntheticsJobId()).setError(transactionData.hasReportableErrorThatIsNotIgnored()).setpTotalTime((float)transactionData.getTransactionTime().getTotalSumTimeInNanos() / 1.0E9f).setTimeoutCause(transactionData.getTransaction().getTimeoutCause());
        if (distributedTracingEnabled) {
            eventBuilder = eventBuilder.setInboundDistributedTracePayload(transactionData.getInboundDistributedTracePayload()).setCallerType(transactionData.callerType()).setCallerApp(transactionData.getCallerApp()).setCallerAccountId(transactionData.getCallerAccountId()).setTransportType(transactionData.getTransportType()).setCallerHost(transactionData.getCallerHost()).setTransportDuration(transactionData.getTransportDurationInMillis()).setTransportDurationIntermediary(transactionData.getTransportDurationIntermediaryInMillis()).setLarquestTransportDuration(transactionData.getLargestTransportDurationInMillis()).setSampled(transactionData.getSampled()).setDepth(transactionData.getDepth()).setOrder(transactionData.getOrder()).setParentIds(transactionData.getParentIds());
        }
        TransactionEvent event = eventBuilder.createTransactionEvent();
        if (transactionData.getTransactionTime().getTimeToFirstByteInNanos() > 0L) {
            event.timeToFirstByte = (float)transactionData.getTransactionTime().getTimeToFirstByteInNanos() / 1.0E9f;
        }
        if (transactionData.getTransactionTime().getTimetoLastByteInNanos() > 0L) {
            event.timeToLastByte = (float)transactionData.getTransactionTime().getTimetoLastByteInNanos() / 1.0E9f;
        }
        if (transactionData.getTripId() != null) {
            event.pathHash = transactionData.generatePathHash();
        }
        event.queueDuration = TransactionEventsService.retrieveMetricIfExists(transactionStats, "WebFrontend/QueueTime").getTotal();
        event.externalDuration = TransactionEventsService.retrieveMetricIfExists(transactionStats, "External/all").getTotal();
        event.externalCallCount = TransactionEventsService.retrieveMetricIfExists(transactionStats, "External/all").getCallCount();
        event.databaseDuration = TransactionEventsService.retrieveMetricIfExists(transactionStats, "Datastore/all").getTotal();
        event.databaseCallCount = TransactionEventsService.retrieveMetricIfExists(transactionStats, "Datastore/all").getCallCount();
        event.gcCumulative = TransactionEventsService.retrieveMetricIfExists(transactionStats, "GC/cumulative").getTotal();
        if (ServiceFactory.getAttributesService().isAttributesEnabledForEvents(transactionData.getApplicationName())) {
            event.userAttributes = transactionData.getUserAttributes();
            event.agentAttributes = transactionData.getAgentAttributes();
            event.agentAttributes.putAll(AttributesUtils.appendAttributePrefixes(transactionData.getPrefixedAttributes()));
        }
        return event;
    }

    private static CountStats retrieveMetricIfExists(TransactionStats transactionStats, String metricName) {
        if (!transactionStats.getUnscopedStats().getStatsMap().containsKey(metricName)) {
            return NoCallCountStats.NO_STATS;
        }
        return transactionStats.getUnscopedStats().getResponseTimeStats(metricName);
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        this.isEnabledForApp.remove(appName);
    }

    public ReservoirSampledArrayList<TransactionEvent> unsafeGetEventData(String appName) {
        return this.reservoirForApp.get(appName);
    }

    public DistributedSamplingAwareReservoir<TransactionEvent> getDistributedSamplingReservoir(String appName) {
        return this.reservoirForApp.get(appName);
    }

    public DistributedSamplingAwareReservoir<TransactionEvent> getSyntheticDistributedSamplingReservoir(String appName) {
        return this.syntheticsListForApp.get(appName);
    }

    private static class NoCallCountStats
    extends AbstractStats {
        static final NoCallCountStats NO_STATS = new NoCallCountStats();

        private NoCallCountStats() {
        }

        @Override
        public float getTotal() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getTotalExclusiveTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getMinCallTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getMaxCallTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public double getSumOfSquares() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void reset() {
        }

        @Override
        public void merge(StatsBase stats) {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return NO_STATS;
        }
    }
}

