/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.FixedSizeArrayList;
import com.newrelic.agent.service.analytics.ReservoirSampledArrayList;
import com.newrelic.agent.service.analytics.SegmentEvent;
import com.newrelic.agent.stats.StatsEngine;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;

public class SegmentEventService
extends AbstractService
implements Service,
HarvestListener {
    private static final int MAX_SEGMENT_EVENT_PER_HARVEST = 2500;
    private final ConcurrentHashMap<String, ReservoirSampledArrayList<SegmentEvent>> reservoirForApp = new ConcurrentHashMap();
    private final ArrayDeque<FixedSizeArrayList<SegmentEvent>> pendingSegmentEvents = new ArrayDeque();

    public SegmentEventService(String name) {
        super(name);
    }

    public SegmentEventService() {
        this(SegmentEventService.class.getName());
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        FixedSizeArrayList<SegmentEvent> toSend;
        ReservoirSampledArrayList current = this.reservoirForApp.put(appName, new ReservoirSampledArrayList(2500));
        if (current != null && current.size() > 0) {
            if (this.pendingSegmentEvents.size() < 25) {
                this.pendingSegmentEvents.add(current);
            } else {
                Agent.LOG.fine(MessageFormat.format("{0} segment events were discarded.", this.pendingSegmentEvents.size()));
                statsEngine.getStats("Supportability/SegmentEvents/Discarded").incrementCallCount(this.pendingSegmentEvents.size());
            }
        }
        int maxToSend = 5;
        for (int nSent = 0; nSent < 5 && (toSend = this.pendingSegmentEvents.poll()) != null; ++nSent) {
            try {
                ServiceFactory.getRPMService(appName).sendSegmentEvents(2500, toSend.size(), toSend);
                statsEngine.getStats("Supportability/SegmentEvents/TotalEventsSent").incrementCallCount(toSend.size());
                statsEngine.getStats("Supportability/SegmentEvents/TotalEventsSeen").incrementCallCount(toSend.getNumberOfTries());
                ++nSent;
                continue;
            }
            catch (Exception e) {
                Agent.LOG.fine("Unable to send segment events. This operation will be retried.");
                this.pendingSegmentEvents.add(toSend);
                break;
            }
        }
    }

    @Override
    public void afterHarvest(String appName) {
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
        this.reservoirForApp.clear();
    }

    public void addSegmentEvent(SegmentEvent event) {
        ReservoirSampledArrayList<SegmentEvent> reservoir = this.reservoirForApp.get(event.getAppName());
        while (reservoir == null) {
            this.reservoirForApp.putIfAbsent(event.getAppName(), new ReservoirSampledArrayList(2500));
            reservoir = this.reservoirForApp.get(event.getAppName());
        }
        Integer slot = reservoir.getSlot();
        if (slot != null) {
            reservoir.set(slot, event);
        }
    }
}

