/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.CustomInsightsEvent;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;

public class SegmentEvent
extends CustomInsightsEvent {
    private static final String TYPE = "SegmentEvent";
    private final String appName;
    private final String id;
    private final String parentId;
    private final String tripId;
    private final String name;
    private final float duration;
    private final Map<String, Object> distributedTraceIntrinsics;

    private SegmentEvent(String appName, long timestamp, String id, String parentId, String tripId, String name, float duration, Map<String, Object> distributedTraceIntrinsics, Map<String, Object> userAttributes) {
        super(TYPE, timestamp, userAttributes == null ? Maps.newHashMap() : userAttributes);
        this.appName = appName;
        this.id = id;
        this.parentId = parentId;
        this.tripId = tripId;
        this.name = name;
        this.duration = duration;
        this.distributedTraceIntrinsics = distributedTraceIntrinsics;
        this.userAttributes.put("name", name);
        this.userAttributes.put("duration", Float.valueOf(duration));
        this.userAttributes.put("nr.guid", id);
        this.userAttributes.put("nr.tripId", tripId);
        this.userAttributes.put("nr.parentId", parentId);
    }

    public static SegmentEventBuilder builder() {
        return new SegmentEventBuilder();
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        super.writeJSONString(out);
    }

    private Map<String, ?> getFilteredMap(Map<String, Object> input) {
        return ServiceFactory.getAttributesService().filterEventAttributes(this.appName, input);
    }

    private Map<String, ?> getUserFilteredMap(Map<String, Object> input) {
        if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
            return this.getFilteredMap(input);
        }
        return Collections.emptyMap();
    }

    public String getAppName() {
        return this.appName;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getTripId() {
        return this.tripId;
    }

    public String getName() {
        return this.name;
    }

    public float getDuration() {
        return this.duration;
    }

    public Map<String, Object> getUserAttributes() {
        return this.userAttributes;
    }

    public static class SegmentEventBuilder {
        private long timestamp;
        private String id;
        private String parentId;
        private String tripId;
        private String name;
        private float duration;
        private Map<String, Object> distributedTraceIntrinsics;
        private String appName;
        private Map<String, Object> userAttributes;

        public SegmentEventBuilder setStartTime(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SegmentEventBuilder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public SegmentEventBuilder setId(String id) {
            this.id = id;
            return this;
        }

        public SegmentEventBuilder setParentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public SegmentEventBuilder setTripId(String tripId) {
            this.tripId = tripId;
            return this;
        }

        public SegmentEventBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public SegmentEventBuilder setDuration(float duration) {
            this.duration = duration;
            return this;
        }

        public SegmentEventBuilder setDistributedTraceIntrinsics(Map<String, Object> distributedTraceIntrinsics) {
            this.distributedTraceIntrinsics = distributedTraceIntrinsics;
            return this;
        }

        public SegmentEventBuilder setCustomAttributes(Map<String, Object> userAttributes) {
            this.userAttributes = userAttributes;
            return this;
        }

        public SegmentEvent build() {
            return new SegmentEvent(this.appName, this.timestamp, this.id, this.parentId, this.tripId, this.name, this.duration, this.distributedTraceIntrinsics, this.userAttributes);
        }
    }
}

