/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Harvestable;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.CustomInsightsEventsConfigUtils;
import com.newrelic.agent.service.analytics.InsightsServiceImpl;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.StatsWorks;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class InsightsHarvestableImpl
implements Harvestable {
    private long lastHarvest;
    private InsightsServiceImpl insightsService;
    private String appName;

    InsightsHarvestableImpl(InsightsServiceImpl insightsService, String appName) {
        this.insightsService = insightsService;
        this.appName = appName;
        this.lastHarvest = System.nanoTime();
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public String getEndpointMethodName() {
        return "custom_event_data";
    }

    @Override
    public void harvest() {
        this.recordIntervalMetric();
        this.insightsService.harvest(this.appName);
    }

    private void recordIntervalMetric() {
        long startTimeInNanos = System.nanoTime();
        final long harvestIntervalInNanos = startTimeInNanos - this.lastHarvest;
        this.lastHarvest = startTimeInNanos;
        ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

            @Override
            public void doWork(StatsEngine statsEngine) {
                if (harvestIntervalInNanos > 0L) {
                    statsEngine.getResponseTimeStats("Supportability/EventHarvest/Customer/interval").recordResponseTime(harvestIntervalInNanos, TimeUnit.NANOSECONDS);
                }
            }

            @Override
            public String getAppName() {
                return InsightsHarvestableImpl.this.appName;
            }
        });
    }

    @Override
    public void configure(Map<String, Object> configuration) {
        Number maxSamplesCollector = (Number)configuration.get("max_samples_stored");
        int maxSamplesConfig = CustomInsightsEventsConfigUtils.getMaxSamplesStored(ServiceFactory.getConfigService().getDefaultAgentConfig());
        int maxSamples = maxSamplesCollector != null ? Math.min(maxSamplesCollector.intValue(), maxSamplesConfig) : maxSamplesConfig;
        Number reportPeriod = (Number)configuration.get("report_period_in_seconds");
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork("Supportability/Events/Customer/ReportPeriod", reportPeriod.intValue()));
        if (maxSamples != maxSamplesConfig) {
            maxSamplesConfig = maxSamples;
            this.insightsService.setMaxSamplesStored(maxSamplesConfig);
            this.insightsService.harvestPendingEvents();
            this.insightsService.clearReservoirForApp();
        }
    }
}

