/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.service.analytics.ReservoirSampledArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DistributedSamplingAwareReservoir<E>
extends ReservoirSampledArrayList<E> {
    private static final Object VALUE_PLACEHOLDER = new Object();
    private final Map<Integer, Object> nonSampledSlots = new ConcurrentHashMap<Integer, Object>();
    private final AtomicInteger recorded = new AtomicInteger(0);
    private final int seenLast;
    private final int target;

    public DistributedSamplingAwareReservoir(int reservoirSize, int seenLast, int target) {
        super(reservoirSize);
        this.seenLast = seenLast;
        this.target = target;
    }

    public void retryAll(DistributedSamplingAwareReservoir<E> source) {
        for (int i = 0; i < source.size(); ++i) {
            Integer slot = this.getSlot(!this.nonSampledSlots.containsKey(i));
            if (slot == null) continue;
            Object element = source.get(i);
            this.set(slot, element);
        }
    }

    @Override
    public Integer getSlot() {
        return this.getSlot(false);
    }

    public Integer getSlot(boolean sampled) {
        int insertIndex;
        int currentCount = this.numberOfTries.incrementAndGet() - 1;
        if (currentCount < this.size) {
            insertIndex = currentCount;
            if (sampled) {
                this.recorded.incrementAndGet();
            } else {
                this.nonSampledSlots.put(insertIndex, VALUE_PLACEHOLDER);
            }
        } else if (sampled) {
            Integer nonSampledSlot = null;
            Iterator<Integer> slots = this.nonSampledSlots.keySet().iterator();
            if (slots.hasNext()) {
                nonSampledSlot = slots.next();
                slots.remove();
            }
            if (nonSampledSlot == null) {
                return null;
            }
            this.recorded.incrementAndGet();
            insertIndex = nonSampledSlot;
        } else {
            insertIndex = ((Random)RANDOM.get()).nextInt(currentCount);
            if (insertIndex >= this.size || !this.nonSampledSlots.containsKey(insertIndex)) {
                return null;
            }
        }
        return insertIndex;
    }

    @Override
    public void clear() {
        super.clear();
        this.nonSampledSlots.clear();
    }

    public boolean full() {
        return this.size() == this.size;
    }

    public int getRecorded() {
        return this.recorded.get();
    }

    public int getSeenLast() {
        return this.seenLast;
    }

    public int getTarget() {
        return this.target;
    }
}

