/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ProfilingTask;
import com.newrelic.agent.profile.ProfilingTaskController;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.management.ManagementFactory;

public abstract class AbstractController
implements ProfilingTaskController {
    static int MAX_SAMPLE_PERIOD_IN_MILLIS = 6400;
    static int MIN_SAMPLE_PERIOD_IN_MILLIS = 100;
    static float TARGET_UTILIZATION = 0.02f;
    private final ProfilingTask delegate;
    private final int processorCount;
    private int samplePeriodInMillis = -1;

    public AbstractController(ProfilingTask delegate) {
        this.delegate = delegate;
        this.processorCount = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    }

    protected int getProcessorCount() {
        return this.processorCount;
    }

    abstract int doCalculateSamplePeriodInMillis();

    @Override
    public int getSamplePeriodInMillis() {
        if (this.samplePeriodInMillis == -1) {
            return MIN_SAMPLE_PERIOD_IN_MILLIS;
        }
        return this.samplePeriodInMillis;
    }

    private void calculateSamplePeriodInMillis() {
        if (this.samplePeriodInMillis == -1) {
            return;
        }
        int nSamplePeriodInMillis = this.doCalculateSamplePeriodInMillis();
        nSamplePeriodInMillis = nSamplePeriodInMillis > this.samplePeriodInMillis ? this.samplePeriodInMillis * 2 : (nSamplePeriodInMillis <= this.samplePeriodInMillis / 4 ? this.samplePeriodInMillis / 2 : this.samplePeriodInMillis);
        this.samplePeriodInMillis = nSamplePeriodInMillis = Math.min(MAX_SAMPLE_PERIOD_IN_MILLIS, Math.max(nSamplePeriodInMillis, MIN_SAMPLE_PERIOD_IN_MILLIS));
    }

    @Override
    public void run() {
        this.delegate.run();
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        this.delegate.beforeHarvest(appName, statsEngine);
    }

    @Override
    public void afterHarvest(String appName) {
        this.calculateSamplePeriodInMillis();
        this.delegate.afterHarvest(appName);
    }

    @Override
    public void addProfile(ProfilerParameters parameters) {
        if (this.samplePeriodInMillis == -1) {
            this.samplePeriodInMillis = parameters.getSamplePeriodInMillis().intValue();
        }
        this.delegate.addProfile(parameters);
    }

    @Override
    public void removeProfile(ProfilerParameters parameters) {
        this.delegate.removeProfile(parameters);
    }

    ProfilingTask getDelegate() {
        return this.delegate;
    }
}

