/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.instrumentation.weaver.AgentWeaverListener;
import com.newrelic.agent.instrumentation.weaver.errorhandler.LogAndReturnOriginal;
import com.newrelic.agent.instrumentation.weaver.extension.ExtensionHolderFactoryImpl;
import com.newrelic.agent.instrumentation.weaver.extension.GuavaBackedExtensionClass;
import com.newrelic.agent.instrumentation.weaver.preprocessors.AgentPostprocessors;
import com.newrelic.agent.instrumentation.weaver.preprocessors.AgentPreprocessors;
import com.newrelic.agent.instrumentation.weaver.preprocessors.TracedWeaveInstrumentationTracker;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.api.agent.weaver.WeaveIntoAllMethods;
import com.newrelic.api.agent.weaver.internal.WeavePackageType;
import com.newrelic.bootstrap.BootstrapAgent;
import com.newrelic.weave.ClassWeave;
import com.newrelic.weave.utils.BootstrapLoader;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassInformation;
import com.newrelic.weave.utils.ClassLoaderFinder;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.weavepackage.CachedWeavePackage;
import com.newrelic.weave.weavepackage.ClassWeavedListener;
import com.newrelic.weave.weavepackage.ExtensionClassTemplate;
import com.newrelic.weave.weavepackage.NewClassAppender;
import com.newrelic.weave.weavepackage.PackageValidationResult;
import com.newrelic.weave.weavepackage.PackageWeaveResult;
import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import com.newrelic.weave.weavepackage.WeavePackageManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;

public class ClassWeaverService
implements ClassMatchVisitorFactory,
ContextClassTransformer {
    private static final int PARTITIONS = 8;
    private static ClassNode EXTENSION_TEMPLATE;
    private final ConcurrentMap<String, Set<TracedWeaveInstrumentationTracker>> tracedWeaveInstrumentationDetails = Maps.newConcurrentMap();
    private final AgentWeaverListener listener = new AgentWeaverListener();
    private final WeavePackageManager weavePackageManager;
    private final Set<String> internalWeavePackages = Sets.newConcurrentHashSet();
    private final Map<String, String> externalWeavePackages = Maps.newConcurrentMap();
    private final InstrumentationContextManager contextManager;
    private final ConcurrentMap<ClassLoader, ClassCache> retransformCaches = Maps.newConcurrentMap();
    private volatile boolean isRetransforming = false;

    public ClassWeaverService(InstrumentationContextManager contextManager) {
        this.contextManager = contextManager;
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        ClassTransformerConfig config = agentConfig.getClassTransformerConfig();
        this.weavePackageManager = new WeavePackageManager(this.listener, contextManager.getInstrumentation(), config.getMaxPreValidatedClassLoaders(), config.preValidateWeavePackages(), config.preMatchWeaveMethods());
    }

    public void registerInstrumentation() {
        this.loadInternalWeavePackages();
        this.loadExternalWeavePackages(ServiceFactory.getExtensionService().getWeaveExtensions());
        this.contextManager.addContextClassTransformer(this, this);
    }

    public Runnable createRetransformRunnable(Class<?>[] loadedClasses) {
        return new RetransformRunnable(loadedClasses);
    }

    private WeavePackage createWeavePackage(InputStream inputStream, String source) throws Exception {
        Boolean jcacheDatastoreEnabled;
        JarInputStream jarStream = new JarInputStream(inputStream);
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        WeavePackageConfig weavePackageConfig = this.createWeavePackageConfig(jarStream, source, this.contextManager.getInstrumentation(), WeavePackageType.INTERNAL, agentConfig);
        ClassTransformerConfig classTransformerConfig = agentConfig.getClassTransformerConfig();
        String weavePackageName = weavePackageConfig.getName();
        if (!classTransformerConfig.isWeavePackageEnabled(weavePackageConfig)) {
            Agent.LOG.log(Level.INFO, "Instrumentation {0} is disabled. Skipping.", weavePackageName);
            return null;
        }
        Agent.LOG.log(Level.INFO, "Instrumentation {0} is enabled. Loading.", weavePackageName);
        if ("com.newrelic.instrumentation.jcache-1.0.0".equals(weavePackageName) && (jcacheDatastoreEnabled = (Boolean)agentConfig.getValue("class_transformer.com.newrelic.instrumentation.jcache-datastore-1.0.0.enabled", Boolean.FALSE)).booleanValue()) {
            Agent.LOG.log(Level.INFO, " Instrumentation {0} is disabled since {1} is enabled. Skipping.", weavePackageName, "com.newrelic.instrumentation.jcache-datastore-1.0.0");
            return null;
        }
        WeavePackage weavePackage = CachedWeavePackage.createWeavePackage(new URL(source), jarStream, weavePackageConfig);
        return weavePackage;
    }

    private WeavePackageConfig createWeavePackageConfig(JarInputStream jarStream, String source, Instrumentation instrumentation, WeavePackageType type, AgentConfig agentConfig) throws Exception {
        AgentPreprocessors preprocessors = new AgentPreprocessors(agentConfig, this.tracedWeaveInstrumentationDetails);
        AgentPostprocessors postprocessors = new AgentPostprocessors();
        WeavePackageConfig result = WeavePackageConfig.builder().source(source).jarInputStream(jarStream).weavePreprocessor(preprocessors).weavePostprocessor(postprocessors).errorHandleClassNode(LogAndReturnOriginal.ERROR_HANDLER_NODE).extensionClassTemplate(EXTENSION_TEMPLATE).build();
        preprocessors.setInstrumentationTitle(result.getName());
        if (result.getVendorId() != null) {
            type = WeavePackageType.FIELD;
        }
        postprocessors.setWeavePackageType(type);
        return result;
    }

    public void registerInstrumentationCloseable(String instrumentationName, Closeable closeable) {
        WeavePackage weavePackage = this.weavePackageManager.getWeavePackage(instrumentationName);
        this.listener.registerInstrumentationCloseable(instrumentationName, weavePackage, closeable);
    }

    private Collection<ClassMatchVisitorFactory> loadInternalWeavePackages() {
        Set<ClassMatchVisitorFactory> matchers = Sets.newConcurrentHashSet();
        Collection<String> jarFileNames = AgentJarHelper.findAgentJarFileNames(Pattern.compile("instrumentation\\/(.*).jar"));
        if (jarFileNames.isEmpty()) {
            Agent.LOG.log(Level.SEVERE, "No instrumentation packages were found in the agent.");
        } else {
            Agent.LOG.log(Level.FINE, "Loading {0} instrumentation packages", jarFileNames.size());
        }
        int partitions = jarFileNames.size() < 8 ? jarFileNames.size() : 8;
        final CountDownLatch executorCountDown = new CountDownLatch(partitions);
        List<Set<String>> weavePackagePartitions = this.partitionInstrumentationJars(jarFileNames, partitions);
        for (final Set<String> weavePackageJars : weavePackagePartitions) {
            Runnable loadWeavePackagesRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (String name : weavePackageJars) {
                            URL instrumentationUrl = BootstrapAgent.class.getResource('/' + name);
                            if (instrumentationUrl == null) {
                                Agent.LOG.error("Unable to find instrumentation jar: " + name);
                                continue;
                            }
                            InputStream inputStream = null;
                            try {
                                inputStream = instrumentationUrl.openStream();
                                WeavePackage internalWeavePackage = ClassWeaverService.this.createWeavePackage(inputStream, instrumentationUrl.toExternalForm());
                                if (null == internalWeavePackage) {
                                    Agent.LOG.log(Level.FINEST, "internal weave package: {0} was null", instrumentationUrl.toExternalForm());
                                    continue;
                                }
                                if (internalWeavePackage.getPackageViolations().size() > 0) {
                                    Agent.LOG.log(Level.FINER, "skip loading weave package: {0}", internalWeavePackage.getName());
                                    for (WeaveViolation violation : internalWeavePackage.getPackageViolations()) {
                                        Agent.LOG.log(Level.FINER, "\t violation: {0}", violation);
                                    }
                                    continue;
                                }
                                Agent.LOG.log(Level.FINER, "adding weave package: {0}", internalWeavePackage.getName());
                                ClassWeaverService.this.internalWeavePackages.add(internalWeavePackage.getName());
                                ClassWeaverService.this.weavePackageManager.register(internalWeavePackage);
                            }
                            catch (Throwable t) {
                                Agent.LOG.log(Level.FINER, t, "unable to load weave package jar {0}", instrumentationUrl);
                            }
                            finally {
                                if (null == inputStream) continue;
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    catch (Throwable t) {
                        Agent.LOG.log(Level.FINER, t, "A thread loading weaved packages threw an error");
                    }
                    finally {
                        executorCountDown.countDown();
                    }
                }
            };
            new Thread(loadWeavePackagesRunnable).start();
        }
        try {
            executorCountDown.await();
            Agent.LOG.log(Level.FINE, "Loaded {0} internal instrumentation packages", this.internalWeavePackages.size());
        }
        catch (InterruptedException e) {
            Agent.LOG.log(Level.FINE, e, "Interrupted while waiting for instrumentation packages.");
        }
        return matchers;
    }

    private List<Set<String>> partitionInstrumentationJars(Collection<String> jarFileNames, int partitions) {
        ArrayList<Set<String>> instrumentationPartitions = new ArrayList<Set<String>>(partitions);
        for (int i = 0; i < partitions; ++i) {
            instrumentationPartitions.add(new HashSet());
        }
        int index = 0;
        for (String jarFileName : jarFileNames) {
            ((Set)instrumentationPartitions.get(index++ % partitions)).add(jarFileName);
        }
        return instrumentationPartitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ClassMatchVisitorFactory> loadExternalWeavePackages(Collection<File> weaveExtensions) {
        HashSet<ClassMatchVisitorFactory> matchers = Sets.newHashSet();
        for (File weaveExtension : weaveExtensions) {
            ZipInputStream stream = null;
            try {
                WeavePackage externalPackage;
                stream = new JarInputStream(new FileInputStream(weaveExtension));
                AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
                WeavePackageConfig weaveConfig = this.createWeavePackageConfig((JarInputStream)stream, weaveExtension.getAbsolutePath(), this.contextManager.getInstrumentation(), WeavePackageType.CUSTOM, agentConfig);
                ClassTransformerConfig classTransformerConfig = agentConfig.getClassTransformerConfig();
                String instrName = weaveConfig.getName();
                if (this.weavePackageManager.isRegistered(instrName)) {
                    this.weavePackageManager.deregister(instrName);
                    this.externalWeavePackages.remove(weaveExtension.getAbsolutePath());
                    if (classTransformerConfig.isWeavePackageEnabled(weaveConfig)) {
                        Agent.LOG.log(Level.INFO, "Instrumentation {0} is currently loaded. Reloading.", instrName);
                    } else {
                        Agent.LOG.log(Level.INFO, "Instrumentation {0} is disabled. Unloading.", instrName);
                        continue;
                    }
                }
                if ((externalPackage = WeavePackage.createWeavePackage((JarInputStream)stream, weaveConfig)).getPackageViolations().size() > 0) {
                    Agent.LOG.log(Level.FINER, "skip loading external weave package: {0}", instrName);
                    for (WeaveViolation violation : externalPackage.getPackageViolations()) {
                        Agent.LOG.log(Level.FINER, "\t{0}", violation);
                    }
                    continue;
                }
                this.weavePackageManager.register(externalPackage);
                this.externalWeavePackages.put(weaveExtension.getAbsolutePath(), weaveConfig.getName());
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINE, e, "Error reading weave extension {0}", weaveExtension.getAbsolutePath());
            }
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return matchers;
    }

    private Collection<ClassMatchVisitorFactory> unloadExternalWeavePackages(Set<String> removedFilePaths) {
        Agent.LOG.log(Level.INFO, "ClassWeaveService removing {0} weave packages.", removedFilePaths.size());
        HashSet<ClassMatchVisitorFactory> matchers = Sets.newHashSetWithExpectedSize(removedFilePaths.size());
        for (String removedFilePath : removedFilePaths) {
            String weavePackageName = this.externalWeavePackages.get(removedFilePath);
            if (this.internalWeavePackages.contains(weavePackageName)) {
                Agent.LOG.log(Level.FINER, "Attempted to unload internal weave package {0} -- {1}. Ignoring request.", weavePackageName, removedFilePath);
                continue;
            }
            WeavePackage externalPackage = this.weavePackageManager.deregister(weavePackageName);
            if (null == externalPackage) {
                Agent.LOG.log(Level.FINER, "Attempted to unload non-existent weave package {0} -- {1}. Ignoring request.", weavePackageName, removedFilePath);
                continue;
            }
            this.externalWeavePackages.remove(removedFilePath);
        }
        return matchers;
    }

    public Runnable reloadExternalWeavePackages(Collection<File> newWeaveExtensions, Collection<File> removedWeaveExtensions) {
        this.loadExternalWeavePackages(newWeaveExtensions);
        HashSet<String> removedFilePaths = Sets.newHashSetWithExpectedSize(removedWeaveExtensions.size());
        for (File removedFile : removedWeaveExtensions) {
            removedFilePaths.add(removedFile.getAbsolutePath());
        }
        this.unloadExternalWeavePackages(removedFilePaths);
        Class[] loadedClasses = this.contextManager.getInstrumentation().getAllLoadedClasses();
        return this.createRetransformRunnable(loadedClasses);
    }

    private ClassCache getClassCache(ClassLoader loader) {
        ClassCache cache;
        if (null == loader) {
            loader = BootstrapLoader.PLACEHOLER;
        }
        if (this.isRetransforming) {
            if (!this.retransformCaches.containsKey(loader)) {
                if (loader == BootstrapLoader.PLACEHOLER) {
                    this.retransformCaches.putIfAbsent(loader, new ClassCache(BootstrapLoader.get()));
                } else {
                    this.retransformCaches.putIfAbsent(loader, new ClassCache(new ClassLoaderFinder(loader)));
                }
            }
            if (null == (cache = (ClassCache)this.retransformCaches.get(loader))) {
                cache = new ClassCache(new ClassLoaderFinder(loader));
            }
        } else {
            cache = loader == BootstrapLoader.PLACEHOLER ? new ClassCache(BootstrapLoader.get()) : new ClassCache(new ClassLoaderFinder(loader));
        }
        return cache;
    }

    @Override
    public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
        if (this.isRetransforming) {
            try {
                if (this.weavePackageManager.match(loader, reader.getClassName(), this.getClassCache(loader)).size() == 0) {
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        context.putMatch(this, null);
        return null;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, final InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        if (!PointCutClassTransformer.isValidClassName(className)) {
            return null;
        }
        ClassWeavedListener classWeavedCallback = new ClassWeavedListener(){

            @Override
            public void classWeaved(PackageWeaveResult weaveResult, ClassLoader classloader, ClassCache cache) {
                List<WeaveViolation> violations = weaveResult.getValidationResult().getViolations();
                if (!violations.isEmpty()) {
                    ClassWeaverService.logWeaveViolations(weaveResult.getValidationResult(), Level.FINE, classloader);
                    return;
                }
                String packageName = weaveResult.getValidationResult().getWeavePackage().getName();
                if (Agent.LOG.isFinerEnabled()) {
                    try {
                        if (Agent.LOG.isFinerEnabled()) {
                            ClassInformation weavedClass = cache.getClassInformation(weaveResult.getClassName());
                            Agent.LOG.log(Level.FINER, "{0} matched {1}", packageName, weavedClass.className);
                            for (String superName : weavedClass.getAllSuperNames(cache)) {
                                Agent.LOG.log(Level.FINER, "\ts: {0}", superName);
                            }
                            for (String interfaceName : weavedClass.getAllInterfaces(cache)) {
                                Agent.LOG.log(Level.FINER, "\ti: {0}", interfaceName);
                            }
                        }
                    }
                    catch (IOException ioe) {
                        Agent.LOG.log(Level.FINEST, ioe, "exception while getting supertype info");
                    }
                }
                if (weaveResult.weavedClass()) {
                    try {
                        Map<String, byte[]> annotationProxyClasses = weaveResult.getAnnotationProxyClasses();
                        if (!annotationProxyClasses.isEmpty()) {
                            if (BootstrapLoader.PLACEHOLER == classloader) {
                                NewClassAppender.appendClassesToBootstrapClassLoader(ClassWeaverService.this.contextManager.getInstrumentation(), annotationProxyClasses);
                            } else {
                                NewClassAppender.appendClasses(classloader, annotationProxyClasses);
                            }
                        }
                    }
                    catch (Exception e) {
                        Agent.LOG.log(Level.FINE, e, "Unable to add annotation proxy classes");
                    }
                    ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork(MessageFormat.format("Supportability/WeaveInstrumentation/WeaveClass/{0}/{1}", packageName, weaveResult.getClassName()), 1.0f));
                    for (String originalName : weaveResult.getWeavedMethods().keySet()) {
                        Agent.LOG.log(Level.FINE, "{0}: weaved target {1}-{2}", packageName, classloader, weaveResult.getClassName());
                        for (Method method : weaveResult.getWeavedMethods().get(originalName)) {
                            Agent.LOG.log(Level.FINE, "\t{0}.{1}:{2}", originalName, method.getName(), method.getDescriptor());
                            context.addWeavedMethod(method, packageName);
                        }
                        ClassWeaverService.addTraceInformation(ClassWeaverService.this.tracedWeaveInstrumentationDetails, packageName, context, weaveResult.getComposite(), originalName);
                    }
                } else {
                    Agent.LOG.log(Level.FINER, "{0} matched class {1} but no methods were weaved.", packageName, weaveResult.getClassName());
                }
            }
        };
        try {
            return this.weavePackageManager.weave(loader, this.getClassCache(loader), className, classfileBuffer, classWeavedCallback);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void addTraceInformation(ConcurrentMap<String, Set<TracedWeaveInstrumentationTracker>> weaveTraceDetailsTrackers, String weavePackageName, InstrumentationContext context, ClassNode composite, String originalClassName) {
        Set traceDetailsTrackers = (Set)weaveTraceDetailsTrackers.get(weavePackageName);
        if (null != traceDetailsTrackers) {
            for (TracedWeaveInstrumentationTracker traceDetails : traceDetailsTrackers) {
                if (!weavePackageName.equals(traceDetails.getWeavePackageName()) || !originalClassName.equals(traceDetails.getClassName())) continue;
                List<MethodNode> compositeMethods = ClassWeaverService.getMatches(composite, traceDetails);
                for (MethodNode compositeMethod : compositeMethods) {
                    Method bridgeTarget;
                    MethodNode bridgeTargetNode;
                    if ((compositeMethod.access & 0x40) != 0 && null != (bridgeTargetNode = WeaveUtils.findMatch(composite.methods, bridgeTarget = ClassWeave.whereDoesTheBridgeGo(compositeMethod)))) {
                        compositeMethod = bridgeTargetNode;
                    }
                    Agent.LOG.log(Level.FINER, "Writing TracedWeaveInstrumentation: {0} - {1}.{2}({3})", weavePackageName, composite.name, compositeMethod.name, compositeMethod.desc);
                    traceDetails.addToInstrumentationContext(context, new Method(compositeMethod.name, compositeMethod.desc));
                    TracedWeaveInstrumentationTracker.removeTraceAnnotations(compositeMethod);
                }
            }
        }
    }

    private static List<MethodNode> getMatches(ClassNode composite, TracedWeaveInstrumentationTracker traceDetails) {
        ArrayList<MethodNode> matches = Lists.newArrayList();
        if (traceDetails.isWeaveIntoAllMethods()) {
            for (MethodNode method : composite.methods) {
                List<AnnotationNode> methodAnnotations = WeaveUtils.getMethodAnnotations(method);
                for (AnnotationNode methodAnnotation : methodAnnotations) {
                    if (!Type.getType(WeaveIntoAllMethods.class).getDescriptor().equals(methodAnnotation.desc)) continue;
                    matches.add(method);
                }
            }
        } else {
            MethodNode match = WeaveUtils.findMatch(composite.methods, traceDetails.getMethod());
            if (match != null) {
                matches.add(match);
            }
        }
        return matches;
    }

    public WeavePackageManager getWeavePackageManger() {
        return this.weavePackageManager;
    }

    public static void logWeaveViolations(PackageValidationResult packageResult, Level weaveViolationLevel, ClassLoader classloader) {
        List<WeaveViolation> violations = packageResult.getViolations();
        Agent.LOG.log(weaveViolationLevel, "{0} - {1} violations against classloader {2}", packageResult.getWeavePackage().getName(), violations.size(), classloader);
        for (WeaveViolation violation : violations) {
            Agent.LOG.log(weaveViolationLevel, "WeaveViolation: {0}", violation.getType().name());
            Agent.LOG.log(weaveViolationLevel, "\t\tClass: {0}", violation.getClazz());
            if (violation.getMethod() != null) {
                Agent.LOG.log(weaveViolationLevel, "\t\tMethod: {0}", violation.getMethod());
            }
            if (violation.getField() != null) {
                Agent.LOG.log(weaveViolationLevel, "\t\tField: {0}", violation.getField());
            }
            Agent.LOG.log(weaveViolationLevel, "\t\tReason: {0}", violation.getType().getMessage());
        }
    }

    static {
        AgentBridge.extensionHolderFactory = new ExtensionHolderFactoryImpl();
        try {
            EXTENSION_TEMPLATE = WeaveUtils.convertToClassNode(WeaveUtils.getClassBytesFromClassLoaderResource(GuavaBackedExtensionClass.class.getName(), GuavaBackedExtensionClass.class.getClassLoader()));
        }
        catch (Exception e) {
            AgentBridge.getAgent().getLogger().log(Level.WARNING, (Throwable)e, "Unable to initialize custom extension class template. Falling back to default java NewField implementation");
            EXTENSION_TEMPLATE = ExtensionClassTemplate.DEFAULT_EXTENSION_TEMPLATE;
        }
    }

    private class RetransformRunnable
    implements Runnable {
        private final Class[] loadedClasses;

        public RetransformRunnable(Class[] loadedClasses) {
            this.loadedClasses = loadedClasses;
        }

        @Override
        public void run() {
            try {
                ClassWeaverService.this.isRetransforming = true;
                ServiceFactory.getClassTransformerService().retransformMatchingClassesImmediately(this.loadedClasses, Sets.newHashSet(ClassWeaverService.this));
            }
            finally {
                ClassWeaverService.this.isRetransforming = false;
                ClassWeaverService.this.retransformCaches.clear();
            }
        }
    }
}

