/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.heap;

import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.config.ClassHistogramConfig;
import com.newrelic.agent.heap.ClassHistogramHelper;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.ClassHistogramRowEvent;
import com.newrelic.agent.service.analytics.ClassHistogramStatsEvent;
import com.newrelic.agent.service.analytics.InternalCustomEventService;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassHistogramService
extends AbstractService
implements HarvestListener {
    private final ClassHistogramConfig classHistogramConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getClassHistogramConfig();
    private final Map<String, ClassHistogramRowEvent> lastHistogram = new HashMap<String, ClassHistogramRowEvent>();
    private int pid;

    public ClassHistogramService() {
        super(ClassHistogramService.class.getSimpleName());
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
    }

    @Override
    public void afterHarvest(String appName) {
        List<String> output = ClassHistogramHelper.runJmapCommand(this.classHistogramConfig.jmapPath(), this.pid);
        if (output != null) {
            this.sendHistogramData(appName, output);
            this.sendHistogramStats(appName, output);
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isEnabled() && ClassHistogramHelper.jmapExists(this.classHistogramConfig.jmapPath())) {
            String[] pidString;
            String name = ManagementFactory.getRuntimeMXBean().getName();
            if (name != null && !name.isEmpty() && (pidString = name.split("@")).length > 0 && !pidString[0].isEmpty()) {
                try {
                    Integer parsedPid = Integer.parseInt(pidString[0]);
                    if (parsedPid != null && parsedPid > 0) {
                        this.pid = parsedPid;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.pid > 0) {
                ServiceFactory.getHarvestService().addHarvestListener(this);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    @Override
    public boolean isEnabled() {
        return this.classHistogramConfig.enabled();
    }

    private void sendHistogramData(String appName, List<String> output) {
        InternalCustomEventService eventService = ServiceFactory.getServiceManager().getInternalCustomEventService();
        HashMap<String, ClassHistogramRowEvent> currentHistogram = new HashMap<String, ClassHistogramRowEvent>();
        int countOther = 0;
        for (String row : output) {
            if (countOther >= this.classHistogramConfig.classesPerHistogram()) break;
            String[] parts = ClassHistogramHelper.split(row);
            if (parts.length != 4) continue;
            Long classInstances = Long.parseLong(parts[1]);
            Long classBytes = Long.parseLong(parts[2]);
            String className = parts[3].trim().replaceAll(";", "");
            String classType = ClassHistogramHelper.getClassLabel(className);
            if (ClassHistogramHelper.isNewRelicJavaAgentClass(className)) continue;
            long classInstancesDelta = 0L;
            long classBytesDelta = 0L;
            ClassHistogramRowEvent lastEvent = this.lastHistogram.get(className);
            if (lastEvent != null) {
                classInstancesDelta = classInstances - lastEvent.getClassInstances();
                classBytesDelta = classBytes - lastEvent.getClassBytes();
            }
            ClassHistogramRowEvent rowEvent = new ClassHistogramRowEvent(appName, classInstances, classBytes, classInstancesDelta, classBytesDelta, className, classType);
            currentHistogram.put(className, rowEvent);
            eventService.addInternalCustomEvent(rowEvent);
            ++countOther;
        }
        this.lastHistogram.clear();
        this.lastHistogram.putAll(currentHistogram);
    }

    private void sendHistogramStats(String appName, List<String> output) {
        long totalObjects = 0L;
        long totalSize = 0L;
        for (String row : output) {
            String[] parts = ClassHistogramHelper.split(row);
            if (parts.length != 4) continue;
            totalObjects += Long.parseLong(parts[1]);
            totalSize += Long.parseLong(parts[2]);
        }
        ClassHistogramStatsEvent statsEvent = new ClassHistogramStatsEvent(appName, totalObjects, totalSize);
        ServiceFactory.getServiceManager().getInternalCustomEventService().addInternalCustomEvent(statsEvent);
    }
}

