/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.graph;

import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.graph.ClassMethodSig;
import com.newrelic.agent.graph.ClassNode;
import com.newrelic.agent.graph.DiscoveryEngine;
import com.newrelic.agent.graph.Graph;
import com.newrelic.agent.instrumentation.context.GeneratedClassDetector;
import com.newrelic.weave.utils.WeaveUtils;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;

public class DiscoveryVisitor
extends ClassVisitor {
    private final String className;
    private final ClassLoader classLoader;
    private final DiscoveryEngine discoveryEngine;

    public DiscoveryVisitor(String className, ClassLoader classLoader, DiscoveryEngine discoveryEngine) {
        super(393216);
        this.className = className;
        this.classLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        this.discoveryEngine = discoveryEngine;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null && this.discoveryEngine.inPackages(superName)) {
            this.checkAndAdd(superName, false, name);
        }
        for (String interfaceName : interfaces) {
            if (interfaceName.isEmpty() || !this.discoveryEngine.inPackages(interfaceName)) continue;
            this.checkAndAdd(interfaceName, true, name);
        }
        if (this.discoveryEngine.inPackages(name)) {
            this.checkAndAdd(name, (access & 0x200) == 512, null);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (WeaveUtils.isConstructor(name) || WeaveUtils.isStaticInitializer(name) || WeaveUtils.isMain(access, name, desc)) {
            return mv;
        }
        final Graph callGraph = this.discoveryEngine.getCallGraph();
        final ClassMethodSig source = new ClassMethodSig(this.className, name, desc);
        callGraph.addSource(source);
        callGraph.addClassLoaderEntry(source.getClassName(), this.classLoader);
        return new MethodVisitor(393216, mv){

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (!(WeaveUtils.isConstructor(name) || WeaveUtils.isStaticInitializer(name) || WeaveUtils.isMain(9, name, desc) || !DiscoveryVisitor.this.discoveryEngine.inPackages(owner) || GeneratedClassDetector.isGenerated(owner))) {
                    ClassMethodSig destination = new ClassMethodSig(owner, name, desc);
                    callGraph.addSourceAndDestination(source, destination);
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        };
    }

    private void checkAndAdd(String source, boolean sourceInterface, String destination) {
        if (GeneratedClassDetector.isGenerated(source)) {
            return;
        }
        ConcurrentMap<String, ClassNode> classHierarchyGraph = this.discoveryEngine.getClassHierarchyGraph();
        ClassNode added = (ClassNode)classHierarchyGraph.get(source);
        if (added == null) {
            HashSet<String> subClasses = Sets.newHashSet();
            if (destination != null) {
                subClasses.add(destination);
            }
            ClassNode classNodeToAdd = new ClassNode(source, sourceInterface, subClasses);
            classHierarchyGraph.put(source, classNodeToAdd);
        } else {
            if (destination != null) {
                added.addSubClass(destination);
            }
            if (sourceInterface) {
                added.setInterface(sourceInterface);
            }
        }
    }
}

