/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.graph;

import com.newrelic.agent.tracers.ClassMethodSignature;
import java.text.MessageFormat;

public class ClassMethodSig {
    private final String className;
    private final String methodName;
    private final String methodDesc;
    private boolean transactionStartPoint;

    public ClassMethodSig(String className, String methodName, String methodDesc) {
        this(className, methodName, methodDesc, false);
    }

    public ClassMethodSig(ClassMethodSignature cms) {
        this(cms.getClassName().replace('.', '/'), cms.getMethodName(), cms.getMethodDesc(), false);
    }

    public ClassMethodSig(String className, String methodName, String methodDesc, boolean transactionStartPoint) {
        if (className == null || methodName == null || methodDesc == null) {
            throw new IllegalArgumentException(MessageFormat.format("className {0}, methodName {1} and methodDesc {2} must not be null", className, methodName, methodDesc));
        }
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.transactionStartPoint = transactionStartPoint;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public boolean isTransactionStartPoint() {
        return this.transactionStartPoint;
    }

    public void setTransactionStartPoint(boolean transactionStartPoint) {
        this.transactionStartPoint = transactionStartPoint;
    }

    public String getClassNameWithDots() {
        return this.className.replace('/', '.');
    }

    public String toString() {
        return this.className + ":" + this.methodName + ":" + this.methodDesc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassMethodSig)) {
            return false;
        }
        ClassMethodSig that = (ClassMethodSig)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        return this.methodDesc.equals(that.methodDesc);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.methodDesc.hashCode();
        return result;
    }
}

