/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.dispatchers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.attributes.AttributesService;
import com.newrelic.agent.bridge.StatusCodePolicy;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.WebResponse;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.dispatchers.DefaultDispatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletUtils;
import com.newrelic.agent.stats.ApdexStats;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.servlet.ExternalTimeTracker;
import com.newrelic.agent.transaction.TransactionNamer;
import com.newrelic.agent.transaction.WebTransactionNamer;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.ExtendedRequest;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

public class WebRequestDispatcher
extends DefaultDispatcher
implements WebResponse {
    private static final Cache<String, String> totalTimeNameCache = CacheBuilder.newBuilder().concurrencyLevel(32).build();
    private static final Cache<String, String> firstByteNameCache = CacheBuilder.newBuilder().concurrencyLevel(32).build();
    private static final Cache<String, String> lastByteNameCache = CacheBuilder.newBuilder().concurrencyLevel(32).build();
    private static final Cache<String, String> apdexNameCache = CacheBuilder.newBuilder().concurrencyLevel(32).build();
    private static final String UNKNOWN_URI = "/Unknown";
    private static final StatusCodePolicy LAST_STATUS_CODE_POLICY = new StatusCodePolicy(){

        public int nextStatus(int currentStatus, int lastStatus) {
            return lastStatus;
        }
    };
    private static final StatusCodePolicy ERROR_STATUS_CODE_POLICY = new StatusCodePolicy(){

        public int nextStatus(int currentStatus, int lastStatus) {
            return currentStatus < 400 ? lastStatus : currentStatus;
        }
    };
    private static final StatusCodePolicy FREEZE_STATUS_CODE_POLICY = new StatusCodePolicy(){

        public int nextStatus(int currentStatus, int lastStatus) {
            return currentStatus;
        }
    };
    private volatile boolean responseRecorded;
    private volatile Request request;
    private volatile Response response;
    private volatile String requestURI;
    private volatile ExternalTimeTracker externalTimeTracker;
    private volatile int statusCode;
    private volatile String statusMessage;
    private volatile StatusCodePolicy statusCodePolicy;

    public WebRequestDispatcher(Request request, Response response, Transaction transaction) {
        super(transaction);
        boolean isLastStatusCodePolicy = (Boolean)transaction.getAgentConfig().getValue("last_status_code_policy", Boolean.TRUE);
        this.statusCodePolicy = isLastStatusCodePolicy ? LAST_STATUS_CODE_POLICY : ERROR_STATUS_CODE_POLICY;
        this.request = request;
        this.response = response;
        this.externalTimeTracker = ExternalTimeTracker.create(request, transaction.getWallClockStartTimeMs());
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(Request request) {
        this.externalTimeTracker = ExternalTimeTracker.create(request, this.getTransaction().getWallClockStartTimeMs());
        this.request = request;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(Response response) {
        this.response = response;
    }

    @Override
    public void transactionActivityWithResponseFinished() {
        if (!this.responseRecorded && this.request != null) {
            try {
                this.getUri();
                this.setStatus();
                this.freezeStatus();
                this.setStatusMessage();
                this.recordParameters();
                this.storeReferrer();
                this.storeHeader("Accept", "request.headers.accept");
                this.storeHeader("Host", "request.headers.host");
                this.storeHeader("User-Agent", "request.headers.userAgent");
                this.storeHeader("Content-Length", "request.headers.contentLength");
                this.storeMethod();
                this.storeResponseContentType();
                if (this.getStatus() > 0) {
                    this.getTransaction().getAgentAttributes().put("httpResponseCode", String.valueOf(this.getStatus()));
                }
                if (this.getStatusMessage() != null) {
                    this.getTransaction().getAgentAttributes().put("httpResponseMessage", this.getStatusMessage());
                }
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINER, e, "Exception when reporting request/response information.");
            }
            finally {
                this.responseRecorded = true;
                this.request = null;
                this.response = null;
            }
        }
    }

    @Override
    public void transactionFinished(String transactionName, TransactionStats stats) {
        this.transactionActivityWithResponseFinished();
        this.doRecordMetrics(transactionName, stats);
    }

    private void recordParameters() {
        try {
            ServletUtils.recordParameters(this.getTransaction(), this.request);
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINEST, e, "Error recording parameters for transaction");
        }
    }

    @Override
    public final String getUri() {
        if (this.requestURI == null) {
            this.requestURI = this.initializeRequestURI();
        }
        return this.requestURI;
    }

    @Override
    public void setTransactionName() {
        Tracer rootTracer;
        if (Transaction.isDummyRequest(this.request) && (rootTracer = this.getTransaction().getRootTracer()) != null) {
            rootTracer.nameTransaction(TransactionNamePriority.REQUEST_URI);
        }
        AttributesService attributesService = ServiceFactory.getAttributesService();
        String filterRequestUri = attributesService.filterRequestUri(this.getTransaction().getApplicationName(), "attributes", this.getUri());
        TransactionNamer tn = WebTransactionNamer.create(this.getTransaction(), filterRequestUri);
        tn.setTransactionName();
    }

    private String initializeRequestURI() {
        String result = UNKNOWN_URI;
        if (this.request == null) {
            return result;
        }
        try {
            String uri = this.request.getRequestURI();
            if (uri == null || uri.length() == 0) {
                Agent.LOG.log(Level.FINER, "requestURI is null: setting requestURI to {0}", result);
            } else {
                result = ServiceFactory.getNormalizationService().getUrlBeforeParameters(uri);
            }
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINER, "Error calling requestURI: " + e.toString());
            Agent.LOG.log(Level.FINEST, e.toString(), e);
            result = UNKNOWN_URI;
        }
        return result;
    }

    private void storeReferrer() {
        try {
            String referer = this.request.getHeader("Referer");
            if (referer != null) {
                referer = referer.split("\\;")[0];
                referer = referer.split("\\?")[0];
                this.getTransaction().getAgentAttributes().put("request.headers.referer", referer);
            }
        }
        catch (Throwable e) {
            Agent.LOG.finer("Error getting referer: " + e.toString());
            Agent.LOG.log(Level.FINEST, e.toString(), e);
        }
    }

    private void storeHeader(String headerName, String attributeName) {
        try {
            String headerVal = this.request.getHeader(headerName);
            if (headerVal != null) {
                this.getTransaction().getAgentAttributes().put(attributeName, headerVal);
            }
        }
        catch (Throwable e) {
            Agent.LOG.finer("Error getting HTTP " + headerName + " header: " + e.toString());
            Agent.LOG.log(Level.FINEST, e.toString(), e);
        }
    }

    private void storeMethod() {
        if (this.request instanceof ExtendedRequest) {
            try {
                String method = ((ExtendedRequest)this.request).getMethod();
                if (method != null) {
                    this.getTransaction().getAgentAttributes().put("request.method", method);
                }
            }
            catch (Throwable e) {
                Agent.LOG.finer("Error getting HTTP method: " + e.toString());
                Agent.LOG.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    private void storeResponseContentType() {
        if (this.response != null) {
            try {
                String contentType = this.response.getContentType();
                if (contentType != null) {
                    this.getTransaction().getAgentAttributes().put("response.headers.contentType", contentType);
                }
            }
            catch (Throwable e) {
                Agent.LOG.finer("Error getting HTTP response ContentType: " + e.toString());
                Agent.LOG.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    public void freezeStatus() {
        this.statusCodePolicy = FREEZE_STATUS_CODE_POLICY;
        Agent.LOG.log(Level.FINER, "Freezing status code to {0}", this.getStatus());
    }

    private void setStatus() {
        if (this.response != null) {
            try {
                this.setStatus(this.response.getStatus());
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINER, "Failed to get response status code {0}", e.toString());
            }
        }
    }

    private void setStatusMessage() {
        if (this.response != null && this.getStatusMessage() == null && this.getStatus() >= 400) {
            try {
                this.setStatusMessage(this.response.getStatusMessage());
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINER, "Failed to get response status message {0}", e.toString());
            }
        }
    }

    private void doRecordMetrics(String transactionName, TransactionStats stats) {
        this.recordHeaderMetrics(stats);
        this.recordApdexMetrics(transactionName, stats);
        this.recordDispatcherMetrics(transactionName, stats);
    }

    public void recordHeaderMetrics(TransactionStats statsEngine) {
        this.externalTimeTracker.recordMetrics(statsEngine);
    }

    public long getQueueTime() {
        return this.externalTimeTracker.getExternalTime();
    }

    private void recordDispatcherMetrics(final String frontendMetricName, TransactionStats stats) {
        if (frontendMetricName == null || frontendMetricName.length() == 0) {
            return;
        }
        long frontendTimeInNanos = this.getTransaction().getTransactionTimer().getResponseTimeInNanos();
        stats.getUnscopedStats().getResponseTimeStats(frontendMetricName).recordResponseTimeInNanos(frontendTimeInNanos);
        stats.getUnscopedStats().getResponseTimeStats("WebTransaction").recordResponseTimeInNanos(frontendTimeInNanos);
        stats.getUnscopedStats().getResponseTimeStats("HttpDispatcher").recordResponseTimeInNanos(frontendTimeInNanos);
        if (this.getStatus() > 0) {
            String metricName = Strings.join("Network/Inbound/StatusCode/", String.valueOf(this.getStatus()));
            stats.getUnscopedStats().getResponseTimeStats(metricName).recordResponseTimeInNanos(frontendTimeInNanos);
        }
        if (this.hasTransactionName(frontendMetricName, "WebTransaction")) {
            Object cpuTime;
            long lastByteDurNs;
            String totalTimeMetric;
            try {
                totalTimeMetric = totalTimeNameCache.get(frontendMetricName, new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return WebRequestDispatcher.this.getTransName(frontendMetricName, "WebTransaction", "TotalTime");
                    }
                });
            }
            catch (ExecutionException e) {
                totalTimeMetric = this.getTransName(frontendMetricName, "WebTransaction", "TotalTime");
            }
            stats.getUnscopedStats().getResponseTimeStats(totalTimeMetric).recordResponseTimeInNanos(this.getTransaction().getTransactionTimer().getTotalSumTimeInNanos());
            long firstByteDurNs = this.getTransaction().getTransactionTimer().getTimeToFirstByteInNanos();
            if (firstByteDurNs > 0L) {
                String firstByteMetricName;
                try {
                    firstByteMetricName = firstByteNameCache.get(frontendMetricName, new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return WebRequestDispatcher.this.getTransName(frontendMetricName, "WebTransaction", "TimeToFirstByte");
                        }
                    });
                }
                catch (ExecutionException e) {
                    firstByteMetricName = this.getTransName(frontendMetricName, "WebTransaction", "TimeToFirstByte");
                }
                stats.getUnscopedStats().getResponseTimeStats(firstByteMetricName).recordResponseTimeInNanos(firstByteDurNs);
                stats.getUnscopedStats().getResponseTimeStats("WebTransactionTimeToFirstByte").recordResponseTimeInNanos(firstByteDurNs);
            }
            if ((lastByteDurNs = this.getTransaction().getTransactionTimer().getTimetoLastByteInNanos()) > 0L) {
                String lastByteMetricName;
                try {
                    lastByteMetricName = lastByteNameCache.get(frontendMetricName, new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return WebRequestDispatcher.this.getTransName(frontendMetricName, "WebTransaction", "TimeToLastByte");
                        }
                    });
                }
                catch (ExecutionException e) {
                    lastByteMetricName = this.getTransName(frontendMetricName, "WebTransaction", "TimeToLastByte");
                }
                stats.getUnscopedStats().getResponseTimeStats(lastByteMetricName).recordResponseTimeInNanos(lastByteDurNs);
                stats.getUnscopedStats().getResponseTimeStats("WebTransactionTimeToLastByte").recordResponseTimeInNanos(lastByteDurNs);
            }
            if ((cpuTime = this.getTransaction().getIntrinsicAttributes().get("cpuTime")) != null && cpuTime instanceof Long) {
                long val = (Long)cpuTime;
                String cpuMetricName = "CPU/" + frontendMetricName;
                stats.getUnscopedStats().getResponseTimeStats(cpuMetricName).recordResponseTimeInNanos(val);
                stats.getUnscopedStats().getResponseTimeStats("CPU/WebTransaction").recordResponseTimeInNanos(val);
            }
        }
        stats.getUnscopedStats().getResponseTimeStats("WebTransactionTotalTime").recordResponseTimeInNanos(this.getTransaction().getTransactionTimer().getTotalSumTimeInNanos());
    }

    private void recordApdexMetrics(final String frontendMetricName, TransactionStats stats) {
        String frontendApdexMetricName;
        if (frontendMetricName == null || frontendMetricName.length() == 0) {
            return;
        }
        if (!this.getTransaction().getAgentConfig().isApdexTSet()) {
            return;
        }
        if (this.isIgnoreApdex()) {
            Agent.LOG.log(Level.FINE, "Ignoring transaction for apdex {0}", frontendMetricName);
            return;
        }
        try {
            frontendApdexMetricName = apdexNameCache.get(frontendMetricName, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return WebRequestDispatcher.this.getApdexMetricName(frontendMetricName, "WebTransaction", "Apdex");
                }
            });
        }
        catch (ExecutionException e) {
            frontendApdexMetricName = this.getApdexMetricName(frontendMetricName, "WebTransaction", "Apdex");
        }
        if (frontendApdexMetricName == null || frontendApdexMetricName.length() == 0) {
            return;
        }
        long apdexT = this.getTransaction().getAgentConfig().getApdexTInMillis(frontendMetricName);
        ApdexStats apdexStats = stats.getUnscopedStats().getApdexStats(frontendApdexMetricName);
        ApdexStats overallApdexStats = stats.getUnscopedStats().getApdexStats("Apdex");
        if (this.isApdexFrustrating()) {
            apdexStats.recordApdexFrustrated();
            overallApdexStats.recordApdexFrustrated();
        } else {
            long responseTimeInMillis = this.getTransaction().getTransactionTimer().getResponseTimeInMilliseconds() + this.externalTimeTracker.getExternalTime();
            apdexStats.recordApdexResponseTime(responseTimeInMillis, apdexT);
            overallApdexStats.recordApdexResponseTime(responseTimeInMillis, apdexT);
        }
    }

    public boolean isApdexFrustrating() {
        return this.getTransaction().isErrorReportableAndNotIgnored() && this.getTransaction().isErrorNotExpected();
    }

    @Override
    public TransactionTracerConfig getTransactionTracerConfig() {
        return this.getTransaction().getAgentConfig().getRequestTransactionTracerConfig();
    }

    @Override
    public boolean isWebTransaction() {
        return true;
    }

    @Override
    public String getCookieValue(String name) {
        if (this.request == null) {
            return null;
        }
        return this.request.getCookieValue(name);
    }

    @Override
    public String getHeader(String name) {
        if (this.request == null) {
            return null;
        }
        return this.request.getHeader(name);
    }

    public void setStatus(int statusCode) {
        Agent.LOG.log(Level.FINEST, "Called setStatus: {0}", statusCode);
        if (statusCode <= 0 || statusCode == this.statusCode) {
            return;
        }
        int nextStatusCode = this.statusCodePolicy.nextStatus(this.statusCode, statusCode);
        if (nextStatusCode != this.statusCode) {
            Agent.LOG.log(Level.FINER, "Setting status to {0}", nextStatusCode);
        }
        this.statusCode = nextStatusCode;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }
}

