/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.reflections.scanners;

import com.newrelic.agent.deps.com.google.common.base.Joiner;
import com.newrelic.agent.deps.javassist.bytecode.LocalVariableAttribute;
import com.newrelic.agent.deps.javassist.bytecode.MethodInfo;
import com.newrelic.agent.deps.org.reflections.adapters.MetadataAdapter;
import com.newrelic.agent.deps.org.reflections.scanners.AbstractScanner;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class MethodParameterNamesScanner
extends AbstractScanner {
    public void scan(Object cls) {
        MetadataAdapter md = this.getMetadataAdapter();
        for (Object method : md.getMethods(cls)) {
            String key = md.getMethodFullKey(cls, method);
            if (!this.acceptResult(key)) continue;
            LocalVariableAttribute table = (LocalVariableAttribute)((MethodInfo)method).getCodeAttribute().getAttribute("LocalVariableTable");
            int length = table.tableLength();
            int i = Modifier.isStatic(((MethodInfo)method).getAccessFlags()) ? 0 : 1;
            if (i >= length) continue;
            ArrayList<String> names = new ArrayList<String>(length - i);
            while (i < length) {
                names.add(((MethodInfo)method).getConstPool().getUtf8Info(table.nameIndex(i++)));
            }
            this.getStore().put(key, Joiner.on(", ").join(names));
        }
    }
}

