/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.datastore.DatabaseVendor;
import com.newrelic.agent.bridge.datastore.RecordSql;
import com.newrelic.agent.database.DatabaseService;
import com.newrelic.agent.database.ExplainPlanExecutor;
import com.newrelic.agent.tracers.SqlTracerExplainInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.logging.Level;

public class DefaultExplainPlanExecutor
implements ExplainPlanExecutor {
    private SqlTracerExplainInfo tracer;
    private final String originalSqlStatement;
    private final RecordSql recordSql;

    public DefaultExplainPlanExecutor(SqlTracerExplainInfo tracer, String originalSqlStatement, RecordSql recordSql) {
        this.originalSqlStatement = originalSqlStatement;
        this.tracer = tracer;
        this.recordSql = recordSql;
    }

    private Object[] getExplainPlanFromResultSet(DatabaseVendor vendor, ResultSet rs, RecordSql recordSql) throws SQLException {
        int columnCount = rs.getMetaData().getColumnCount();
        if (columnCount > 0) {
            Collection explains = vendor.parseExplainPlanResultSet(columnCount, rs, recordSql);
            return new Object[]{explains};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runExplainPlan(DatabaseService databaseService, Connection connection, DatabaseVendor vendor) throws SQLException {
        String sql = this.originalSqlStatement;
        try {
            sql = vendor.getExplainPlanSql(sql);
        }
        catch (SQLException e) {
            this.tracer.setExplainPlan(e.getMessage());
            return;
        }
        Agent.LOG.finer("Running explain: " + sql);
        ResultSet resultSet = null;
        Statement statement = null;
        Object[] explainPlan = null;
        try {
            statement = this.createStatement(connection, sql);
            resultSet = this.executeStatement(statement, sql);
            explainPlan = this.getExplainPlanFromResultSet(vendor, resultSet, this.recordSql);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINER, "explain plan error", e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINER, "Unable to close result set", e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINER, "Unable to close statement", e);
                }
            }
        }
        if (explainPlan != null) {
            this.tracer.setExplainPlan(explainPlan);
        }
    }

    protected ResultSet executeStatement(Statement statement, String sql) throws SQLException {
        return statement.executeQuery(sql);
    }

    protected Statement createStatement(Connection connection, String sql) throws SQLException {
        return connection.createStatement();
    }
}

