/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.SegmentDiscoveryConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SegmentDiscoveryConfigImpl
extends BaseConfig
implements SegmentDiscoveryConfig {
    public static final String ENABLED = "enabled";
    public static final boolean DEFAULT_ENABLED = false;
    public static final String PROPERTY_NAME = "segment_discovery";
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.segment_discovery.";
    public static final String DISCOVERY_PACKAGES = "packages";
    public static final String SEGMENT_DISCOVERY_THRESHOLD = "threshold";
    public static final int DEFAULT_SEGMENT_DISCOVERY_THRESHOLD = 40;
    public static final int DEFAULT_SEGMENT_DISCOVERY_THRESHOLD_LIMIT = 10;
    public static final String TRANSACTION_DISCOVERY = "transaction_discovery";
    public static final boolean DEFAULT_TRANSACTION_DISCOVERY = false;
    public static final String IGNORE_TRANSACTION_DISCOVERY_CLASS_CONTAINS = "ignore_transaction_start_point_class_contains";
    public static final Set<String> DEFAULT_IGNORE_TRANSACTION_DISCOVERY_CLASS_CONTAINS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Log", "Config")));
    public static final String IGNORE_TRANSACTION_DISCOVERY_METHOD_STARTS_WITH = "ignore_transaction_start_point_method_starts_with";
    public static final Set<String> DEFAULT_IGNORE_TRANSACTION_DISCOVERY_METHOD_STARTS_WITH = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("log", "is", "config", "get", "contains", "has")));
    private final boolean enabled = this.initEnabled();
    private final int segmentDiscoveryThreshold;
    private final Set<String> discoveryPackages;
    private final Set<String> ignoreTransactionDiscoveryClassContains;
    private final Set<String> ignoreTransactionDiscoveryMethodStartsWith;
    private final boolean transactionDiscovery;

    public SegmentDiscoveryConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        int configThreshold = this.getProperty(SEGMENT_DISCOVERY_THRESHOLD, 40);
        this.segmentDiscoveryThreshold = configThreshold < 10 ? 10 : (configThreshold > 100 ? 40 : configThreshold);
        this.transactionDiscovery = this.getProperty(TRANSACTION_DISCOVERY, false);
        this.discoveryPackages = this.initDiscoveryPackages(DISCOVERY_PACKAGES);
        this.ignoreTransactionDiscoveryClassContains = this.initIgnoreClassContainsSet(IGNORE_TRANSACTION_DISCOVERY_CLASS_CONTAINS, DEFAULT_IGNORE_TRANSACTION_DISCOVERY_CLASS_CONTAINS);
        this.ignoreTransactionDiscoveryMethodStartsWith = this.initIgnoreMethodStartsWithSet(IGNORE_TRANSACTION_DISCOVERY_METHOD_STARTS_WITH, DEFAULT_IGNORE_TRANSACTION_DISCOVERY_METHOD_STARTS_WITH);
    }

    private boolean initEnabled() {
        return this.getProperty(ENABLED, false);
    }

    private Set<String> initDiscoveryPackages(String configurationKey) {
        Collection<String> uniquePackages = this.getUniqueStrings(configurationKey);
        HashSet<String> result = new HashSet<String>(uniquePackages.size());
        for (String uniquePackage : uniquePackages) {
            result.add(uniquePackage.replace('.', '/'));
        }
        return Collections.unmodifiableSet(result);
    }

    private Set<String> initIgnoreClassContainsSet(String configurationKey, Set<String> defaultValues) {
        Collection<String> uniqueIgnoreClassContainsList = this.getUniqueStrings(configurationKey);
        if (uniqueIgnoreClassContainsList.isEmpty()) {
            return defaultValues;
        }
        HashSet<String> result = new HashSet<String>(uniqueIgnoreClassContainsList.size() + defaultValues.size());
        result.addAll(defaultValues);
        result.addAll(uniqueIgnoreClassContainsList);
        return Collections.unmodifiableSet(result);
    }

    private Set<String> initIgnoreMethodStartsWithSet(String configurationKey, Set<String> defaultValues) {
        Collection<String> uniqueIgnoreMethodStartsWithList = this.getUniqueStrings(configurationKey);
        if (uniqueIgnoreMethodStartsWithList.isEmpty()) {
            return defaultValues;
        }
        HashSet<String> result = new HashSet<String>(uniqueIgnoreMethodStartsWithList.size() + defaultValues.size());
        result.addAll(defaultValues);
        result.addAll(uniqueIgnoreMethodStartsWithList);
        return Collections.unmodifiableSet(result);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public int getSegmentDiscoveryThreshold() {
        return this.segmentDiscoveryThreshold;
    }

    @Override
    public Set<String> getDiscoveryPackages() {
        return this.discoveryPackages;
    }

    @Override
    public Set<String> getIgnoredTransactionDiscoveryClassContains() {
        return this.ignoreTransactionDiscoveryClassContains;
    }

    @Override
    public Set<String> getIgnoredTransactionDiscoveryMethodStartsWith() {
        return this.ignoreTransactionDiscoveryMethodStartsWith;
    }

    @Override
    public boolean transactionDiscoveryEnabled() {
        return this.transactionDiscovery;
    }
}

