/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.CrossProcessConfig;
import com.newrelic.agent.util.Obfuscator;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class CrossProcessConfigImpl
extends BaseConfig
implements CrossProcessConfig {
    public static final String CROSS_APPLICATION_TRACING = "cross_application_tracing";
    public static final String CROSS_PROCESS_ID = "cross_process_id";
    public static final String ENABLED = "enabled";
    public static final String ENCODING_KEY = "encoding_key";
    public static final String TRUSTED_ACCOUNT_IDS = "trusted_account_ids";
    public static final String APPLICATION_ID = "application_id";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.cross_application_tracer.";
    private final boolean isCrossApplicationTracing;
    private final String crossProcessId;
    private final String encodingKey;
    private final String encodedCrossProcessId;
    private final Set<String> trustedIds = Collections.unmodifiableSet(new HashSet<String>(this.getUniqueStrings("trusted_account_ids")));

    private CrossProcessConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.isCrossApplicationTracing = this.initEnabled();
        this.crossProcessId = (String)this.getProperty(CROSS_PROCESS_ID);
        this.encodingKey = (String)this.getProperty(ENCODING_KEY);
        this.encodedCrossProcessId = this.initEncodedCrossProcessId(this.crossProcessId, this.encodingKey);
    }

    private boolean initEnabled() {
        Boolean enabled = (Boolean)this.getProperty(ENABLED);
        if (enabled != null) {
            return enabled;
        }
        return this.getProperty(CROSS_APPLICATION_TRACING, true);
    }

    private String initEncodedCrossProcessId(String crossProcessId, String encodingKey) {
        if (crossProcessId == null || encodingKey == null) {
            return null;
        }
        try {
            return Obfuscator.obfuscateNameUsingKey(crossProcessId, encodingKey);
        }
        catch (UnsupportedEncodingException e) {
            String msg = MessageFormat.format("Error encoding cross process id {0}: {1}", crossProcessId, e);
            Agent.LOG.error(msg);
            return null;
        }
    }

    @Override
    public boolean isCrossApplicationTracing() {
        return this.isCrossApplicationTracing;
    }

    @Override
    public String getCrossProcessId() {
        return this.isCrossApplicationTracing ? this.crossProcessId : null;
    }

    @Override
    public String getEncodedCrossProcessId() {
        return this.isCrossApplicationTracing ? this.encodedCrossProcessId : null;
    }

    @Override
    public String getEncodingKey() {
        return this.isCrossApplicationTracing ? this.encodingKey : null;
    }

    @Override
    public boolean isTrustedAccountId(String accountId) {
        return this.trustedIds.contains(accountId);
    }

    public static CrossProcessConfig createCrossProcessConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new CrossProcessConfigImpl(settings);
    }
}

