/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.service.ServiceFactory;
import java.util.Map;
import java.util.logging.Level;

public abstract class AttributeSender {
    protected static String ATTRIBUTE_TYPE;
    private boolean transactional = true;

    protected abstract String getAttributeType();

    protected abstract Map<String, Object> getAttributeMap() throws Throwable;

    protected void setTransactional(boolean newSetting) {
        this.transactional = newSetting;
    }

    protected void addCustomAttributeImpl(String key, Object value, String methodName) {
        block5: {
            Object filteredValue = this.verifyParameterAndReturnValue(key, value, methodName);
            if (null == filteredValue) {
                return;
            }
            try {
                Map<String, Object> attributeMap = this.getAttributeMap();
                if (attributeMap != null) {
                    attributeMap.put(key, filteredValue);
                    Agent.LOG.log(Level.FINER, "Added {0} attribute \"{1}\": {2}", this.getAttributeType(), key, filteredValue);
                    MetricNames.recordApiSupportabilityMetric("AddCustomParameter");
                }
            }
            catch (Throwable t) {
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, "Exception adding attribute for key: \"{0}\": {1}", key, t);
                }
                if (!Agent.LOG.isLoggable(Level.FINER)) break block5;
                Agent.LOG.log(Level.FINER, "Exception adding attribute for key: \"{0}\": {1}", key);
            }
        }
    }

    public Object verifyParameterAndReturnValue(String key, Object value, String methodCalled) {
        int maxUserParameterSize;
        if (key == null) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a null key", this.getAttributeType(), methodCalled);
            return null;
        }
        if (value == null) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a null value for key \"{2}\"", this.getAttributeType(), methodCalled, key);
            return null;
        }
        Transaction tx = Transaction.getTransaction(false);
        int n = maxUserParameterSize = tx == null ? ServiceFactory.getConfigService().getDefaultAgentConfig().getMaxUserParameterSize() : tx.getAgentConfig().getMaxUserParameterSize();
        if (!this.validateAndLogKeyLength(key, maxUserParameterSize, methodCalled)) {
            return null;
        }
        if (value instanceof String) {
            value = this.truncateValue(key, (String)value, maxUserParameterSize, methodCalled);
        }
        if (methodCalled.equals("noticeError")) {
            return value;
        }
        if (this.transactional && (tx == null || !tx.isInProgress())) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute with key \"{1}\" because {2} was invoked outside a New Relic transaction.", this.getAttributeType(), key, methodCalled);
            return null;
        }
        return value;
    }

    private String truncateValue(String key, String value, int maxUserParameterSize, String methodCalled) {
        String truncatedVal = this.truncateString(value, maxUserParameterSize);
        if (truncatedVal != value) {
            Agent.LOG.log(Level.FINER, "{0} was invoked with a value longer than {2} bytes for key \"{3}\". The value will be shortened to the first {4} characters.", methodCalled, value, maxUserParameterSize, key, truncatedVal.length());
        }
        return truncatedVal;
    }

    private boolean validateAndLogKeyLength(String key, int maxUserParameterSize, String methodCalled) {
        try {
            if (key.getBytes("UTF-8").length > maxUserParameterSize) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a key longer than {2} bytes. Key is \"{3}\".", this.getAttributeType(), methodCalled, maxUserParameterSize, key);
                return false;
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, "Exception while verifying attribute", t);
            return false;
        }
        return true;
    }

    private String truncateString(String s, int maxBytes) {
        int truncatedSize = 0;
        for (int i = 0; i < s.length(); ++i) {
            int characterSize;
            char c = s.charAt(i);
            if (c <= '\u007f') {
                characterSize = 1;
            } else if (c <= '\u07ff') {
                characterSize = 2;
            } else if (c <= '\ud7ff') {
                characterSize = 3;
            } else if (c <= '\udfff') {
                characterSize = 4;
                ++i;
            } else {
                characterSize = 3;
            }
            if (truncatedSize + characterSize > maxBytes) {
                return s.substring(0, i);
            }
            truncatedSize += characterSize;
        }
        return s;
    }

    public void addAttribute(String key, String value, String methodName) {
        this.addCustomAttributeImpl(key, value, methodName);
    }

    public void addAttribute(String key, Number value, String methodName) {
        this.addCustomAttributeImpl(key, value, methodName);
    }

    public void addAttribute(String key, Boolean value, String methodName) {
        this.addCustomAttributeImpl(key, value, methodName);
    }

    public void addAttribute(String key, Map<String, String> values, String methodName) {
        this.addCustomAttributeImpl(key, values, methodName);
    }
}

