/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.DistributedTracePayload;
import com.newrelic.agent.deps.com.google.common.base.Charsets;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.org.apache.axis.encoding.Base64;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class DistributedTracePayloadImpl
implements DistributedTracePayload {
    public final long timestamp;
    public final String host;
    public final String callerType;
    public final String callerAccountId;
    public final String callerApplicationId;
    public final String id;
    public final String tripId;
    public final Boolean sampled;
    public final List<String> parentIds;
    public final int depth;
    public final int order;
    public final String syntheticsResource;
    public final String syntheticsJob;
    public final String syntheticsMonitor;

    public static DistributedTracePayloadImpl createDistributedTracePayload(URL url, Transaction transaction) {
        boolean hasInboundPayload;
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        String accountId = distributedTraceService.getAccountId();
        if (accountId == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINER, "Not creating distributed trace payload due to null accountId.");
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/PayloadCreateIgnored/AccountId");
            return null;
        }
        if (transaction == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINER, "Not creating distributed trace payload due to null transaction.");
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/PayloadCreateIgnored/Transaction");
            return null;
        }
        String applicationId = distributedTraceService.getApplicationId();
        long timestamp = System.currentTimeMillis();
        String host = url != null ? url.getHost() : null;
        String callerType = "App";
        DistributedTracePayloadImpl inboundPayload = transaction.getInboundDistributedTracePayload();
        boolean bl = hasInboundPayload = inboundPayload != null;
        if (hasInboundPayload) {
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/CreatePayload/Inbound");
        }
        String id = transaction.getGuid();
        String tripId = hasInboundPayload ? inboundPayload.tripId : id;
        List<String> parentIds = DistributedTracePayloadImpl.calculateParentIds(inboundPayload, id);
        int depth = hasInboundPayload ? inboundPayload.depth + 1 : 2;
        int order = transaction.incrementAndGet();
        boolean sampled = transaction.sampled();
        String syntheticsResource = hasInboundPayload ? inboundPayload.syntheticsResource : null;
        String syntheticsJob = hasInboundPayload ? inboundPayload.syntheticsJob : null;
        String syntheticsMonitor = hasInboundPayload ? inboundPayload.syntheticsMonitor : null;
        return new DistributedTracePayloadImpl(timestamp, host, callerType, accountId, applicationId, id, tripId, sampled, parentIds, depth, order, syntheticsResource, syntheticsJob, syntheticsMonitor);
    }

    private DistributedTracePayloadImpl(long timestamp, String host, String callerType, String callerAccountId, String callerApplicationId, String id, String tripId, Boolean sampled, List<String> parentIds, int depth, int order, String syntheticsResource, String syntheticsJob, String syntheticsMonitor) {
        this.timestamp = timestamp;
        this.host = host;
        this.callerType = callerType;
        this.callerAccountId = callerAccountId;
        this.callerApplicationId = callerApplicationId;
        this.id = id;
        this.tripId = tripId;
        this.sampled = sampled;
        this.parentIds = parentIds;
        this.depth = depth;
        this.order = order;
        this.syntheticsResource = syntheticsResource;
        this.syntheticsJob = syntheticsJob;
        this.syntheticsMonitor = syntheticsMonitor;
    }

    private static List<String> calculateParentIds(DistributedTracePayloadImpl inboundPayload, String id) {
        LinkedList<Object> parentIdsList = inboundPayload == null || inboundPayload.parentIds == null ? Lists.newLinkedList() : Lists.newLinkedList(inboundPayload.parentIds);
        parentIdsList.add(id);
        return parentIdsList.size() > 3 ? parentIdsList.subList(parentIdsList.size() - 3, parentIdsList.size()) : parentIdsList;
    }

    public String text() {
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        JSONObject payload = new JSONObject();
        JSONArray catVersion = new JSONArray();
        catVersion.add(distributedTraceService.getMajorSupportedCatVersion());
        catVersion.add(distributedTraceService.getMinorSupportedCatVersion());
        payload.put("v", catVersion);
        JSONObject data = new JSONObject();
        data.put("ti", this.timestamp);
        if (this.host != null) {
            data.put("ho", this.host);
        }
        data.put("ty", this.callerType);
        data.put("ac", this.callerAccountId);
        data.put("ap", this.callerApplicationId);
        if (this.id != null) {
            data.put("id", this.id);
            data.put("tr", this.tripId);
            data.put("sa", this.sampled == null ? false : this.sampled);
            data.put("pa", this.parentIds);
            data.put("de", this.depth);
            data.put("or", this.order);
        }
        if (this.syntheticsResource != null) {
            JSONObject syntheticsData = new JSONObject();
            syntheticsData.put("r", this.syntheticsResource);
            syntheticsData.put("j", this.syntheticsJob);
            syntheticsData.put("m", this.syntheticsMonitor);
            data.put("sy", syntheticsData);
        }
        payload.put("d", data);
        return payload.toJSONString();
    }

    public String httpSafe() {
        return Base64.encode(this.text().getBytes(Charsets.UTF_8));
    }

    public static DistributedTracePayloadImpl parseDistributedTracePayload(Transaction tx, String payload) {
        if (payload == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload is null.");
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/PayloadAcceptIgnored/Null");
            return null;
        }
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        JSONParser parser = new JSONParser();
        try {
            boolean trustedAccount;
            JSONObject object = (JSONObject)parser.parse(payload);
            JSONArray version = (JSONArray)object.get("v");
            Long majorVersion = (Long)version.get(0);
            int majorSupportedVersion = distributedTraceService.getMajorSupportedCatVersion();
            if (majorVersion > (long)majorSupportedVersion) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload major version: {0} is newer than supported agent version: {1}. Ignoring payload.", (Object)majorVersion, (Object)majorSupportedVersion);
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/PayloadAcceptIgnored/MajorVersion");
                return null;
            }
            JSONObject data = (JSONObject)object.get("d");
            String accountId = distributedTraceService.getAccountId();
            String callerAccountId = (String)data.get("ac");
            boolean bl = trustedAccount = tx != null ? tx.getCrossProcessConfig().isTrustedAccountId(callerAccountId) : accountId.equals(callerAccountId);
            if (accountId == null || !trustedAccount) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload accountId: {0} does not match trusted accountIds: {1}. Ignoring payload.", (Object)callerAccountId, (Object)accountId);
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/PayloadAcceptIgnored/AccountId");
                return null;
            }
            long timestamp = (Long)data.get("ti");
            String host = (String)data.get("ho");
            String callerType = (String)data.get("ty");
            String callerApplicationId = (String)data.get("ap");
            String id = (String)data.get("id");
            String tripId = (String)data.get("tr");
            Boolean sampled = (Boolean)data.get("sa");
            List<String> parentIds = (List<String>)data.get("pa");
            if (parentIds != null && parentIds.size() > 3) {
                parentIds = parentIds.subList(parentIds.size() - 3, parentIds.size());
            }
            Number depth = (Number)data.get("de");
            Number order = (Number)data.get("or");
            JSONObject synthetics = (JSONObject)data.get("sy");
            String syntheticsResource = null;
            String syntheticsJob = null;
            String syntheticsMonitor = null;
            if (synthetics != null) {
                syntheticsResource = (String)synthetics.get("r");
                syntheticsJob = (String)synthetics.get("j");
                syntheticsMonitor = (String)synthetics.get("m");
            }
            DistributedTracePayloadImpl distributedTracePayload = new DistributedTracePayloadImpl(timestamp, host, callerType, callerAccountId, callerApplicationId, id, tripId, sampled, parentIds, depth.intValue(), order.intValue(), syntheticsResource, syntheticsJob, syntheticsMonitor);
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, "Parsed distributed trace payload: {0}", distributedTracePayload);
            }
            return distributedTracePayload;
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Failed to parse distributed trace payload");
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/PayloadAcceptIgnored/ParseException");
            return null;
        }
    }

    public String toString() {
        return "DistributedTracePayloadImpl{timestamp=" + this.timestamp + ", host='" + this.host + '\'' + ", callerType='" + this.callerType + '\'' + ", callerAccountId='" + this.callerAccountId + '\'' + ", callerApplicationId='" + this.callerApplicationId + '\'' + ", id='" + this.id + '\'' + ", tripId='" + this.tripId + '\'' + ", sampled=" + this.sampled + ", parentIds=" + this.parentIds + ", depth=" + this.depth + ", order=" + this.order + ", syntheticsResource='" + this.syntheticsResource + '\'' + ", syntheticsJob='" + this.syntheticsJob + '\'' + ", syntheticsMonitor='" + this.syntheticsMonitor + '\'' + '}';
    }
}

