/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.com.google.gson.reflect;

import com.networkbench.com.google.gson.internal.$Gson$Preconditions;
import com.networkbench.com.google.gson.internal.$Gson$Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class TypeToken<T> {
    final Class<? super T> b;
    final Type c;
    final int d;

    protected TypeToken() {
        this.c = TypeToken.a(this.getClass());
        this.b = $Gson$Types.getRawType(this.c);
        this.d = this.c.hashCode();
    }

    TypeToken(Type type) {
        this.c = $Gson$Types.canonicalize($Gson$Preconditions.checkNotNull(type));
        this.b = $Gson$Types.getRawType(this.c);
        this.d = this.c.hashCode();
    }

    static Type a(Class<?> clazz) {
        Type type = clazz.getGenericSuperclass();
        if (type instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return $Gson$Types.canonicalize(parameterizedType.getActualTypeArguments()[0]);
    }

    public final Class<? super T> getRawType() {
        return this.b;
    }

    public final Type getType() {
        return this.c;
    }

    @Deprecated
    public boolean isAssignableFrom(Class<?> cls) {
        return this.isAssignableFrom((Type)cls);
    }

    @Deprecated
    public boolean isAssignableFrom(Type from) {
        if (from == null) {
            return false;
        }
        if (this.c.equals(from)) {
            return true;
        }
        if (this.c instanceof Class) {
            return this.b.isAssignableFrom($Gson$Types.getRawType(from));
        }
        if (this.c instanceof ParameterizedType) {
            return TypeToken.isAssignableFrom(from, (ParameterizedType)this.c, new HashMap<String, Type>());
        }
        if (this.c instanceof GenericArrayType) {
            return this.b.isAssignableFrom($Gson$Types.getRawType(from)) && TypeToken.isAssignableFrom(from, (GenericArrayType)this.c);
        }
        throw TypeToken.buildUnexpectedTypeError(this.c, Class.class, ParameterizedType.class, GenericArrayType.class);
    }

    @Deprecated
    public boolean isAssignableFrom(TypeToken<?> token) {
        return this.isAssignableFrom(token.getType());
    }

    private static boolean isAssignableFrom(Type from, GenericArrayType to) {
        Type type = to.getGenericComponentType();
        if (type instanceof ParameterizedType) {
            Type type2 = from;
            if (from instanceof GenericArrayType) {
                type2 = ((GenericArrayType)from).getGenericComponentType();
            } else if (from instanceof Class) {
                Class<?> clazz = (Class<?>)from;
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                type2 = clazz;
            }
            return TypeToken.isAssignableFrom(type2, (ParameterizedType)type, new HashMap<String, Type>());
        }
        return true;
    }

    private static boolean isAssignableFrom(Type from, ParameterizedType to, Map<String, Type> typeVarMap) {
        if (from == null) {
            return false;
        }
        if (to.equals(from)) {
            return true;
        }
        Class<?> clazz = $Gson$Types.getRawType(from);
        ParameterizedType parameterizedType = null;
        if (from instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)from;
        }
        if (parameterizedType != null) {
            Type[] object = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
            for (int i2 = 0; i2 < object.length; ++i2) {
                Type type = object[i2];
                TypeVariable<Class<?>> typeVariable = typeVariableArray[i2];
                while (type instanceof TypeVariable) {
                    TypeVariable typeVariable2 = (TypeVariable)type;
                    type = typeVarMap.get(typeVariable2.getName());
                }
                typeVarMap.put(typeVariable.getName(), type);
            }
            if (TypeToken.typeEquals(parameterizedType, to, typeVarMap)) {
                return true;
            }
        }
        for (Type type : clazz.getGenericInterfaces()) {
            if (!TypeToken.isAssignableFrom(type, to, new HashMap<String, Type>(typeVarMap))) continue;
            return true;
        }
        Type type = clazz.getGenericSuperclass();
        return TypeToken.isAssignableFrom(type, to, new HashMap<String, Type>(typeVarMap));
    }

    private static boolean typeEquals(ParameterizedType from, ParameterizedType to, Map<String, Type> typeVarMap) {
        if (from.getRawType().equals(to.getRawType())) {
            Type[] typeArray = from.getActualTypeArguments();
            Type[] typeArray2 = to.getActualTypeArguments();
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                if (TypeToken.matches(typeArray[i2], typeArray2[i2], typeVarMap)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static AssertionError buildUnexpectedTypeError(Type token, Class<?> ... expected) {
        StringBuilder stringBuilder = new StringBuilder("Unexpected type. Expected one of: ");
        for (Class<?> clazz : expected) {
            stringBuilder.append(clazz.getName()).append(", ");
        }
        stringBuilder.append("but got: ").append(token.getClass().getName()).append(", for type token: ").append(token.toString()).append('.');
        return new AssertionError((Object)stringBuilder.toString());
    }

    private static boolean matches(Type from, Type to, Map<String, Type> typeMap) {
        return to.equals(from) || from instanceof TypeVariable && to.equals(typeMap.get(((TypeVariable)from).getName()));
    }

    public final int hashCode() {
        return this.d;
    }

    public final boolean equals(Object o2) {
        return o2 instanceof TypeToken && $Gson$Types.equals(this.c, ((TypeToken)o2).c);
    }

    public final String toString() {
        return $Gson$Types.typeToString(this.c);
    }

    public static TypeToken<?> get(Type type) {
        return new TypeToken(type);
    }

    public static <T> TypeToken<T> get(Class<T> type) {
        return new TypeToken<T>(type);
    }
}

