/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.tracing;

import android.text.TextUtils;
import com.networkbench.agent.impl.c.t;
import com.networkbench.agent.impl.harvest.type.HarvestableArray;
import com.networkbench.com.google.gson.JsonArray;
import com.networkbench.com.google.gson.JsonPrimitive;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SocketEvent
extends HarvestableArray {
    private int sockettype;
    private double startTime;
    private int timeElapsed;
    private int returnValue;
    private int errorNumber;
    private String host;
    private String[] addressArray;
    private String dnsaddressArray;
    private String errormsg;
    private int fd;
    private a state;
    public int port;
    private boolean ishttpData;
    private boolean isUsed;
    private String connectAddr;

    public SocketEvent() {
        this.state = a.a;
        this.ishttpData = false;
        this.isUsed = false;
        this.errormsg = "";
        this.errorNumber = 0;
    }

    public SocketEvent(int type, double startTime, int timeElapsed, int returnValue, int errorNumber, String desc, int port) {
        this.sockettype = type;
        this.timeElapsed = timeElapsed;
        this.returnValue = returnValue;
        this.errorNumber = errorNumber;
        this.startTime = startTime;
        this.port = port;
        this.state = a.a;
        this.ishttpData = false;
        this.isUsed = false;
        this.errormsg = null == desc ? "" : desc;
    }

    public void stop() {
        this.state = a.c;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String[] getAddressArray() {
        return this.addressArray;
    }

    public void setAddressArray(String[] addressArray) {
        this.addressArray = addressArray;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getSocketType() {
        return this.sockettype;
    }

    public void setSocketType(int type) {
        this.sockettype = type;
    }

    public int getTimeElapsed() {
        return this.timeElapsed;
    }

    public void setTimeElapsed(int timeElapsed) {
        this.timeElapsed = timeElapsed;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(int returnValue) {
        this.returnValue = returnValue;
    }

    public int getErrorNumber() {
        return this.errorNumber;
    }

    public void setErrorNumber(int errorNumber) {
        this.errorNumber = errorNumber;
    }

    public void setIsHttp(boolean ishttpData) {
        this.ishttpData = ishttpData;
    }

    public boolean getIsHttp() {
        return this.ishttpData;
    }

    public void setIsUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean getIsUsed() {
        return this.isUsed;
    }

    public void setConnectAddr(String ip) {
        this.connectAddr = ip;
    }

    public String getConnectAddr() {
        return this.connectAddr;
    }

    public String getErrormsg() {
        return this.errormsg;
    }

    public void setErrormsg(String msg) {
        this.errormsg = msg;
    }

    public int getFd() {
        return this.fd;
    }

    public void setFd(int fd) {
        this.fd = fd;
    }

    public String getDnsaddressArray() {
        return this.dnsaddressArray;
    }

    public void setDnsaddressArray(String dnsaddressArray) {
        this.dnsaddressArray = dnsaddressArray;
    }

    public String toString() {
        t t2 = t.values()[this.sockettype];
        StringBuilder stringBuilder = new StringBuilder();
        if (this.addressArray != null) {
            for (String string : this.addressArray) {
                if (string == null) continue;
                stringBuilder.append(string).append(";");
            }
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)this.host)) {
            stringBuilder2.append(this.host);
        }
        return "type:" + t2.name() + ", timeElapsed:" + this.timeElapsed + ", returnValue:" + this.returnValue + ", errorNumber:" + this.errorNumber + ", content:" + stringBuilder.toString() + ", host:" + stringBuilder2.toString() + ", port:" + this.port;
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArray jsonArray = new JsonArray();
        if (this.sockettype == t.k.a()) {
            jsonArray.add(new JsonPrimitive(2));
        } else if (this.sockettype == t.c.a()) {
            jsonArray.add(new JsonPrimitive(2));
        } else if (this.sockettype == t.e.a()) {
            jsonArray.add(new JsonPrimitive(1));
        } else {
            jsonArray.add(new JsonPrimitive(this.sockettype));
        }
        String string = this.host;
        if (this.sockettype == t.e.a() && this.connectAddr != null && this.connectAddr != "") {
            string = string + "/" + this.connectAddr;
        } else if (this.sockettype == t.k.a() || this.sockettype == t.c.a()) {
            string = this.connectAddr + ":" + this.port;
            if (this.host != null && !this.host.equals("null") && SocketEvent.isHostName(this.host)) {
                string = this.host + "/" + string;
            }
        }
        jsonArray.add(new JsonPrimitive(string));
        jsonArray.add(new JsonPrimitive(this.timeElapsed));
        jsonArray.add(new JsonPrimitive(this.errorNumber));
        jsonArray.add(new JsonPrimitive(this.errormsg));
        return jsonArray;
    }

    private static boolean isHostName(String str) {
        boolean bl = false;
        String string = "[A-Za-z]+";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            bl = true;
        }
        return bl;
    }

    private static enum a {
        a,
        b,
        c;

    }
}

