/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation.io;

import com.networkbench.agent.impl.NBSAgent;
import com.networkbench.agent.impl.e.c;
import com.networkbench.agent.impl.e.d;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteEvent;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteListener;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteListenerSource;
import com.networkbench.agent.impl.instrumentation.io.a;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class NBSCountingInputStream
extends InputStream
implements NBSStreamCompleteListenerSource {
    private final InputStream impl;
    private long count = 0L;
    private final a listenerManager = new a();
    private final ByteBuffer buffer;
    private boolean enableBuffering = false;
    private static final c log = d.a();

    public NBSCountingInputStream(InputStream impl) {
        this.impl = impl;
        log.a("new NBSCountingInputStream");
        if (this.enableBuffering) {
            log.a("buffer enabled");
            this.buffer = ByteBuffer.allocate(NBSAgent.getResponseBodyLimit());
            this.fillBuffer();
        } else {
            this.buffer = null;
        }
    }

    public NBSCountingInputStream(InputStream impl, boolean enableBuffering) {
        this.impl = impl;
        this.enableBuffering = enableBuffering;
        if (enableBuffering) {
            this.buffer = ByteBuffer.allocate(NBSAgent.getResponseBodyLimit());
            this.fillBuffer();
        } else {
            this.buffer = null;
        }
    }

    @Override
    public void addStreamCompleteListener(NBSStreamCompleteListener streamCompleteListener) {
        this.listenerManager.a(streamCompleteListener);
    }

    @Override
    public void removeStreamCompleteListener(NBSStreamCompleteListener streamCompleteListener) {
        this.listenerManager.b(streamCompleteListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.enableBuffering) {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                if (this.a(1L)) {
                    int n2 = this.a();
                    if (n2 >= 0) {
                        ++this.count;
                    }
                    return n2;
                }
            }
        }
        try {
            int n3 = this.impl.read();
            if (n3 >= 0) {
                ++this.count;
            } else {
                this.c();
            }
            return n3;
        }
        catch (IOException iOException) {
            this.a(iOException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b2) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = b2.length;
        if (this.enableBuffering) {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                if (this.a(n4)) {
                    n2 = this.a(b2);
                    if (n2 >= 0) {
                        this.count += (long)n2;
                    } else {
                        throw new IOException("readBufferBytes failed");
                    }
                    return n2;
                }
                int n5 = this.buffer.remaining();
                if (n5 > 0) {
                    n3 = this.a(b2, 0, n5);
                    if (n3 < 0) {
                        throw new IOException("partial read from buffer failed");
                    }
                    n4 -= n3;
                    this.count += (long)n3;
                }
            }
        }
        try {
            n2 = this.impl.read(b2, n3, n4);
            if (n2 >= 0) {
                this.count += (long)n2;
                return n2 + n3;
            }
            log.c("end flag:" + n2);
            if (n3 <= 0) {
                this.c();
                return n2;
            }
            return n3;
        }
        catch (IOException iOException) {
            log.d("NOTIFY STREAM ERROR: " + iOException.toString());
            iOException.printStackTrace();
            this.a(iOException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = len;
        if (this.enableBuffering) {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                if (len != 0 && this.a(n4)) {
                    n2 = this.a(b2, off, len);
                    if (n2 >= 0) {
                        this.count += (long)n2;
                    } else {
                        throw new IOException("readBufferBytes failed");
                    }
                    return n2;
                }
                int n5 = this.buffer.remaining();
                if (n5 > 0) {
                    n3 = this.a(b2, off, n5);
                    if (n3 < 0) {
                        throw new IOException("partial read from buffer failed");
                    }
                    n4 -= n3;
                    this.count += (long)n3;
                }
            }
        }
        try {
            n2 = this.impl.read(b2, off + n3, n4);
            if (n2 >= 0) {
                this.count += (long)n2;
                return n2 + n3;
            }
            if (n3 <= 0) {
                this.c();
                return n2;
            }
            return n3;
        }
        catch (IOException iOException) {
            this.a(iOException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long byteCount) throws IOException {
        long l2 = byteCount;
        if (this.enableBuffering) {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                if (this.a(byteCount)) {
                    this.buffer.position((int)byteCount);
                    this.count += byteCount;
                    return byteCount;
                }
                l2 = byteCount - (long)this.buffer.remaining();
                if (l2 <= 0L) {
                    throw new IOException("partial read from buffer (skip) failed");
                }
                this.buffer.position(this.buffer.remaining());
            }
        }
        try {
            long l3 = this.impl.skip(l2);
            this.count += l3;
            return l3;
        }
        catch (IOException iOException) {
            this.a(iOException);
            throw iOException;
        }
    }

    @Override
    public int available() throws IOException {
        int n2 = 0;
        if (this.enableBuffering) {
            n2 = this.buffer.remaining();
        }
        try {
            return n2 + this.impl.available();
        }
        catch (IOException iOException) {
            this.a(iOException);
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.impl != null) {
                this.impl.close();
            }
            this.c();
        }
        catch (IOException iOException) {
            this.a(iOException);
            throw iOException;
        }
    }

    @Override
    public void mark(int readlimit) {
        if (!this.markSupported()) {
            return;
        }
        this.impl.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.impl.markSupported();
    }

    @Override
    public void reset() throws IOException {
        if (!this.markSupported()) {
            return;
        }
        try {
            this.impl.reset();
        }
        catch (IOException iOException) {
            this.a(iOException);
            throw iOException;
        }
    }

    private int a() {
        if (this.b()) {
            return -1;
        }
        int n2 = this.buffer.get() & 0xFF;
        return n2;
    }

    private int a(byte[] byArray) {
        return this.a(byArray, 0, byArray.length);
    }

    private int a(byte[] byArray, int n2, int n3) {
        if (this.b()) {
            return -1;
        }
        int n4 = this.buffer.remaining();
        this.buffer.get(byArray, n2, n3);
        return n4 - this.buffer.remaining();
    }

    private boolean a(long l2) {
        return (long)this.buffer.remaining() >= l2;
    }

    private boolean b() {
        return !this.buffer.hasRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillBuffer() {
        if (this.buffer != null) {
            if (!this.buffer.hasArray()) {
                return;
            }
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                int n2 = 0;
                try {
                    n2 = this.impl.read(this.buffer.array(), 0, this.buffer.capacity());
                }
                catch (IOException iOException) {
                    log.d(iOException.toString());
                }
                if (n2 <= 0) {
                    this.buffer.limit(0);
                } else if (n2 < this.buffer.capacity()) {
                    this.buffer.limit(n2);
                }
            }
        }
    }

    private void c() {
        if (!this.listenerManager.a()) {
            this.listenerManager.a(new NBSStreamCompleteEvent(this, this.count));
        }
    }

    private void a(Exception exception) {
        if (!this.listenerManager.a()) {
            this.listenerManager.b(new NBSStreamCompleteEvent(this, this.count, exception));
        }
    }

    public void setBufferingEnabled(boolean enableBuffering) {
        this.enableBuffering = enableBuffering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBufferAsString() {
        if (this.buffer != null) {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                byte[] byArray = new byte[this.buffer.limit()];
                for (int i2 = 0; i2 < this.buffer.limit(); ++i2) {
                    byArray[i2] = this.buffer.get(i2);
                }
                String string = null;
                try {
                    string = new String(byArray, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                return string;
            }
        }
        return "";
    }
}

