/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation.httpclient;

import com.networkbench.agent.impl.instrumentation.NBSTransactionState;
import com.networkbench.agent.impl.instrumentation.NBSTransactionStateUtil;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public final class NBSResponseHandlerImpl<T>
implements ResponseHandler<T> {
    private final ResponseHandler<T> impl;
    private final NBSTransactionState transactionState;

    private NBSResponseHandlerImpl(ResponseHandler<T> impl, NBSTransactionState transactionState) {
        this.impl = impl;
        this.transactionState = transactionState;
    }

    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        NBSTransactionStateUtil.inspectAndInstrument(this.transactionState, response);
        return (T)this.impl.handleResponse(response);
    }

    public static <T> ResponseHandler<? extends T> wrap(ResponseHandler<? extends T> impl, NBSTransactionState transactionState) {
        return new NBSResponseHandlerImpl<T>(impl, transactionState);
    }
}

