/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation.httpclient;

import com.networkbench.agent.impl.api.a.b;
import com.networkbench.agent.impl.f.b.a;
import com.networkbench.agent.impl.instrumentation.NBSTransactionState;
import com.networkbench.agent.impl.instrumentation.NBSTransactionStateUtil;
import com.networkbench.agent.impl.instrumentation.io.NBSCountingInputStream;
import com.networkbench.agent.impl.instrumentation.io.NBSCountingOutputStream;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteEvent;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteListener;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteListenerSource;
import com.networkbench.agent.impl.l.ah;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public final class NBSHttpRequestEntityImpl
implements NBSStreamCompleteListener,
HttpEntity {
    private final HttpEntity impl;
    private final NBSTransactionState transactionState;

    public NBSHttpRequestEntityImpl(HttpEntity impl, NBSTransactionState transactionState) {
        this.impl = impl;
        this.transactionState = transactionState;
    }

    public void consumeContent() throws IOException {
        try {
            this.impl.consumeContent();
        }
        catch (IOException iOException) {
            NBSTransactionStateUtil.setErrorCodeFromException(this.transactionState, iOException);
            if (!this.transactionState.isComplete()) {
                b b2 = this.transactionState.end();
                ah.a(new a(b2.h(), b2.j(), b2.k(), b2.r(), b2.s(), b2.m(), b2.n(), b2.o(), b2.l(), b2.g(), b2.p(), b2.a(), b2.b(), b2.c(), b2.d(), b2.e()));
            }
            throw iOException;
        }
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        try {
            if (!this.transactionState.isSent()) {
                NBSCountingInputStream nBSCountingInputStream = new NBSCountingInputStream(this.impl.getContent());
                nBSCountingInputStream.addStreamCompleteListener(this);
                return nBSCountingInputStream;
            }
            return this.impl.getContent();
        }
        catch (IOException iOException) {
            NBSTransactionStateUtil.setErrorCodeFromException(this.transactionState, iOException);
            if (!this.transactionState.isComplete()) {
                b b2 = this.transactionState.end();
                ah.a(new a(b2.h(), b2.j(), b2.k(), b2.r(), b2.s(), b2.m(), b2.n(), b2.o(), b2.l(), b2.g(), b2.p(), b2.a(), b2.b(), b2.c(), b2.d(), b2.e()));
            }
            throw iOException;
        }
        catch (IllegalStateException illegalStateException) {
            NBSTransactionStateUtil.setErrorCodeFromException(this.transactionState, illegalStateException);
            if (!this.transactionState.isComplete()) {
                b b3 = this.transactionState.end();
                ah.a(new a(b3.h(), b3.j(), b3.k(), b3.r(), b3.s(), b3.m(), b3.n(), b3.o(), b3.l(), b3.g(), b3.p(), b3.a(), b3.b(), b3.c(), b3.d(), b3.e()));
            }
            throw illegalStateException;
        }
    }

    public Header getContentEncoding() {
        return this.impl.getContentEncoding();
    }

    public long getContentLength() {
        return this.impl.getContentLength();
    }

    public Header getContentType() {
        return this.impl.getContentType();
    }

    public boolean isChunked() {
        return this.impl.isChunked();
    }

    public boolean isRepeatable() {
        return this.impl.isRepeatable();
    }

    public boolean isStreaming() {
        return this.impl.isStreaming();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        try {
            if (!this.transactionState.isSent()) {
                NBSCountingOutputStream nBSCountingOutputStream = new NBSCountingOutputStream(outstream);
                this.impl.writeTo((OutputStream)nBSCountingOutputStream);
                this.transactionState.setBytesSent(nBSCountingOutputStream.getCount());
            } else {
                this.impl.writeTo(outstream);
            }
        }
        catch (IOException iOException) {
            NBSTransactionStateUtil.setErrorCodeFromException(this.transactionState, iOException);
            if (!this.transactionState.isComplete()) {
                b b2 = this.transactionState.end();
                ah.a(new a(b2.h(), b2.j(), b2.k(), b2.r(), b2.s(), b2.m(), b2.n(), b2.o(), b2.l(), b2.g(), b2.p(), b2.a(), b2.b(), b2.c(), b2.d(), b2.e()));
            }
            throw iOException;
        }
    }

    @Override
    public void streamComplete(NBSStreamCompleteEvent e2) {
        NBSStreamCompleteListenerSource nBSStreamCompleteListenerSource = (NBSStreamCompleteListenerSource)e2.getSource();
        nBSStreamCompleteListenerSource.removeStreamCompleteListener(this);
        this.transactionState.setBytesSent(e2.getBytes());
    }

    @Override
    public void streamError(NBSStreamCompleteEvent e2) {
        NBSStreamCompleteListenerSource nBSStreamCompleteListenerSource = (NBSStreamCompleteListenerSource)e2.getSource();
        nBSStreamCompleteListenerSource.removeStreamCompleteListener(this);
        NBSTransactionStateUtil.setErrorCodeFromException(this.transactionState, e2.getException());
        if (!this.transactionState.isComplete()) {
            this.transactionState.setBytesSent(e2.getBytes());
            b b2 = this.transactionState.end();
            ah.a(new a(b2.h(), b2.j(), b2.k(), b2.r(), b2.s(), b2.m(), b2.n(), b2.o(), b2.l(), b2.g(), b2.p(), b2.a(), b2.b(), b2.c(), b2.d(), b2.e()));
        }
    }
}

