/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import android.text.TextUtils;
import com.networkbench.agent.impl.NBSAgent;
import com.networkbench.agent.impl.api.a.b;
import com.networkbench.agent.impl.c.s;
import com.networkbench.agent.impl.e.c;
import com.networkbench.agent.impl.e.d;
import com.networkbench.agent.impl.f.b.a;
import com.networkbench.agent.impl.f.j;
import com.networkbench.agent.impl.harvest.HarvestConfiguration;
import com.networkbench.agent.impl.harvest.HttpLibType;
import com.networkbench.agent.impl.harvest.RequestMethodType;
import com.networkbench.agent.impl.instrumentation.NBSTransactionState;
import com.networkbench.agent.impl.instrumentation.httpclient.NBSContentBufferingResponseEntityImpl;
import com.networkbench.agent.impl.instrumentation.httpclient.NBSHttpRequestEntityImpl;
import com.networkbench.agent.impl.instrumentation.httpclient.NBSHttpResponseEntityImpl;
import com.networkbench.agent.impl.instrumentation.httpclient.NBSHttpResponseEntityWrapperImpl;
import com.networkbench.agent.impl.instrumentation.io.NBSCountingInputStream;
import com.networkbench.agent.impl.l.ah;
import com.networkbench.agent.impl.l.al;
import com.networkbench.agent.impl.l.n;
import com.networkbench.agent.impl.l.x;
import com.networkbench.agent.impl.l.z;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.HttpEntityWrapper;

public class NBSTransactionStateUtil {
    private static final c log = d.a();

    public static void setUrlAndCarrier(NBSTransactionState transactionState, HttpURLConnection conn) {
        String string = conn.getURL().toString();
        String string2 = null;
        if (string.contains("?")) {
            int n2 = string.indexOf("?");
            String string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
            string = string3;
        }
        transactionState.setUrl(string);
        transactionState.setUrlParams(string2);
        transactionState.setCarrier(NBSAgent.getActiveNetworkCarrier());
    }

    public static void setCrossProcessHeader(HttpURLConnection conn) {
        conn.setRequestProperty("Tingyun-Process", "true");
        String string = x.c().E();
        if (!TextUtils.isEmpty((CharSequence)string) && x.c().D()) {
            int n2 = x.F();
            String string2 = x.a(string, n2);
            conn.setRequestProperty("X-Tingyun-Id", string2);
        }
    }

    public static void setRequestMethod(NBSTransactionState transaction, String requestmethod) {
        if (requestmethod.toUpperCase().equals("OPTIONS")) {
            transaction.setRequestMethod(RequestMethodType.OPTIONS);
        } else if (requestmethod.toUpperCase().equals("GET")) {
            transaction.setRequestMethod(RequestMethodType.GET);
        } else if (requestmethod.toUpperCase().equals("HEAD")) {
            transaction.setRequestMethod(RequestMethodType.HEAD);
        } else if (requestmethod.toUpperCase().equals("POST")) {
            transaction.setRequestMethod(RequestMethodType.POST);
        } else if (requestmethod.toUpperCase().equals("PUT")) {
            transaction.setRequestMethod(RequestMethodType.PUT);
        } else if (requestmethod.toUpperCase().equals("DELETE")) {
            transaction.setRequestMethod(RequestMethodType.DELETE);
        } else if (requestmethod.toUpperCase().equals("TRACE")) {
            transaction.setRequestMethod(RequestMethodType.TRACE);
        } else {
            transaction.setRequestMethod(RequestMethodType.GET);
        }
    }

    public static void getHttpClientRequest(NBSTransactionState transaction, HttpRequest request) {
        if (request instanceof HttpOptions) {
            transaction.setRequestMethod(RequestMethodType.OPTIONS);
        } else if (request instanceof HttpGet) {
            transaction.setRequestMethod(RequestMethodType.GET);
        } else if (request instanceof HttpHead) {
            transaction.setRequestMethod(RequestMethodType.HEAD);
        } else if (request instanceof HttpPost) {
            transaction.setRequestMethod(RequestMethodType.POST);
        } else if (request instanceof HttpPut) {
            transaction.setRequestMethod(RequestMethodType.PUT);
        } else if (request instanceof HttpDelete) {
            transaction.setRequestMethod(RequestMethodType.DELETE);
        } else if (request instanceof HttpTrace) {
            transaction.setRequestMethod(RequestMethodType.TRACE);
        } else {
            transaction.setRequestMethod(RequestMethodType.GET);
        }
    }

    private static void urlConnUrlParams(NBSTransactionState transaction, HttpRequest request, String uriParam) {
        CharSequence charSequence;
        String string = x.c().E();
        if (!TextUtils.isEmpty((CharSequence)string) && x.c().D()) {
            int n2 = x.F();
            charSequence = x.a(string, n2);
            transaction.setTyIdRandomInt(n2);
            request.setHeader("X-Tingyun-Id", (String)charSequence);
        }
        StringBuilder stringBuilder = new StringBuilder();
        charSequence = new StringBuilder();
        ArrayList<s.c> arrayList = HarvestConfiguration.getDefaultHarvestConfiguration().getUrlParamArray();
        if (arrayList == null) {
            log.c("url params is null");
            return;
        }
        if (arrayList != null) {
            String[] stringArray = arrayList.iterator();
            while (stringArray.hasNext()) {
                Object object2;
                int n3;
                int n4;
                String[] stringArray2;
                String[] stringArray3;
                String[] stringArray4 = stringArray.next();
                if (!stringArray4.a.equals(transaction.getUrl())) continue;
                if (request instanceof HttpGet && request.getParams() != null) {
                    if (stringArray4.b != null) {
                        stringArray3 = request.getParams();
                        String[] stringArray5 = stringArray2 = stringArray4.b.split(",");
                        n4 = stringArray5.length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            object2 = stringArray5[n3];
                            String string2 = (String)stringArray3.getParameter((String)object2);
                            if (string2 == null) continue;
                            stringBuilder.append((String)object2).append("=").append(string2);
                            stringBuilder.append("&");
                        }
                    }
                } else if (request instanceof HttpPost && request.getParams() != null && stringArray4.c != null) {
                    stringArray3 = request.getParams();
                    stringArray2 = stringArray4.c.split(",");
                    if (stringArray3 != null) {
                        String[] stringArray6 = stringArray2;
                        n4 = stringArray6.length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            object2 = stringArray6[n3];
                            String string3 = (String)stringArray3.getParameter((String)object2);
                            if (string3 == null) continue;
                            stringBuilder.append((String)object2).append("=").append(string3);
                            stringBuilder.append("&");
                        }
                    }
                }
                if (TextUtils.isEmpty((CharSequence)stringArray4.d)) continue;
                stringArray2 = stringArray3 = stringArray4.d.split(",");
                int n5 = stringArray2.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    String string2 = stringArray2[n4];
                    object2 = request.getAllHeaders();
                    for (Header header : object2) {
                        if (!header.getName().equals(string2)) continue;
                        stringBuilder.append(string2).append("=").append(header.getValue());
                        stringBuilder.append("&");
                    }
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            if (uriParam != null && request instanceof HttpPost) {
                for (String string3 : stringArray = uriParam.split("&")) {
                    String string4;
                    String[] stringArray7;
                    if (string3 == null || (stringArray7 = string3.split("=")) == null || stringArray7.length != 2 || stringBuilder.indexOf(string4 = stringArray7[0] + "=") >= 0) continue;
                    for (s.c c2 : arrayList) {
                        String[] stringArray2;
                        if (!c2.a.equals(transaction.getUrl()) || c2.b == null) continue;
                        for (String string5 : stringArray2 = c2.b.split(",")) {
                            if (!string5.equals(stringArray7[0])) continue;
                            String string6 = stringArray7[1];
                            ((StringBuilder)charSequence).append(string5).append("=").append(string6);
                            ((StringBuilder)charSequence).append("&");
                        }
                    }
                }
            }
            if (((StringBuilder)charSequence).length() > 0) {
                ((StringBuilder)charSequence).setLength(((StringBuilder)charSequence).length() - 1);
            }
            if (((StringBuilder)charSequence).length() > 0) {
                stringBuilder.append("&").append(charSequence);
            }
            if (stringBuilder.length() > 0) {
                transaction.setFormattedUrlParams(stringBuilder.toString());
            }
        }
    }

    public static void processUrlParams(NBSTransactionState transactionState, HttpURLConnection conn) {
        if (transactionState.hasParseUrlParams) {
            return;
        }
        transactionState.hasParseUrlParams = true;
        String string = transactionState.getUrl();
        String string2 = transactionState.getUrlParams();
        ArrayList<s.c> arrayList = HarvestConfiguration.getDefaultHarvestConfiguration().getUrlParamArray();
        if (arrayList != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string2 != null) {
                String[] stringArray;
                for (String string3 : stringArray = string2.split("&")) {
                    String[] stringArray2;
                    if (string3 == null || (stringArray2 = string3.split("=")) == null || stringArray2.length != 2) continue;
                    for (Object object : arrayList) {
                        String[] stringArray3;
                        if (!((s.c)object).a.equals(string) || ((s.c)object).b == null) continue;
                        for (String string4 : stringArray3 = ((s.c)object).b.split(",")) {
                            if (!string4.equals(stringArray2[0])) continue;
                            String string5 = stringArray2[1];
                            stringBuilder.append(string4).append("=").append(string5);
                            stringBuilder.append("&");
                        }
                    }
                }
            }
            for (s.c c2 : arrayList) {
                String[] stringArray;
                if (!c2.a.equals(string) || TextUtils.isEmpty((CharSequence)c2.d)) continue;
                for (String string6 : stringArray = c2.d.split(",")) {
                    Object object;
                    object = conn.getRequestProperty(string6);
                    if (TextUtils.isEmpty((CharSequence)object) || stringBuilder.toString().contains(string6 + "=")) continue;
                    stringBuilder.append(string6).append("=").append((String)object);
                    stringBuilder.append("&");
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
                transactionState.setFormattedUrlParams(stringBuilder.toString());
            }
        }
    }

    public static void inspectAndInstrumentResponse(NBSTransactionState transactionState, HttpURLConnection conn) {
        String string = conn.getHeaderField("X-Tingyun-Tx-Data");
        if (string != null && !"".equals(string)) {
            log.c("header:" + string);
            transactionState.setAppData(string);
        }
        NBSTransactionStateUtil.processUrlParams(transactionState, conn);
        int n2 = conn.getContentLength();
        if (n2 >= 0) {
            transactionState.setBytesReceived(n2);
        }
        log.c("content length:" + n2);
        int n3 = -1;
        try {
            n3 = conn.getResponseCode();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        transactionState.setStatusCode(n3);
    }

    public static HttpRequest inspectAndInstrument(NBSTransactionState transactionState, HttpHost host, HttpRequest request) {
        if (request == null) {
            return request;
        }
        RequestLine requestLine = request.getRequestLine();
        String string = null;
        String string2 = null;
        if (requestLine != null && (string = requestLine.getUri()).contains("?")) {
            int n2 = string.indexOf("?");
            String string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
            string = string3;
        }
        transactionState.setUrl(string);
        transactionState.setUrlParams(string2);
        transactionState.setHttpLibType(HttpLibType.HttpClient);
        NBSTransactionStateUtil.processParamsAndHeader(transactionState, request, string2);
        transactionState.setCarrier(NBSAgent.getActiveNetworkCarrier());
        NBSTransactionStateUtil.wrapRequestEntity(transactionState, request);
        return request;
    }

    public static HttpUriRequest inspectAndInstrument(NBSTransactionState transactionState, HttpUriRequest request) {
        if (request == null) {
            return request;
        }
        RequestLine requestLine = request.getRequestLine();
        String string = null;
        String string2 = null;
        if (requestLine != null) {
            string = requestLine.getUri();
            if (string.contains("?")) {
                int n2 = string.indexOf("?");
                String string3 = string.substring(0, n2);
                string2 = string.substring(n2 + 1);
                string = string3;
            }
        } else {
            string = request.getURI().toString();
        }
        transactionState.setUrl(string);
        transactionState.setCarrier(NBSAgent.getActiveNetworkCarrier());
        transactionState.setMethodType(request.getMethod());
        transactionState.setUrlParams(string2);
        transactionState.setHttpLibType(HttpLibType.HttpClient);
        NBSTransactionStateUtil.processParamsAndHeader(transactionState, (HttpRequest)request, string2);
        NBSTransactionStateUtil.wrapRequestEntity(transactionState, (HttpRequest)request);
        return request;
    }

    private static void processParamsAndHeader(NBSTransactionState transaction, HttpRequest request, String uriParam) {
        String[] stringArray;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        NBSTransactionStateUtil.getHttpClientRequest(transaction, request);
        if (request != null) {
            request.setHeader("Tingyun-Process", "true");
            object = x.c().E();
            if (!TextUtils.isEmpty((CharSequence)object) && x.c().D()) {
                int n2 = x.F();
                stringArray = x.a((String)object, n2);
                transaction.setTyIdRandomInt(n2);
                request.setHeader("X-Tingyun-Id", (String)stringArray);
            }
        }
        if ((object = HarvestConfiguration.getDefaultHarvestConfiguration().getUrlParamArray()) == null) {
            log.c("url params is null");
            return;
        }
        if (object != null) {
            Object object2;
            String[] stringArray2 = ((ArrayList)object).iterator();
            while (stringArray2.hasNext()) {
                String[] stringArray3;
                stringArray = (s.c)stringArray2.next();
                if (!stringArray.a.equals(transaction.getUrl())) continue;
                log.a("urlParam.url.equals(transaction.getUrl()) is true");
                if ((request instanceof HttpPost || request instanceof HttpGet) && request.getParams() != null && stringArray.c != null) {
                    stringArray3 = request.getParams();
                    String[] stringArray4 = stringArray.c.split(",");
                    if (stringArray3 != null) {
                        String[] stringArray5 = stringArray4;
                        int stringArray6 = stringArray5.length;
                        for (int string = 0; string < stringArray6; ++string) {
                            object2 = stringArray5[string];
                            String string2 = (String)stringArray3.getParameter((String)object2);
                            if (string2 == null) continue;
                            stringBuilder.append((String)object2).append("=").append(string2);
                            stringBuilder.append("&");
                        }
                    }
                }
                if (TextUtils.isEmpty((CharSequence)stringArray.d)) continue;
                for (String string : stringArray3 = stringArray.d.split(",")) {
                    object2 = request.getAllHeaders();
                    if (object2 == null) continue;
                    for (Header header : object2) {
                        if (!header.getName().equals(string)) continue;
                        stringBuilder.append(string).append("=").append(header.getValue());
                        stringBuilder.append("&");
                    }
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            if (uriParam != null && (request instanceof HttpPost || request instanceof HttpGet)) {
                for (String string : stringArray2 = uriParam.split("&")) {
                    String string3;
                    String[] stringArray3;
                    if (string == null || (stringArray3 = string.split("=")) == null || stringArray3.length != 2 || stringBuilder.indexOf(string3 = stringArray3[0] + "=") >= 0) continue;
                    object2 = ((ArrayList)object).iterator();
                    while (object2.hasNext()) {
                        String[] stringArray4;
                        s.c c2 = (s.c)object2.next();
                        if (!c2.a.equals(transaction.getUrl()) || c2.b == null) continue;
                        for (String string4 : stringArray4 = c2.b.split(",")) {
                            if (!string4.equals(stringArray3[0])) continue;
                            String string5 = stringArray3[1];
                            stringBuilder2.append(string4).append("=").append(string5);
                            stringBuilder2.append("&");
                        }
                    }
                }
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder2.setLength(stringBuilder2.length() - 1);
            }
            if (stringBuilder2.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("&").append((CharSequence)stringBuilder2);
                } else {
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
            }
            if (stringBuilder.length() > 0) {
                transaction.setFormattedUrlParams(stringBuilder.toString());
                log.a("requestUrlParams......" + stringBuilder.toString());
            }
        }
    }

    private static void wrapRequestEntity(NBSTransactionState transactionState, HttpRequest request) {
        HttpEntityEnclosingRequest httpEntityEnclosingRequest;
        if (request instanceof HttpEntityEnclosingRequest && (httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            httpEntityEnclosingRequest.setEntity((HttpEntity)new NBSHttpRequestEntityImpl(httpEntityEnclosingRequest.getEntity(), transactionState));
        }
    }

    public static HttpResponse inspectAndInstrument(NBSTransactionState transactionState, HttpResponse response) {
        block11: {
            transactionState.setStatusCode(response.getStatusLine().getStatusCode());
            Header[] headerArray = response.getHeaders("X-Tingyun-Tx-Data");
            log.c("get X-Tingyun-Tx-Data");
            if (headerArray != null && headerArray.length > 0 && !"".equals(headerArray[0].getValue())) {
                log.c("header:" + headerArray[0].getValue());
                transactionState.setAppData(headerArray[0].getValue());
            }
            Header[] headerArray2 = response.getHeaders("Content-Length");
            long l2 = -1L;
            if (headerArray2 != null && headerArray2.length > 0) {
                try {
                    l2 = Long.parseLong(headerArray2[0].getValue());
                    transactionState.setBytesReceived(l2);
                    HttpEntity httpEntity = response.getEntity();
                    if (httpEntity == null) {
                        response.setEntity(null);
                        break block11;
                    }
                    if (httpEntity instanceof HttpEntityWrapper) {
                        response.setEntity((HttpEntity)new NBSHttpResponseEntityWrapperImpl(response, transactionState, l2));
                        break block11;
                    }
                    response.setEntity((HttpEntity)new NBSHttpResponseEntityImpl(response, transactionState, l2));
                }
                catch (NumberFormatException numberFormatException) {
                    log.e("Failed to parse content length: " + numberFormatException.toString());
                }
            } else if (response.getEntity() != null) {
                if (response.getEntity() instanceof HttpEntityWrapper) {
                    response.setEntity((HttpEntity)new NBSHttpResponseEntityWrapperImpl(response, transactionState, l2));
                } else {
                    response.setEntity((HttpEntity)new NBSHttpResponseEntityImpl(response, transactionState, l2));
                }
            } else {
                transactionState.setBytesReceived(0L);
                NBSTransactionStateUtil.addTransactionAndErrorData(transactionState, null);
            }
        }
        return response;
    }

    public static int inspectAndInstrument(NBSTransactionState transactionState, int responseCode) {
        transactionState.setStatusCode(responseCode);
        transactionState.setBytesReceived(0L);
        return responseCode;
    }

    public static String getSanitizedStackTrace() {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n2 = 0;
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder.append(stackTraceElement.toString());
            if (i2 <= stackTraceElementArray.length - 1) {
                stringBuilder.append("\n");
            }
            if (++n2 >= NBSAgent.getStackTraceLimit()) break;
        }
        return stringBuilder.toString();
    }

    public static void setErrorCodeFromException(NBSTransactionState transactionState, Exception e2) {
        String string = NBSTransactionStateUtil.getSanitizedStackTrace();
        if (e2 instanceof UnknownHostException) {
            transactionState.setErrorCode(901, e2.toString());
            transactionState.setStatusCode(901);
        } else if (e2 instanceof SocketTimeoutException || e2 instanceof ConnectTimeoutException) {
            transactionState.setErrorCode(903, e2.toString());
            transactionState.setStatusCode(903);
        } else if (e2 instanceof ConnectException) {
            transactionState.setErrorCode(902, e2.toString());
            transactionState.setStatusCode(902);
        } else if (e2 instanceof MalformedURLException) {
            transactionState.setErrorCode(900, e2.toString());
            transactionState.setStatusCode(900);
        } else if (e2 instanceof SSLException) {
            transactionState.setErrorCode(908, e2.toString());
            transactionState.setStatusCode(908);
        } else if (e2 instanceof HttpResponseException) {
            transactionState.setStatusCode(((HttpResponseException)e2).getStatusCode());
        } else if (e2 instanceof ClientProtocolException) {
            transactionState.setErrorCode(904, e2.toString());
            transactionState.setStatusCode(904);
            log.c(string);
        } else if (e2 instanceof AuthenticationException) {
            transactionState.setErrorCode(907, e2.toString());
            transactionState.setStatusCode(907);
        } else {
            transactionState.setErrorCode(-1, e2.toString());
            transactionState.setStatusCode(-1);
        }
    }

    private static void addTransactionAndErrorData(NBSTransactionState transactionState, HttpResponse response) {
        block14: {
            try {
                Object object;
                n n2 = NBSAgent.getImpl();
                if (n2 == null) {
                    return;
                }
                HarvestConfiguration harvestConfiguration = n2.q();
                if (harvestConfiguration == null) {
                    return;
                }
                b b2 = transactionState.end();
                if (null == b2) {
                    log.e("HttpResponseEntityWrapperImpl transactionData is null!");
                    return;
                }
                if (!al.b(b2.h(), harvestConfiguration.getUrlFilterMode(), harvestConfiguration.getUrlRules())) {
                    return;
                }
                if (transactionState.isError() && al.a(b2.h(), b2.j(), harvestConfiguration.getIgnoreErrRules())) {
                    transactionState.setStatusCode(200);
                    b2.a(200);
                    b2.b(0);
                }
                ah.a(new a(b2.h(), b2.j(), b2.k(), b2.r(), b2.s(), b2.m(), b2.n(), b2.o(), b2.l(), b2.g(), b2.p(), b2.a(), b2.b(), b2.c(), b2.d(), b2.e()));
                if (!transactionState.isError()) break block14;
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    if (!(response.getEntity() instanceof NBSHttpRequestEntityImpl)) {
                        response.setEntity((HttpEntity)new NBSContentBufferingResponseEntityImpl(response.getEntity()));
                    }
                    if ((object = response.getEntity().getContent()) instanceof NBSCountingInputStream) {
                        stringBuilder.append(((NBSCountingInputStream)object).getBufferAsString());
                    } else {
                        log.d("Unable to wrap content stream for entity");
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    log.d(illegalStateException.toString());
                }
                catch (IOException iOException) {
                    log.d(iOException.toString());
                }
                object = z.a(response);
                object.put("Content-Length", transactionState.getBytesReceived());
                log.c("response body content:" + stringBuilder.toString());
                String string = "";
                if (transactionState.getException() != null) {
                    string = transactionState.getException();
                }
                log.c("error message:" + string);
                j.a(b2.h(), transactionState.getFormattedUrlParams(), transactionState.getUrlParams(), b2.j(), stringBuilder.toString(), (Map<String, Object>)object, string, b2.g(), b2.b());
            }
            catch (Exception exception) {
                log.a("addTransactionAndErrorData", exception);
            }
        }
    }

    @Deprecated
    void a() {
    }
}

