/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import com.networkbench.agent.impl.e.c;
import com.networkbench.agent.impl.e.d;
import com.networkbench.agent.impl.harvest.type.MetricCategory;
import com.networkbench.agent.impl.instrumentation.NBSTraceEngine;
import com.networkbench.agent.impl.l.am;
import com.networkbench.agent.impl.tracing.TraceType;
import com.networkbench.agent.impl.tracing.TracingInactiveException;
import com.networkbench.com.google.gson.Gson;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class NBSTraceUnit {
    private static final String CATEGORY_PARAMETER = "category";
    private static final c log = d.a();
    public final UUID parentUUID;
    public final UUID myUUID = new UUID(am.a().nextLong(), am.a().nextLong());
    public long entryTimestamp = 0L;
    public long exitTimestamp = 0L;
    public long exclusiveTime = 0L;
    public long childExclusiveTime = 0L;
    public String metricName;
    public String metricBackgroundName;
    public String displayName;
    public String scope;
    public long threadId = 0L;
    public String threadName = "main";
    private volatile Map<String, Object> params;
    private List<String> rawAnnotationParams;
    private volatile Set<UUID> children;
    private TraceType type = TraceType.TRACE;
    private boolean isComplete = false;
    public NBSTraceEngine tracer;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" type:" + this.type.name());
        stringBuilder.append(" metricName:" + this.metricName);
        stringBuilder.append(" metricBackgroundName:" + this.metricBackgroundName);
        stringBuilder.append(" displayName:" + this.displayName);
        stringBuilder.append(" scope:" + this.scope);
        stringBuilder.append(" parentUUID:" + this.parentUUID);
        if (this.params != null && this.params.size() > 0) {
            String string = new Gson().toJson(this.params);
            stringBuilder.append(" params:" + string);
        }
        return stringBuilder.toString();
    }

    public NBSTraceUnit() {
        this.parentUUID = null;
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
    }

    public NBSTraceUnit(String displayName, UUID parentUUID, NBSTraceEngine tracer) {
        this.displayName = displayName;
        this.parentUUID = parentUUID;
        this.tracer = tracer;
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
        log.c("new trace object, UUID:" + this.myUUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(NBSTraceUnit trace) {
        if (this.children == null) {
            NBSTraceUnit nBSTraceUnit = this;
            synchronized (nBSTraceUnit) {
                if (this.children == null) {
                    this.children = Collections.synchronizedSet(new LinkedHashSet());
                }
            }
        }
        this.children.add(trace.myUUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UUID> getChildren() {
        if (this.children == null) {
            NBSTraceUnit nBSTraceUnit = this;
            synchronized (nBSTraceUnit) {
                if (this.children == null) {
                    this.children = Collections.synchronizedSet(new LinkedHashSet());
                }
            }
        }
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getParams() {
        if (this.params == null) {
            NBSTraceUnit nBSTraceUnit = this;
            synchronized (nBSTraceUnit) {
                if (this.params == null) {
                    this.params = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.params;
    }

    public void setAnnotationParams(List<String> rawAnnotationParams) {
        this.rawAnnotationParams = rawAnnotationParams;
    }

    public Map<String, Object> getAnnotationParams() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.rawAnnotationParams != null && this.rawAnnotationParams.size() > 0) {
            Iterator<String> iterator = this.rawAnnotationParams.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2;
                String string3 = iterator.next();
                Object object = NBSTraceUnit.createParameter(string3, string2 = iterator.next(), string = iterator.next());
                if (object == null) continue;
                hashMap.put(string3, object);
            }
        }
        return hashMap;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void complete() throws TracingInactiveException {
        if (this.isComplete) {
            log.e("Attempted to double complete trace " + this.myUUID.toString());
            return;
        }
        if (this.exitTimestamp == 0L) {
            this.exitTimestamp = System.currentTimeMillis();
        }
        this.exclusiveTime = this.getDuration() - this.childExclusiveTime;
        this.isComplete = true;
        try {
            this.tracer.storeCompletedTrace(this);
        }
        catch (NullPointerException nullPointerException) {
            throw new TracingInactiveException();
        }
    }

    public TraceType getType() {
        return this.type;
    }

    public void setType(TraceType type) {
        this.type = type;
    }

    public long getDuration() {
        return this.exitTimestamp - this.entryTimestamp;
    }

    public MetricCategory getCategory() {
        if (!this.getAnnotationParams().containsKey(CATEGORY_PARAMETER)) {
            return null;
        }
        Object object = this.getAnnotationParams().get(CATEGORY_PARAMETER);
        if (!(object instanceof MetricCategory)) {
            log.d("Category annotation parameter is not of type MetricCategory");
            return null;
        }
        return (MetricCategory)((Object)object);
    }

    private static Object createParameter(String parameterName, String parameterClass, String parameterValue) {
        Class<?> clazz;
        try {
            clazz = Class.forName(parameterClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.a("Unable to resolve parameter class in enterMethod: " + classNotFoundException.getMessage(), classNotFoundException);
            return null;
        }
        if (MetricCategory.class == clazz) {
            return MetricCategory.valueOf(parameterValue);
        }
        if (String.class == clazz) {
            return parameterValue;
        }
        return null;
    }

    @Deprecated
    void a() {
    }
}

