/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import android.webkit.WebView;
import com.networkbench.agent.impl.NBSAgent;
import com.networkbench.agent.impl.api.a.b;
import com.networkbench.agent.impl.e.c;
import com.networkbench.agent.impl.e.d;
import com.networkbench.agent.impl.f.b.a;
import com.networkbench.agent.impl.f.j;
import com.networkbench.agent.impl.harvest.HarvestConfiguration;
import com.networkbench.agent.impl.instrumentation.NBSHttpURLConnectionExtension;
import com.networkbench.agent.impl.instrumentation.NBSHttpsURLConnectionExtension;
import com.networkbench.agent.impl.instrumentation.NBSReplaceCallSite;
import com.networkbench.agent.impl.instrumentation.NBSTransactionState;
import com.networkbench.agent.impl.instrumentation.NBSTransactionStateUtil;
import com.networkbench.agent.impl.instrumentation.NBSWrapReturn;
import com.networkbench.agent.impl.instrumentation.httpclient.NBSResponseHandlerImpl;
import com.networkbench.agent.impl.l.ah;
import com.networkbench.agent.impl.l.al;
import com.networkbench.agent.impl.l.n;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public final class NBSInstrumentation {
    private static final c log = d.a();

    @NBSWrapReturn(className="java/net/URL", methodName="openConnection", methodDesc="()Ljava/net/URLConnection;")
    public static URLConnection openConnection(URLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            return new NBSHttpsURLConnectionExtension((HttpsURLConnection)connection);
        }
        if (connection instanceof HttpURLConnection) {
            return new NBSHttpURLConnectionExtension((HttpURLConnection)connection);
        }
        return connection;
    }

    public static URLConnection openConnection(URL url) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            if (httpURLConnection instanceof HttpsURLConnection) {
                return new NBSHttpsURLConnectionExtension((HttpsURLConnection)httpURLConnection);
            }
            if (httpURLConnection instanceof HttpURLConnection) {
                return new NBSHttpURLConnectionExtension(httpURLConnection);
            }
            return httpURLConnection;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static URLConnection openConnection(URL url, Proxy proxy) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection(proxy);
            if (httpURLConnection instanceof HttpsURLConnection) {
                return new NBSHttpsURLConnectionExtension((HttpsURLConnection)httpURLConnection);
            }
            if (httpURLConnection instanceof HttpURLConnection) {
                return new NBSHttpURLConnectionExtension(httpURLConnection);
            }
            return httpURLConnection;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    @NBSWrapReturn(className="java.net.URL", methodName="openConnection", methodDesc="(Ljava/net/Proxy;)Ljava/net/URLConnection;")
    public static URLConnection openConnectionWithProxy(URLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            return new NBSHttpsURLConnectionExtension((HttpsURLConnection)connection);
        }
        if (connection instanceof HttpURLConnection) {
            return new NBSHttpURLConnectionExtension((HttpURLConnection)connection);
        }
        return connection;
    }

    @NBSReplaceCallSite(isStatic=true)
    public static HttpResponse execute(HttpClient httpClient, HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        NBSTransactionState nBSTransactionState = new NBSTransactionState();
        try {
            return NBSInstrumentation._(httpClient.execute(target, NBSInstrumentation._(target, request, nBSTransactionState), context), nBSTransactionState);
        }
        catch (IOException iOException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, iOException);
            throw iOException;
        }
    }

    @NBSReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        NBSTransactionState nBSTransactionState = new NBSTransactionState();
        try {
            return (T)httpClient.execute(target, NBSInstrumentation._(target, request, nBSTransactionState), NBSInstrumentation._(responseHandler, nBSTransactionState), context);
        }
        catch (ClientProtocolException clientProtocolException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, (Exception)((Object)clientProtocolException));
            throw clientProtocolException;
        }
        catch (IOException iOException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, iOException);
            throw iOException;
        }
    }

    @NBSReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        NBSTransactionState nBSTransactionState = new NBSTransactionState();
        try {
            return (T)httpClient.execute(target, NBSInstrumentation._(target, request, nBSTransactionState), NBSInstrumentation._(responseHandler, nBSTransactionState));
        }
        catch (ClientProtocolException clientProtocolException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, (Exception)((Object)clientProtocolException));
            throw clientProtocolException;
        }
        catch (IOException iOException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, iOException);
            throw iOException;
        }
    }

    @NBSReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpHost target, HttpRequest request) throws IOException {
        NBSTransactionState nBSTransactionState = new NBSTransactionState();
        try {
            return NBSInstrumentation._(httpClient.execute(target, NBSInstrumentation._(target, request, nBSTransactionState)), nBSTransactionState);
        }
        catch (IOException iOException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, iOException);
            throw iOException;
        }
    }

    @NBSReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest request, HttpContext context) throws IOException {
        NBSTransactionState nBSTransactionState = new NBSTransactionState();
        try {
            return NBSInstrumentation._(httpClient.execute(NBSInstrumentation._(request, nBSTransactionState), context), nBSTransactionState);
        }
        catch (IOException iOException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, iOException);
            throw iOException;
        }
    }

    @NBSReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        NBSTransactionState nBSTransactionState = new NBSTransactionState();
        try {
            return (T)httpClient.execute(NBSInstrumentation._(request, nBSTransactionState), NBSInstrumentation._(responseHandler, nBSTransactionState), context);
        }
        catch (ClientProtocolException clientProtocolException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, (Exception)((Object)clientProtocolException));
            throw clientProtocolException;
        }
        catch (IOException iOException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, iOException);
            throw iOException;
        }
    }

    @NBSReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        NBSTransactionState nBSTransactionState = new NBSTransactionState();
        try {
            return (T)httpClient.execute(NBSInstrumentation._(request, nBSTransactionState), NBSInstrumentation._(responseHandler, nBSTransactionState));
        }
        catch (ClientProtocolException clientProtocolException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, (Exception)((Object)clientProtocolException));
            throw clientProtocolException;
        }
        catch (IOException iOException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, iOException);
            throw iOException;
        }
    }

    @NBSReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest request) throws IOException {
        NBSTransactionState nBSTransactionState = new NBSTransactionState();
        try {
            return NBSInstrumentation._(httpClient.execute(NBSInstrumentation._(request, nBSTransactionState)), nBSTransactionState);
        }
        catch (IOException iOException) {
            NBSInstrumentation.httpClientError(nBSTransactionState, iOException);
            throw iOException;
        }
    }

    public static void loadUrl(WebView webView, String url) {
        log.a("webview loadurl with url");
        NBSTransactionState nBSTransactionState = new NBSTransactionState();
        nBSTransactionState.setUrl(url);
        webView.loadUrl(url);
        b b2 = nBSTransactionState.end();
        NBSAgent.addTransactionData(b2);
    }

    private static void httpClientError(NBSTransactionState transactionState, Exception e2) {
        if (!transactionState.isComplete()) {
            NBSTransactionStateUtil.setErrorCodeFromException(transactionState, e2);
            b b2 = transactionState.end();
            n n2 = NBSAgent.getImpl();
            if (n2 == null) {
                return;
            }
            HarvestConfiguration harvestConfiguration = n2.q();
            if (harvestConfiguration == null) {
                return;
            }
            if (b2 == null) {
                log.d("transactionData is null");
                return;
            }
            if (!al.b(b2.h(), harvestConfiguration.getUrlFilterMode(), harvestConfiguration.getUrlRules())) {
                return;
            }
            if (transactionState.isError() && al.a(b2.h(), b2.j(), harvestConfiguration.getIgnoreErrRules())) {
                b2.a(200);
                b2.b(0);
                transactionState.setStatusCode(200);
            }
            ah.a(new a(b2.h(), b2.j(), b2.k(), b2.r(), b2.s(), b2.m(), b2.n(), b2.o(), b2.l(), b2.g(), b2.p(), b2.a(), b2.b(), b2.c(), b2.d(), b2.e()));
            if (transactionState.isError()) {
                String string = "";
                if (transactionState.getException() != null) {
                    string = transactionState.getException();
                }
                log.a("error message:" + string);
                if (al.a(b2.h(), b2.j(), harvestConfiguration.getIgnoreErrRules())) {
                    transactionState.setStatusCode(200);
                }
                if (transactionState.isError()) {
                    j.a(transactionState.getUrl(), transactionState.getFormattedUrlParams(), transactionState.getUrlParams(), transactionState.getStatusCode(), string, transactionState.getRequestMethodType(), b2.b());
                }
            }
        }
    }

    private static HttpUriRequest _(HttpUriRequest request, NBSTransactionState transactionState) {
        return NBSTransactionStateUtil.inspectAndInstrument(transactionState, request);
    }

    private static HttpRequest _(HttpHost host, HttpRequest request, NBSTransactionState transactionState) {
        return NBSTransactionStateUtil.inspectAndInstrument(transactionState, host, request);
    }

    private static HttpResponse _(HttpResponse response, NBSTransactionState transactionState) {
        return NBSTransactionStateUtil.inspectAndInstrument(transactionState, response);
    }

    private static <T> ResponseHandler<? extends T> _(ResponseHandler<? extends T> handler, NBSTransactionState transactionState) {
        return NBSResponseHandlerImpl.wrap(handler, transactionState);
    }

    @Deprecated
    void a() {
    }
}

