/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import com.networkbench.agent.impl.NBSAgent;
import com.networkbench.agent.impl.api.a.b;
import com.networkbench.agent.impl.e.c;
import com.networkbench.agent.impl.e.d;
import com.networkbench.agent.impl.f.b.a;
import com.networkbench.agent.impl.f.j;
import com.networkbench.agent.impl.harvest.HarvestConfiguration;
import com.networkbench.agent.impl.harvest.HttpLibType;
import com.networkbench.agent.impl.instrumentation.NBSTransactionState;
import com.networkbench.agent.impl.instrumentation.NBSTransactionStateUtil;
import com.networkbench.agent.impl.instrumentation.io.NBSCountingInputStream;
import com.networkbench.agent.impl.instrumentation.io.NBSCountingOutputStream;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteEvent;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteListener;
import com.networkbench.agent.impl.l.ah;
import com.networkbench.agent.impl.l.al;
import com.networkbench.agent.impl.l.n;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class NBSHttpsURLConnectionExtension
extends HttpsURLConnection {
    private HttpsURLConnection impl;
    private NBSTransactionState transactionState;
    private static final c log = d.a();
    NBSCountingInputStream a;

    public NBSHttpsURLConnectionExtension(HttpsURLConnection impl) {
        super(impl.getURL());
        this.impl = impl;
        NBSTransactionStateUtil.setCrossProcessHeader(impl);
    }

    @Override
    public String getCipherSuite() {
        return this.impl.getCipherSuite();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.impl.getLocalCertificates();
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        try {
            return this.impl.getServerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            this.error(sSLPeerUnverifiedException);
            throw sSLPeerUnverifiedException;
        }
    }

    @Override
    public void addRequestProperty(String field, String newValue) {
        this.impl.addRequestProperty(field, newValue);
    }

    @Override
    public void disconnect() {
        if (this.transactionState != null && !this.transactionState.isComplete()) {
            this.addTransactionAndErrorData(this.transactionState);
        }
        this.impl.disconnect();
    }

    @Override
    public boolean usingProxy() {
        return this.impl.usingProxy();
    }

    @Override
    public void connect() throws IOException {
        this.getTransactionState();
        try {
            this.impl.connect();
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.impl.getAllowUserInteraction();
    }

    @Override
    public int getConnectTimeout() {
        return this.impl.getConnectTimeout();
    }

    @Override
    public Object getContent() throws IOException {
        NBSTransactionState nBSTransactionState;
        Object object;
        this.getTransactionState();
        try {
            object = this.impl.getContent();
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        int n2 = this.impl.getContentLength();
        if (n2 >= 0 && !(nBSTransactionState = this.getTransactionState()).isComplete()) {
            nBSTransactionState.setBytesReceived(n2);
            this.addTransactionAndErrorData(nBSTransactionState);
        }
        return object;
    }

    public Object getContent(Class[] types) throws IOException {
        Object object;
        this.getTransactionState();
        try {
            object = this.impl.getContent(types);
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        this.checkResponse();
        return object;
    }

    @Override
    public String getContentEncoding() {
        this.getTransactionState();
        String string = this.impl.getContentEncoding();
        this.checkResponse();
        return string;
    }

    @Override
    public int getContentLength() {
        this.getTransactionState();
        int n2 = this.impl.getContentLength();
        this.checkResponse();
        return n2;
    }

    @Override
    public String getContentType() {
        this.getTransactionState();
        String string = this.impl.getContentType();
        this.checkResponse();
        return string;
    }

    @Override
    public long getDate() {
        this.getTransactionState();
        long l2 = this.impl.getDate();
        this.checkResponse();
        return l2;
    }

    @Override
    public InputStream getErrorStream() {
        this.getTransactionState();
        if (this.a != null) {
            return this.a;
        }
        try {
            this.a = new NBSCountingInputStream(this.impl.getErrorStream(), true);
        }
        catch (Exception exception) {
            log.d(exception.toString());
            return this.impl.getErrorStream();
        }
        return this.a;
    }

    @Override
    public long getHeaderFieldDate(String field, long defaultValue) {
        this.getTransactionState();
        long l2 = this.impl.getHeaderFieldDate(field, defaultValue);
        this.checkResponse();
        return l2;
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.impl.getInstanceFollowRedirects();
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.impl.getPermission();
    }

    @Override
    public String getRequestMethod() {
        NBSTransactionState nBSTransactionState = this.getTransactionState();
        String string = this.impl.getRequestMethod();
        NBSTransactionStateUtil.setRequestMethod(nBSTransactionState, string);
        this.transactionState.setHttpLibType(HttpLibType.URLConnection);
        return string;
    }

    @Override
    public int getResponseCode() throws IOException {
        int n2;
        this.getTransactionState();
        try {
            n2 = this.impl.getResponseCode();
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        this.checkResponse();
        return n2;
    }

    @Override
    public String getResponseMessage() throws IOException {
        String string;
        this.getTransactionState();
        try {
            string = this.impl.getResponseMessage();
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        this.checkResponse();
        return string;
    }

    @Override
    public void setChunkedStreamingMode(int chunkLength) {
        this.impl.setChunkedStreamingMode(chunkLength);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.impl.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.impl.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.getTransactionState();
        try {
            this.impl.setRequestMethod(method);
            this.transactionState.setMethodType(method);
            this.transactionState.setHttpLibType(HttpLibType.URLConnection);
            NBSTransactionStateUtil.setRequestMethod(this.getTransactionState(), method);
        }
        catch (ProtocolException protocolException) {
            this.error(protocolException);
            throw protocolException;
        }
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.impl.getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return this.impl.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this.impl.getDoOutput();
    }

    @Override
    public long getExpiration() {
        this.getTransactionState();
        long l2 = this.impl.getExpiration();
        this.checkResponse();
        return l2;
    }

    @Override
    public String getHeaderField(int pos) {
        this.getTransactionState();
        String string = this.impl.getHeaderField(pos);
        this.checkResponse();
        return string;
    }

    @Override
    public String getHeaderField(String key) {
        this.getTransactionState();
        String string = this.impl.getHeaderField(key);
        this.checkResponse();
        return string;
    }

    @Override
    public int getHeaderFieldInt(String field, int defaultValue) {
        this.getTransactionState();
        int n2 = this.impl.getHeaderFieldInt(field, defaultValue);
        this.checkResponse();
        return n2;
    }

    @Override
    public String getHeaderFieldKey(int posn) {
        this.getTransactionState();
        String string = this.impl.getHeaderFieldKey(posn);
        this.checkResponse();
        return string;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        this.getTransactionState();
        Map<String, List<String>> map = this.impl.getHeaderFields();
        this.checkResponse();
        return map;
    }

    @Override
    public long getIfModifiedSince() {
        this.getTransactionState();
        long l2 = this.impl.getIfModifiedSince();
        this.checkResponse();
        return l2;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        final NBSTransactionState nBSTransactionState = this.getTransactionState();
        NBSCountingInputStream nBSCountingInputStream = null;
        try {
            nBSCountingInputStream = new NBSCountingInputStream(this.impl.getInputStream());
            NBSTransactionStateUtil.inspectAndInstrumentResponse(nBSTransactionState, this.impl);
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        if (nBSCountingInputStream != null) {
            nBSCountingInputStream.addStreamCompleteListener(new NBSStreamCompleteListener(){

                @Override
                public void streamError(NBSStreamCompleteEvent e2) {
                    try {
                        int n2 = NBSHttpsURLConnectionExtension.this.impl.getResponseCode();
                        nBSTransactionState.setStatusCode(n2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!nBSTransactionState.isComplete()) {
                        nBSTransactionState.setBytesReceived(e2.getBytes());
                    }
                    NBSHttpsURLConnectionExtension.this.error(e2.getException());
                }

                @Override
                public void streamComplete(NBSStreamCompleteEvent e2) {
                    if (!nBSTransactionState.isComplete()) {
                        int n2 = 0;
                        try {
                            n2 = NBSHttpsURLConnectionExtension.this.impl.getResponseCode();
                            nBSTransactionState.setStatusCode(n2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        long l2 = e2.getBytes();
                        if (n2 != 206) {
                            long l3 = NBSHttpsURLConnectionExtension.this.impl.getContentLength();
                            l2 = l3 >= 0L ? l3 : l2;
                        }
                        nBSTransactionState.setBytesReceived(l2);
                        NBSHttpsURLConnectionExtension.this.addTransactionAndErrorData(nBSTransactionState);
                    }
                }
            });
        }
        return nBSCountingInputStream;
    }

    @Override
    public long getLastModified() {
        this.getTransactionState();
        long l2 = this.impl.getLastModified();
        this.checkResponse();
        return l2;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        NBSCountingOutputStream nBSCountingOutputStream;
        final NBSTransactionState nBSTransactionState = this.getTransactionState();
        try {
            nBSCountingOutputStream = new NBSCountingOutputStream(this.impl.getOutputStream());
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        if (nBSCountingOutputStream != null) {
            nBSCountingOutputStream.addStreamCompleteListener(new NBSStreamCompleteListener(){

                @Override
                public void streamError(NBSStreamCompleteEvent e2) {
                    if (!nBSTransactionState.isComplete()) {
                        nBSTransactionState.setBytesSent(e2.getBytes());
                    }
                    NBSHttpsURLConnectionExtension.this.error(e2.getException());
                }

                @Override
                public void streamComplete(NBSStreamCompleteEvent e2) {
                    if (!nBSTransactionState.isComplete()) {
                        String string = NBSHttpsURLConnectionExtension.this.impl.getRequestProperty("content-length");
                        long l2 = e2.getBytes();
                        if (string != null) {
                            try {
                                l2 = Long.parseLong(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        nBSTransactionState.setBytesSent(l2);
                    }
                }
            });
        }
        return nBSCountingOutputStream;
    }

    @Override
    public int getReadTimeout() {
        return this.impl.getReadTimeout();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.impl.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String field) {
        return this.impl.getRequestProperty(field);
    }

    @Override
    public URL getURL() {
        return this.impl.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this.impl.getUseCaches();
    }

    @Override
    public void setAllowUserInteraction(boolean newValue) {
        this.impl.setAllowUserInteraction(newValue);
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.impl.setConnectTimeout(timeoutMillis);
    }

    @Override
    public void setDefaultUseCaches(boolean newValue) {
        this.impl.setDefaultUseCaches(newValue);
    }

    @Override
    public void setDoInput(boolean newValue) {
        this.impl.setDoInput(newValue);
    }

    @Override
    public void setDoOutput(boolean newValue) {
        this.impl.setDoOutput(newValue);
    }

    @Override
    public void setIfModifiedSince(long newValue) {
        this.impl.setIfModifiedSince(newValue);
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        this.impl.setReadTimeout(timeoutMillis);
    }

    @Override
    public void setRequestProperty(String field, String newValue) {
        this.impl.setRequestProperty(field, newValue);
    }

    @Override
    public void setUseCaches(boolean newValue) {
        this.impl.setUseCaches(newValue);
    }

    @Override
    public String toString() {
        return this.impl.toString();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return this.impl.getPeerPrincipal();
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.impl.getLocalPrincipal();
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.impl.setHostnameVerifier(hostnameVerifier);
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.impl.getHostnameVerifier();
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory sf) {
        this.impl.setSSLSocketFactory(sf);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return this.impl.getSSLSocketFactory();
    }

    private void checkResponse() {
        if (!this.getTransactionState().isComplete()) {
            NBSTransactionStateUtil.inspectAndInstrumentResponse(this.getTransactionState(), this.impl);
        }
    }

    private NBSTransactionState getTransactionState() {
        if (this.transactionState == null) {
            this.transactionState = new NBSTransactionState();
            NBSTransactionStateUtil.setUrlAndCarrier(this.transactionState, this.impl);
        }
        return this.transactionState;
    }

    private void error(Exception e2) {
        n n2 = NBSAgent.getImpl();
        if (n2 == null) {
            return;
        }
        HarvestConfiguration harvestConfiguration = n2.q();
        if (harvestConfiguration == null) {
            return;
        }
        NBSTransactionState nBSTransactionState = this.getTransactionState();
        try {
            if (nBSTransactionState != null && !nBSTransactionState.hasParseUrlParams) {
                NBSTransactionStateUtil.processUrlParams(nBSTransactionState, this.impl);
            }
        }
        catch (Exception exception) {
            log.a("NBSTransactionStateUtil.processUrlParams occur an error", exception);
        }
        NBSTransactionStateUtil.setErrorCodeFromException(nBSTransactionState, e2);
        if (!al.b(nBSTransactionState.getUrl(), harvestConfiguration.getUrlFilterMode(), harvestConfiguration.getUrlRules())) {
            return;
        }
        if (!nBSTransactionState.isComplete()) {
            String string = "";
            if (nBSTransactionState.getException() != null) {
                string = nBSTransactionState.getException();
            }
            if (nBSTransactionState.isError() && al.a(nBSTransactionState.getUrl(), nBSTransactionState.getStatusCode(), harvestConfiguration.getIgnoreErrRules())) {
                nBSTransactionState.setStatusCode(200);
            }
            NBSTransactionStateUtil.inspectAndInstrumentResponse(nBSTransactionState, this.impl);
            b b2 = nBSTransactionState.end();
            ah.a(new a(b2.h(), b2.j(), b2.k(), b2.r(), b2.s(), b2.m(), b2.n(), b2.o(), b2.l(), b2.g(), b2.p(), b2.a(), b2.b(), b2.c(), b2.d(), b2.e()));
            if (nBSTransactionState.isError()) {
                j.a(nBSTransactionState.getUrl(), nBSTransactionState.getFormattedUrlParams(), nBSTransactionState.getUrlParams(), nBSTransactionState.getStatusCode(), string, nBSTransactionState.getRequestMethodType(), b2.b());
            }
        }
    }

    private void addTransactionAndErrorData(NBSTransactionState transactionState) {
        n n2 = NBSAgent.getImpl();
        if (n2 == null) {
            return;
        }
        HarvestConfiguration harvestConfiguration = n2.q();
        if (harvestConfiguration == null) {
            return;
        }
        b b2 = transactionState.end();
        if (b2 == null) {
            return;
        }
        if (!al.b(b2.h(), harvestConfiguration.getUrlFilterMode(), harvestConfiguration.getUrlRules())) {
            return;
        }
        int n3 = b2.j();
        if (n3 >= 400 && al.a(b2.h(), b2.j(), harvestConfiguration.getIgnoreErrRules())) {
            b2.a(200);
            b2.b(0);
            n3 = 200;
        }
        ah.a(new a(b2.h(), b2.j(), b2.k(), b2.r(), b2.s(), b2.m(), b2.n(), b2.o(), b2.l(), b2.g(), b2.p(), b2.a(), b2.b(), b2.c(), b2.d(), b2.e()));
        if ((long)n3 >= 400L) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                object = this.getErrorStream();
                if (object instanceof NBSCountingInputStream) {
                    stringBuilder.append(((NBSCountingInputStream)object).getBufferAsString());
                }
            }
            catch (Exception exception) {
                log.d(exception.toString());
            }
            if (this.impl.getHeaderFields() != null && this.impl.getHeaderFields().size() > 0) {
                object = new TreeMap();
                String string = this.impl.getContentType();
                if (string != null && !"".equals(string)) {
                    object.put("content_type", string);
                }
                object.put("content_length", "" + transactionState.getBytesReceived());
                String string2 = "";
                if (transactionState.getException() != null) {
                    string2 = transactionState.getException();
                }
                j.a(b2, stringBuilder.toString(), (Map<String, Object>)object, string2);
            } else {
                stringBuilder.append("no response");
            }
        }
    }
}

