/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import android.content.Context;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.networkbench.agent.impl.api.v2.ISystemTrace;
import com.networkbench.agent.impl.e.c;
import com.networkbench.agent.impl.e.d;
import com.networkbench.agent.impl.harvest.Harvest;
import com.networkbench.agent.impl.harvest.HarvestAdapter;
import com.networkbench.agent.impl.l.ah;
import com.networkbench.agent.impl.l.f;
import com.networkbench.agent.impl.l.x;
import com.networkbench.agent.impl.tracing.TraceLifecycleAware;
import com.networkbench.agent.impl.tracing.TraceType;
import com.networkbench.agent.impl.tracing.TracingInactiveException;
import com.networkbench.com.google.gson.JsonArray;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;

public class NBSEventTraceEngine
extends HarvestAdapter {
    public static final String NBS_TRACE_TYPE = "Lcom/networkbench/agent/impl/tracing/Trace;";
    private static final String TOUCH_ON = "Touch on ";
    private static final String RESOURCE_ID = "Resource Id: ";
    private static final String INITIATE = "Initiate ";
    private static final c log = d.a();
    private static final Collection<TraceLifecycleAware> traceListeners = new CopyOnWriteArrayList<TraceLifecycleAware>();
    private static ThreadLocal<com.networkbench.agent.impl.d.a.c> threadLocalTrace = new ThreadLocal();
    private static ThreadLocal<b> threadLocalTraceStack = new ThreadLocal();
    private static Method sh_menuItem_getTitle;
    private static NBSEventTraceEngine tracer;
    private static Context appContext;
    private static ISystemTrace systemTrace;
    private com.networkbench.agent.impl.d.a.a eventTrace;
    public static final String Clicked = "#Clicked";
    public static final String ItemClicked = "#ItemClicked";
    public static final String ItemSelected = "#ItemSelected";
    public static final String MenuItemClick = "#MenuItemClick";
    public static final String OptionsItemSelected = "#OptionsItemSelected";
    public static final String PageSelected = "#PageSelected";
    public static final String ONCREATE = "onCreate";
    public static final String ONSTART = "onStart";
    public static final String ONRESUME = "onResume";
    public static final String LIFECYCLE = "#LifeCycle";

    protected NBSEventTraceEngine(com.networkbench.agent.impl.d.a.c rootTrace) {
        this.eventTrace = new com.networkbench.agent.impl.d.a.a(rootTrace);
    }

    public static void addTraceListener(TraceLifecycleAware listener) {
        traceListeners.add(listener);
    }

    public static void removeTraceListener(TraceLifecycleAware listener) {
        traceListeners.remove(listener);
    }

    public static void setSystemTrace(ISystemTrace systemTrace) {
    }

    public static void startEventTrace(String name, a actionType) {
        NBSEventTraceEngine.startEventTrace(name, actionType, null);
    }

    public static void startEventTrace(String name, a actionType, String eventTraceIdText) {
        try {
            com.networkbench.agent.impl.d.a.c c2 = new com.networkbench.agent.impl.d.a.c();
            c2.i = name;
            c2.g = "MobileView/OpEvent/" + name;
            c2.c = System.currentTimeMillis();
            c2.j = actionType.h;
            c2.k = Harvest.currentActivityName;
            c2.o = eventTraceIdText;
            c2.p = name;
            log.c("eventV2: Started trace of " + name + ":" + c2.b.toString());
            com.networkbench.agent.impl.e.f.a("startEventTrace create rooteventV2: Started trace of " + name + ":" + c2.b.toString());
            threadLocalTrace.remove();
            threadLocalTraceStack.set(new b());
            c2.n = tracer = new NBSEventTraceEngine(c2);
            NBSEventTraceEngine.pushTraceContext(c2);
            for (TraceLifecycleAware traceLifecycleAware : traceListeners) {
            }
        }
        catch (Throwable throwable) {
            log.a("eventV2: Caught error while initializing Tracer, shutting it down", throwable);
            tracer = null;
            threadLocalTrace.remove();
            threadLocalTraceStack.remove();
        }
    }

    public static void endEventTrace(String name) {
        if (NBSEventTraceEngine.isTracingInactive() || NBSEventTraceEngine.tracer.eventTrace == null) {
            log.a("eventV2: endEventTrace : not active ");
            return;
        }
        threadLocalTrace.remove();
        threadLocalTraceStack.get().clear();
        NBSEventTraceEngine nBSEventTraceEngine = tracer;
        tracer = null;
        if (nBSEventTraceEngine.eventTrace.b.i.contains(name)) {
            nBSEventTraceEngine.eventTrace.c();
            log.a("eventV2: event trace duration : " + nBSEventTraceEngine.eventTrace.b.g());
            JsonArray jsonArray = nBSEventTraceEngine.eventTrace.asJsonArray();
            if (jsonArray == null) {
                log.a("eventV2: jsonArray == null");
                return;
            }
            if (nBSEventTraceEngine.eventTrace.b.g() >= (long)x.c().G()) {
                Harvest.addEventTraceV2(nBSEventTraceEngine.eventTrace);
            }
        } else {
            log.a("eventV2:endEventTrace not contains ->rootTrace.displayName:" + nBSEventTraceEngine.eventTrace.b.i + ",name:" + name);
        }
    }

    public static boolean isTracingActive() {
        return tracer != null;
    }

    public static boolean isTracingInactive() {
        return tracer == null;
    }

    public static String getCurrentScope() {
        try {
            if (NBSEventTraceEngine.isTracingInactive()) {
                return null;
            }
            if (systemTrace == null || systemTrace.isUIThread()) {
                return NBSEventTraceEngine.tracer.eventTrace.b.g;
            }
            return NBSEventTraceEngine.tracer.eventTrace.b.h;
        }
        catch (Throwable throwable) {
            log.a("Caught error while calling getCurrentScope()", throwable);
            return null;
        }
    }

    private static void loadTraceContext(com.networkbench.agent.impl.d.a.c trace) {
        if (NBSEventTraceEngine.isTracingInactive()) {
            return;
        }
        if (threadLocalTrace.get() == null) {
            threadLocalTrace.set(trace);
            threadLocalTraceStack.set(new b());
            if (trace == null) {
                return;
            }
            threadLocalTraceStack.get().push(trace);
        } else if (trace == null) {
            if (threadLocalTraceStack.get().isEmpty()) {
                threadLocalTrace.set(null);
                return;
            }
            trace = (com.networkbench.agent.impl.d.a.c)threadLocalTraceStack.get().peek();
            threadLocalTrace.set(trace);
        }
        log.c("eventV2: Trace " + trace.b.toString() + " is now active");
    }

    public static void enterMethod(String name) {
        NBSEventTraceEngine.enterMethod(null, name, null);
    }

    private static String charSeqToStr(CharSequence charSeq) {
        int n2 = 50;
        String string = null;
        if (charSeq != null && charSeq.length() > 0 && (string = charSeq.toString()).length() > n2) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public static String guessViewDesc(View view) {
        if (view == null) {
            return null;
        }
        String string = null;
        if (!(view instanceof LinearLayout)) {
            return null;
        }
        LinearLayout linearLayout = (LinearLayout)view;
        for (int i2 = 0; i2 < linearLayout.getChildCount(); ++i2) {
            string = NBSEventTraceEngine.getViewDesc(linearLayout.getChildAt(i2));
            if (string == null) continue;
            return string;
        }
        return string;
    }

    private static String getViewDesc(View view) {
        String string = null;
        if (view == null) {
            return string;
        }
        string = NBSEventTraceEngine.charSeqToStr(view.getContentDescription());
        if (string == null && view instanceof TextView) {
            string = NBSEventTraceEngine.charSeqToStr(((TextView)view).getText());
        }
        return string;
    }

    public static void enterMethod(String name, ArrayList<String> annotationParams) {
        NBSEventTraceEngine.enterMethod(null, name, annotationParams);
    }

    public static void onClickEventEnter(View view, Object owner) {
        String string = NBSEventTraceEngine.getShortClassName(owner);
        NBSEventTraceEngine.onUserAction(a.b, view, true, string);
    }

    private static void onUserAction(a actionType, View view, boolean enterListener, String ownerName) {
        if (enterListener) {
            String string;
            String string2;
            if (view != null) {
                string2 = NBSEventTraceEngine.getViewDesc(view);
                if (string2 == null) {
                    string2 = NBSEventTraceEngine.guessViewDesc(view);
                }
                if (string2 == null) {
                    string = NBSEventTraceEngine.getViewEntryNameOrID(view);
                    log.a("eventV2: entryNameOrID : " + string);
                    string2 = string == null ? TOUCH_ON + view.getClass().getSimpleName() : RESOURCE_ID + string;
                }
            } else {
                string2 = INITIATE + actionType.toString();
            }
            string = ownerName == null ? Harvest.currentActivityName + "#" + actionType.name() : ownerName + "#" + actionType.name();
            String string3 = NBSEventTraceEngine.guessViewInformation(view);
            Harvest.addActionAndInteraction("on" + actionType.name(), string2, string3);
            NBSEventTraceEngine.startEventTrace(string, actionType, string2);
        }
    }

    public static String guessViewInformation(View view) {
        if (view == null) {
            return null;
        }
        int n2 = view.getId();
        String string = "0x" + Integer.toHexString(n2);
        Object object = view.getTag();
        if (object != null) {
            return string + "#" + object.toString();
        }
        return string;
    }

    public static void onClickEventExit() {
        log.a("eventV2: onClickEventExit");
        NBSEventTraceEngine.endEventTrace(Clicked);
    }

    public static void onItemClickEnter(View view, int paramInt, Object owner) {
        String string = NBSEventTraceEngine.getShortClassName(owner);
        NBSEventTraceEngine.onUserAction(a.c, view, true, string);
    }

    public static void onItemClickExit() {
        NBSEventTraceEngine.endEventTrace(ItemClicked);
    }

    public static void onItemSelectedEnter(View view, int paramInt, Object owner) {
        String string = NBSEventTraceEngine.getShortClassName(owner);
        NBSEventTraceEngine.onUserAction(a.d, view, true, string);
    }

    public static void onItemSelectedExit() {
        NBSEventTraceEngine.endEventTrace(ItemSelected);
    }

    public static void onPageSelectedEnter(int paramInt, Object owner) {
        String string = NBSEventTraceEngine.getShortClassName(owner);
        NBSEventTraceEngine.onUserAction(a.g, null, true, string);
    }

    public static void onPageSelectedExit() {
        NBSEventTraceEngine.endEventTrace(PageSelected);
    }

    private static View getView(Object menuItem) {
        Object object;
        if (menuItem == null || appContext == null) {
            return null;
        }
        String string = null;
        if (menuItem instanceof MenuItem) {
            string = menuItem.toString();
        } else {
            try {
                if (sh_menuItem_getTitle == null) {
                    sh_menuItem_getTitle = menuItem.getClass().getMethod("getTitle", new Class[0]);
                }
                if (sh_menuItem_getTitle != null && (object = (CharSequence)sh_menuItem_getTitle.invoke(menuItem, (Object[])null)) != null) {
                    string = object.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            return null;
        }
        object = new View(appContext);
        object.setContentDescription((CharSequence)string);
        return object;
    }

    public static void onMenuItemClickEnter(Object paramObject, Object owner) {
        String string = NBSEventTraceEngine.getShortClassName(owner);
        NBSEventTraceEngine.onUserAction(a.c, NBSEventTraceEngine.getView(paramObject), true, string);
    }

    public static void onMenuItemClickExit() {
        NBSEventTraceEngine.endEventTrace(MenuItemClick);
    }

    public static void onOptionsItemSelectedEnter(Object paramObject, Object owner) {
        String string = NBSEventTraceEngine.getShortClassName(owner);
        NBSEventTraceEngine.onUserAction(a.c, NBSEventTraceEngine.getView(paramObject), true, string);
    }

    public static void onOptionsItemSelectedExit() {
        NBSEventTraceEngine.endEventTrace(OptionsItemSelected);
    }

    public static void enterMethod(com.networkbench.agent.impl.d.a.c trace, String name, ArrayList<String> annotationParams) {
        try {
            if (NBSEventTraceEngine.isTracingInactive()) {
                return;
            }
            long l2 = System.currentTimeMillis();
            long l3 = NBSEventTraceEngine.tracer.eventTrace.c;
            long l4 = NBSEventTraceEngine.tracer.eventTrace.d;
            NBSEventTraceEngine.loadTraceContext(trace);
            com.networkbench.agent.impl.d.a.c c2 = NBSEventTraceEngine.registerNewTrace(name);
            com.networkbench.agent.impl.e.f.a("NBSEventTraceEngine childTrace:" + c2.toString() + ",uuid :" + c2.b);
            NBSEventTraceEngine.pushTraceContext(c2);
            c2.q = NBSEventTraceEngine.getCurrentScope();
            c2.a(annotationParams);
            for (TraceLifecycleAware traceLifecycleAware : traceListeners) {
                traceLifecycleAware.onEnterMethod();
            }
            c2.c = System.currentTimeMillis();
        }
        catch (TracingInactiveException tracingInactiveException) {
            log.d("eventV2: tracing inactive!");
        }
        catch (Throwable throwable) {
            log.a("eventV2: Caught error while calling enterMethod()", throwable);
        }
    }

    private static com.networkbench.agent.impl.d.a.c registerNewTrace(String name) throws TracingInactiveException {
        if (NBSEventTraceEngine.isTracingInactive()) {
            log.e("eventV2 :Tried to register a new trace but tracing is inactive!");
            throw new TracingInactiveException();
        }
        com.networkbench.agent.impl.d.a.c c2 = NBSEventTraceEngine.getCurrentTrace();
        log.a("eventV2: parentTrace:" + c2.i);
        com.networkbench.agent.impl.d.a.c c3 = new com.networkbench.agent.impl.d.a.c(name, c2.b, tracer);
        c3.g = NBSEventTraceEngine.formatActivityMetricName(name);
        try {
            NBSEventTraceEngine.tracer.eventTrace.a(c3);
        }
        catch (Exception exception) {
            throw new TracingInactiveException();
        }
        c2.a(c3);
        return c3;
    }

    public static String formatActivityMetricName(String name) {
        return "MobileView/Activity/" + name;
    }

    public static String formatActivityBackgroundMetricName(String name) {
        return "MobileView/Background/" + name;
    }

    public static void exitMethod() {
        log.c("eventV2: exitMethod");
        try {
            if (NBSEventTraceEngine.isTracingInactive()) {
                return;
            }
            com.networkbench.agent.impl.d.a.c c2 = threadLocalTrace.get();
            if (c2 == null) {
                log.e("eventV2: threadLocalTrace is null");
                return;
            }
            c2.d = System.currentTimeMillis();
            if (c2.l == 0L && systemTrace != null) {
                c2.l = systemTrace.getCurrentThreadId();
                c2.m = systemTrace.getCurrentThreadName();
            }
            for (TraceLifecycleAware traceLifecycleAware : traceListeners) {
                traceLifecycleAware.onExitMethod();
            }
            com.networkbench.agent.impl.e.f.a("NBSEventTraceEngine exitMethod : add trace " + c2.toString());
            try {
                c2.e();
            }
            catch (TracingInactiveException tracingInactiveException) {
                threadLocalTrace.remove();
                threadLocalTraceStack.remove();
                if (c2.f() == TraceType.TRACE) {
                    ah.a(c2);
                }
                return;
            }
            threadLocalTraceStack.get().pop();
            if (threadLocalTraceStack.get().empty()) {
                threadLocalTrace.set(null);
            } else {
                com.networkbench.agent.impl.d.a.c c3 = (com.networkbench.agent.impl.d.a.c)threadLocalTraceStack.get().peek();
                threadLocalTrace.set(c3);
                c3.f += c2.g();
            }
            if (c2.f() == TraceType.TRACE) {
                ah.a(c2);
            }
        }
        catch (Throwable throwable) {
            log.a("eventV2: Caught error while calling exitMethod()", throwable);
        }
    }

    private static void pushTraceContext(com.networkbench.agent.impl.d.a.c trace) {
        if (NBSEventTraceEngine.isTracingInactive() || trace == null) {
            return;
        }
        b b2 = threadLocalTraceStack.get();
        if (b2.empty()) {
            b2.push(trace);
        } else if (b2.peek() != trace) {
            b2.push(trace);
        }
        threadLocalTrace.set(trace);
    }

    public static com.networkbench.agent.impl.d.a.c getCurrentTrace() throws TracingInactiveException {
        if (NBSEventTraceEngine.isTracingInactive()) {
            throw new TracingInactiveException();
        }
        com.networkbench.agent.impl.d.a.c c2 = threadLocalTrace.get();
        if (c2 != null) {
            return c2;
        }
        return NBSEventTraceEngine.getRootTrace();
    }

    public static Map<String, Object> getCurrentTraceParams() throws TracingInactiveException {
        return NBSEventTraceEngine.getCurrentTrace().b();
    }

    public static void setCurrentTraceParam(String key, Object value) {
        try {
            com.networkbench.agent.impl.d.a.c c2 = NBSEventTraceEngine.getCurrentTrace();
            if (value != null) {
                NBSEventTraceEngine.getCurrentTrace().b().put(key, value);
            }
        }
        catch (TracingInactiveException tracingInactiveException) {
            // empty catch block
        }
    }

    public static void setCurrentDisplayName(String name) {
        try {
            NBSEventTraceEngine.getCurrentTrace().i = name;
        }
        catch (TracingInactiveException tracingInactiveException) {
            // empty catch block
        }
    }

    public void storeCompletedTrace(com.networkbench.agent.impl.d.a.c trace) {
        f.b(trace.toString());
        try {
            if (NBSEventTraceEngine.isTracingInactive()) {
                return;
            }
            this.eventTrace.b(trace);
        }
        catch (Throwable throwable) {
            log.a("eventV2: Caught error while calling storeCompletedTrace()", throwable);
        }
    }

    public static com.networkbench.agent.impl.d.a.c getRootTrace() throws TracingInactiveException {
        try {
            return NBSEventTraceEngine.tracer.eventTrace.b;
        }
        catch (NullPointerException nullPointerException) {
            throw new TracingInactiveException();
        }
    }

    @Override
    public void onHarvestBefore() {
    }

    @Override
    public void onHarvestSendFailed() {
    }

    public static void onCreateEvent(String activityName) {
        Harvest.currentActivityName = activityName;
        String string = activityName + LIFECYCLE;
        NBSEventTraceEngine.startEventTrace(string, a.a);
        com.networkbench.agent.impl.e.f.a("onCreateEvent");
        NBSEventTraceEngine.enterMethod(ONCREATE);
    }

    public static void onStartEvent(String activityName) {
        NBSEventTraceEngine.exitMethod();
        com.networkbench.agent.impl.e.f.a("onStartEvent");
        NBSEventTraceEngine.enterMethod(ONSTART);
    }

    public static void onPostCreateEvent(String activityName) {
        Harvest.currentActivityName = activityName;
        NBSEventTraceEngine.exitMethod();
        com.networkbench.agent.impl.e.f.a("onPostCreateEvent");
        NBSEventTraceEngine.enterMethod(ONRESUME);
    }

    public static void onPostResumeEvent(String activityName) {
        NBSEventTraceEngine.exitMethod();
        String string = activityName + LIFECYCLE;
        com.networkbench.agent.impl.e.f.a("onPostResumeEvent");
        NBSEventTraceEngine.endEventTrace(string);
    }

    public static String getShortClassName(Object owner) {
        if (owner == null) {
            return null;
        }
        String string = owner.getClass().getName();
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(".");
        if (n2 < 1) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    public static void onItemClickExit(View view, int paramInt) {
        NBSEventTraceEngine.endEventTrace(ItemClicked);
    }

    public static void onItemSelectedExit(View view, int paramInt) {
        NBSEventTraceEngine.endEventTrace(ItemSelected);
    }

    public static void onPageSelectedExit(int paramInt) {
        NBSEventTraceEngine.endEventTrace(PageSelected);
    }

    public static void onMenuItemClickExit(Object paramObject) {
        NBSEventTraceEngine.endEventTrace(MenuItemClick);
    }

    public static void onOptionsItemSelectedExit(Object paramObject) {
        NBSEventTraceEngine.endEventTrace(OptionsItemSelected);
    }

    @Deprecated
    void a() {
    }

    private static String getViewEntryNameOrID(View view) {
        if (view == null) {
            return null;
        }
        try {
            Object object;
            int n2 = view.getId();
            Context context = x.c().p();
            String string = null;
            if (context != null) {
                object = context.getResources();
                string = object.getResourceEntryName(n2);
            }
            if (!TextUtils.isEmpty(string)) {
                return string;
            }
            object = Integer.toHexString(n2);
            if (TextUtils.isEmpty((CharSequence)object)) {
                return "0x" + (String)object;
            }
        }
        catch (Exception exception) {
            log.a("getViewEntryName() occur an error", exception);
        }
        return null;
    }

    private static class b
    extends Stack<com.networkbench.agent.impl.d.a.c> {
        private b() {
        }
    }

    static enum a {
        a(0),
        b(1),
        c(2),
        d(3),
        e(4),
        f(5),
        g(6);

        public final int h;

        private a(int n3) {
            this.h = n3;
        }
    }
}

