/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.util.TypedValue;
import com.networkbench.agent.impl.harvest.type.MetricCategory;
import com.networkbench.agent.impl.instrumentation.NBSReplaceCallSite;
import com.networkbench.agent.impl.instrumentation.NBSTraceEngine;
import com.networkbench.agent.impl.l.am;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class NBSBitmapFactoryInstrumentation {
    private static final ArrayList<String> categoryParams = new ArrayList<String>(Arrays.asList("category", MetricCategory.class.getName(), "IMAGE"));

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeFile(String pathName, BitmapFactory.Options opts) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeFile", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeFile(String pathName) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeFile", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeFile((String)pathName);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, BitmapFactory.Options opts) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeResourceStream", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)opts);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeResource(Resources res, int id, BitmapFactory.Options opts) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeResource", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)opts);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeResource(Resources res, int id) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeResource", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)id);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeByteArray", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)opts);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeByteArray", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeStream", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)opts);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeStream(InputStream is) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeStream", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, BitmapFactory.Options opts) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeFileDescriptor", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)opts);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @NBSReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeFileDescriptor(FileDescriptor fd) {
        NBSTraceEngine.enterMethod(am.b() + "BitmapFactory#decodeFileDescriptor", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd);
        NBSTraceEngine.exitMethod();
        return bitmap;
    }

    @Deprecated
    void a() {
    }
}

