/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.harvest;

import com.networkbench.agent.impl.a.d;
import com.networkbench.agent.impl.b.f;
import com.networkbench.agent.impl.c.k;
import com.networkbench.agent.impl.c.l;
import com.networkbench.agent.impl.e.c;
import com.networkbench.agent.impl.harvest.ActionData;
import com.networkbench.agent.impl.harvest.ActionDatas;
import com.networkbench.agent.impl.harvest.ConnectInformation;
import com.networkbench.agent.impl.harvest.Harvest;
import com.networkbench.agent.impl.harvest.HarvestConfiguration;
import com.networkbench.agent.impl.harvest.HarvestConnection;
import com.networkbench.agent.impl.harvest.HarvestData;
import com.networkbench.agent.impl.harvest.HarvestLifecycleAware;
import com.networkbench.agent.impl.harvest.HarvestResponse;
import com.networkbench.agent.impl.harvest.InitMobileAppResult;
import com.networkbench.agent.impl.harvest.NetworkPerfMetrics;
import com.networkbench.agent.impl.instrumentation.NetworkLibInit;
import com.networkbench.agent.impl.l.ah;
import com.networkbench.agent.impl.l.x;
import com.networkbench.agent.impl.l.z;
import com.networkbench.agent.impl.tracing.ActivityTrace;
import com.networkbench.agent.impl.tracing.ActivityTraces;
import com.networkbench.com.google.gson.Gson;
import com.networkbench.com.google.gson.GsonBuilder;
import com.networkbench.com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class Harvester {
    private final c log = com.networkbench.agent.impl.e.d.a();
    private boolean getNewConfiguration = false;
    private State state = State.UNINITIALIZED;
    protected boolean a;
    private HarvestConnection harvestConnection;
    private HarvestConfiguration configuration = HarvestConfiguration.getDefaultHarvestConfiguration();
    private HarvestData harvestData;
    private static boolean IslibInit = false;
    private final Collection<HarvestLifecycleAware> harvestListeners = new ArrayList<HarvestLifecycleAware>();

    public void start() {
        this.fireOnHarvestStart();
    }

    public void stop() {
        this.fireOnHarvestStop();
    }

    protected void a() {
        ConnectInformation connectInformation = new ConnectInformation();
        this.harvestConnection.setConnectInformation(connectInformation);
        this.harvestConnection.setApplicationToken(x.c().q());
        this.harvestConnection.setLicenseKey(x.c().g());
        this.harvestConnection.useSsl(x.c().w());
        this.a(State.DISCONNECTED);
        this.f();
    }

    protected void b() {
        HarvestResponse harvestResponse = this.harvestConnection.getRedirectHost();
        if (harvestResponse == null) {
            this.log.d("Unable to connect to the Redirect.");
            return;
        }
        if (harvestResponse.isOK()) {
            String string = harvestResponse.getResultMessage();
            z.b = x.c().w() ? "https://" + string : "http://" + string;
            this.harvestConnection.setCollectorHost(string);
            this.a(State.REDIRECTED);
            this.f();
            return;
        }
    }

    protected void c() {
        if (this.harvestConnection.getApplicationToken() != null && this.harvestConnection.getApplicationToken().length() > 0 && !this.getNewConfiguration) {
            this.log.c("Skipping connect call, saved state is available: " + this.harvestConnection.getApplicationToken());
            this.fireOnHarvestConnected();
            this.a(State.CONNECTED);
            return;
        }
        HarvestResponse harvestResponse = this.harvestConnection.sendConnect();
        if (harvestResponse == null) {
            this.log.d("Unable to connect to the Collector.");
            return;
        }
        HarvestConfiguration harvestConfiguration = harvestResponse.getConfiguration();
        if (harvestConfiguration == null) {
            this.log.d("Unable to configure Harvester using Collector configuration.");
            this.log.d("errorCode is:" + harvestResponse.getErrorCode().a);
            switch (harvestResponse.getErrorCode().a) {
                case 460: {
                    this.log.b("errorCode:460, Invalid key(" + x.c().g() + ")");
                    this.fireOnHarvestDisabled();
                    this.a(State.DISABLED);
                    return;
                }
                case 461: {
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    return;
                }
                case 463: {
                    this.log.b("errorCode:463, Invalid device id(did).");
                    this.fireOnHarvestDeviceIdError();
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    return;
                }
                case 470: {
                    this.log.b("errorCode:470,Configuration has been overdue.");
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    break;
                }
                default: {
                    this.log.b("An unknown error occurred when sent data to the Collector.");
                }
            }
            return;
        }
        this.harvestConnection.setApplicationToken(harvestConfiguration.getToken());
        if (harvestConfiguration.getEnabled() != 1) {
            this.log.b("NBSAgent disabled");
            com.networkbench.agent.impl.b.d.a = false;
            this.a(State.DISABLED);
            return;
        }
        this.configureHarvester(harvestConfiguration);
        x.c().a(TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
        x.c().d(harvestConfiguration.getToken());
        x.c().b(harvestConfiguration.getCrashTrails());
        Harvest.getInstance().initCrashActions();
        if (!IslibInit && harvestConfiguration.getHttp_network_enabled() && harvestConfiguration.getSocketData_enable()) {
            this.log.a("start to init nbsdc-jni.so.");
            this.initNbsdcJni();
            IslibInit = true;
        } else if (!IslibInit) {
            this.log.a("socket is close, can not init nbsdc-jni.so!");
        }
        this.fireOnHarvestConnected();
        this.getNewConfiguration = false;
        this.a(State.CONNECTED);
        this.f();
    }

    private void initNbsdcJni() {
        try {
            NetworkLibInit networkLibInit = new NetworkLibInit();
            int n2 = networkLibInit.setHook(this.getIsArtInUse());
            if (n2 < 0) {
                this.log.a("network lib init failed!");
            } else {
                this.log.a("network lib init successed!");
            }
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.log.d("load so file failed! e = " + exceptionInInitializerError.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.log.d("load so file failed! e = " + unsatisfiedLinkError.getMessage());
        }
        catch (Throwable throwable) {
            this.log.d("load so file failed! e = " + throwable.getMessage());
        }
    }

    private boolean getIsArtInUse() {
        String string = System.getProperty("java.vm.version");
        return string != null && string.startsWith("2");
    }

    protected void d() {
        this.sendNetworkPrefMetricsAndWebviewPrefMetrics();
        this.sendUIPerfMeticsAndEventTraceV2();
        this.sendActivityTraces();
        this.fireOnHarvestComplete();
    }

    private void sendNetworkPrefMetricsAndWebviewPrefMetrics() {
        if (!Harvest.isHttp_network_enabled()) {
            return;
        }
        if (Harvest.isSocketData_enabled()) {
            ah.a();
        }
        NetworkPerfMetrics networkPerfMetrics = this.harvestData.getNetworkPerfMetrics();
        int n2 = networkPerfMetrics.getActionDatas().count();
        x.c += n2;
        HarvestResponse harvestResponse = null;
        harvestResponse = this.canSendWebviewPrefMetrics() ? this.harvestConnection.sendData(this.harvestData.getNetworkPerfMetrics(), this.harvestData.getWebViewPerfMetrics()) : this.harvestConnection.sendData(this.harvestData.getNetworkPerfMetrics());
        if (harvestResponse == null || harvestResponse.isUnknown()) {
            this.fireOnHarvestSendFailed();
            return;
        }
        if (harvestResponse.isError()) {
            this.fireOnHarvestError();
            switch (harvestResponse.getErrorCode().a) {
                case 403: 
                case 460: {
                    this.log.d("NBSAgent Disabled!");
                    this.fireOnHarvestDisabled();
                    this.a(State.DISABLED);
                    return;
                }
                case 461: {
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    return;
                }
                case 463: {
                    this.log.d("Invalid device id(did).");
                    this.fireOnHarvestDeviceIdError();
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    return;
                }
                case 470: {
                    this.log.d("Configuration has been overdue.");
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    break;
                }
                default: {
                    this.log.d("An unknown error occurred when sent data to the Collector.");
                }
            }
            return;
        }
        this.harvestData.getNetworkPerfMetrics().reset();
        this.harvestData.getWebViewPerfMetrics().b();
        this.harvestData.getSocketDatas().d();
    }

    private void removeSocketData() {
        this.harvestData.getSocketDatas().a();
        Collection<ActionData> collection = this.harvestData.getActionDatas().getActionDatas();
        for (ActionData actionData : collection) {
            actionData.setTime_to_connect(-1);
            actionData.setTime_to_dns(-1);
            actionData.setTime_ssl_handshake(-1);
            actionData.setIP("");
        }
    }

    private void sendUIPerfMeticsAndEventTraceV2() {
        if (!Harvest.isUI_enabled()) {
            return;
        }
        HarvestResponse harvestResponse = this.harvestConnection.sendData(this.harvestData.getUiPerfMetrics(), this.harvestData.getEventTraces());
        if (harvestResponse == null || harvestResponse.isUnknown()) {
            this.fireOnHarvestSendFailed();
            return;
        }
        if (harvestResponse.isError()) {
            this.fireOnHarvestError();
            switch (harvestResponse.getErrorCode().a) {
                case 403: 
                case 460: {
                    this.log.d("NBSAgent Disabled!");
                    this.fireOnHarvestDisabled();
                    this.a(State.DISABLED);
                    return;
                }
                case 461: {
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    return;
                }
                case 463: {
                    this.log.d("Invalid device id(did).");
                    this.fireOnHarvestDeviceIdError();
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    return;
                }
                case 470: {
                    this.log.d("Configuration has been overdue.");
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    break;
                }
                default: {
                    this.log.d("An unknown error occurred when sent data to the Collector.");
                }
            }
            return;
        }
        this.harvestData.getUiPerfMetrics().reset();
        this.harvestData.getEventTraces().a();
    }

    private void sendActivityTraces() {
        if (!Harvest.isUI_enabled()) {
            return;
        }
        HarvestResponse harvestResponse = this.harvestConnection.sendData(this.harvestData.getActivityTraces());
        if (harvestResponse == null || harvestResponse.isUnknown()) {
            this.fireOnHarvestSendFailed();
            return;
        }
        if (harvestResponse.isError()) {
            this.fireOnHarvestError();
            switch (harvestResponse.getErrorCode().a) {
                case 403: 
                case 460: {
                    this.log.d("NBSAgent Disabled!");
                    this.fireOnHarvestDisabled();
                    this.a(State.DISABLED);
                    return;
                }
                case 461: {
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    return;
                }
                case 463: {
                    this.log.d("Invalid device id(did).");
                    this.fireOnHarvestDeviceIdError();
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    return;
                }
                case 470: {
                    this.log.d("Configuration has been overdue.");
                    this.a(State.REDIRECTED);
                    this.getNewConfiguration = true;
                    break;
                }
                default: {
                    this.log.d("An unknown error occurred when sent data to the Collector.");
                }
            }
            this.harvestData.getActivityTraces().reset();
            return;
        }
        this.harvestData.getActivityTraces().reset();
    }

    protected void e() {
        Harvest.stop();
        this.fireOnHarvestDisabled();
    }

    protected void f() {
        this.a = false;
        try {
            this.expireHarvestData();
            switch (this.state.ordinal()) {
                case 0: {
                    this.a();
                    break;
                }
                case 1: {
                    this.b();
                    break;
                }
                case 2: {
                    this.fireOnHarvestBefore();
                    this.c();
                    break;
                }
                case 3: {
                    this.fireOnHarvestBefore();
                    this.fireOnHarvest();
                    this.fireOnHarvestFinalize();
                    ah.c();
                    this.d();
                    break;
                }
                case 4: {
                    this.e();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void a(State state) {
        if (this.a) {
            this.log.e("Ignoring multiple transition: " + (Object)((Object)state));
            return;
        }
        if (this.state == state) {
            return;
        }
        switch (this.state.ordinal()) {
            case 0: {
                if (this.stateIn(state, State.DISCONNECTED, State.REDIRECTED, state, State.CONNECTED, State.DISABLED)) break;
                throw new IllegalStateException();
            }
            case 1: {
                if (this.stateIn(state, State.UNINITIALIZED, State.REDIRECTED, State.CONNECTED, State.DISABLED)) break;
                throw new IllegalStateException();
            }
            case 2: {
                if (this.stateIn(state, State.UNINITIALIZED, State.DISCONNECTED, State.CONNECTED, State.DISABLED)) break;
                throw new IllegalStateException();
            }
            case 3: {
                if (this.stateIn(state, State.DISCONNECTED, State.REDIRECTED, State.DISABLED)) break;
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.changeState(state);
    }

    private HarvestConfiguration parseHarvesterConfiguration(HarvestResponse response) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        HarvestConfiguration harvestConfiguration = null;
        try {
            InitMobileAppResult initMobileAppResult = gson.fromJson(response.getResultMessage(), InitMobileAppResult.class);
            harvestConfiguration = initMobileAppResult.getCfg();
            harvestConfiguration.setDeviceId(initMobileAppResult.getDid());
            harvestConfiguration.setToken(initMobileAppResult.getToken());
            this.harvestConnection.setApplicationToken(initMobileAppResult.getToken());
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            this.log.d("Unable to parse collector configuration: " + jsonSyntaxException.getMessage());
        }
        return harvestConfiguration;
    }

    private void configureHarvester(HarvestConfiguration harvestConfiguration) {
        this.configuration.reconfigure(harvestConfiguration);
        Harvest.setHarvestConfiguration(this.configuration);
    }

    private void changeState(State newState) {
        if (newState == State.CONNECTED) {
            this.log.b("connect success");
            f.a().b();
            d.a().b();
        }
        if (this.state == State.CONNECTED) {
            if (newState == State.REDIRECTED) {
                this.fireOnHarvestDisconnected();
            } else if (newState == State.DISABLED) {
                this.fireOnHarvestDisabled();
            }
        }
        this.state = newState;
        this.a = true;
    }

    private boolean stateIn(State testState, State ... legalStates) {
        for (State state : legalStates) {
            if (testState != state) continue;
            return true;
        }
        return false;
    }

    public State getCurrentState() {
        return this.state;
    }

    public boolean isDisabled() {
        return State.DISABLED == this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHarvestListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            this.log.d("Can't add null harvest listener");
            new Exception().printStackTrace();
            return;
        }
        Collection<HarvestLifecycleAware> collection = this.harvestListeners;
        synchronized (collection) {
            if (this.harvestListeners.contains(harvestAware)) {
                return;
            }
            this.harvestListeners.add(harvestAware);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHarvestListener(HarvestLifecycleAware harvestAware) {
        Collection<HarvestLifecycleAware> collection = this.harvestListeners;
        synchronized (collection) {
            if (!this.harvestListeners.contains(harvestAware)) {
                return;
            }
            this.harvestListeners.remove(harvestAware);
        }
    }

    public void expireHarvestData() {
        this.expireHttpErrors();
        this.expireHttpTransactions();
        this.expireActivityTraces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireHttpErrors() {
        l l2;
        l l3 = l2 = this.harvestData.getHttpErrors();
        synchronized (l3) {
            ArrayList<k> arrayList = new ArrayList<k>();
            long l4 = System.currentTimeMillis();
            long l5 = TimeUnit.MILLISECONDS.convert(this.configuration.getActionAge(), TimeUnit.SECONDS);
            for (k k2 : l2.b()) {
                if (k2.l() >= l4 - l5) continue;
                arrayList.add(k2);
            }
            for (k k2 : arrayList) {
                l2.b(k2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireHttpTransactions() {
        ActionDatas actionDatas;
        ActionDatas actionDatas2 = actionDatas = this.harvestData.getActionDatas();
        synchronized (actionDatas2) {
            ArrayList<ActionData> arrayList = new ArrayList<ActionData>();
            long l2 = System.currentTimeMillis();
            long l3 = TimeUnit.MILLISECONDS.convert(this.configuration.getActionAge(), TimeUnit.SECONDS);
            for (ActionData actionData : actionDatas.getActionDatas()) {
                if (actionData.getTimestamp() >= l2 - l3) continue;
                arrayList.add(actionData);
            }
            for (ActionData actionData : arrayList) {
                actionDatas.remove(actionData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireActivityTraces() {
        ActivityTraces activityTraces;
        ActivityTraces activityTraces2 = activityTraces = this.harvestData.getActivityTraces();
        synchronized (activityTraces2) {
            ArrayList<ActivityTrace> arrayList = new ArrayList<ActivityTrace>();
            long l2 = this.configuration.getUiTraceRetries();
            for (ActivityTrace activityTrace : activityTraces.getActivityTraces()) {
                if (activityTrace.getReportAttemptCount() < l2) continue;
                arrayList.add(activityTrace);
            }
            for (ActivityTrace activityTrace : arrayList) {
                activityTraces.remove(activityTrace);
            }
        }
    }

    public void setHarvestConnection(HarvestConnection connection) {
        this.harvestConnection = connection;
    }

    public HarvestConnection getHarvestConnection() {
        return this.harvestConnection;
    }

    public void setHarvestData(HarvestData harvestData) {
        this.harvestData = harvestData;
    }

    private void fireOnHarvestBefore() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestBefore();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvestStart() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestStart();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvestStop() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestStop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvest() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvest();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvestFinalize() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestFinalize();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvestDisabled() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestDisabled();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvestDisconnected() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestDisconnected();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvestError() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestError();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvestSendFailed() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestSendFailed();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvestComplete() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestComplete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvestConnected() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestConnected();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireOnHarvestDeviceIdError() {
        try {
            for (HarvestLifecycleAware harvestLifecycleAware : this.getHarvestListeners()) {
                harvestLifecycleAware.onHarvestDeviceIdError();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setConfiguration(HarvestConfiguration configuration) {
        this.configuration = configuration;
    }

    private Collection<HarvestLifecycleAware> getHarvestListeners() {
        return new ArrayList<HarvestLifecycleAware>(this.harvestListeners);
    }

    private boolean canSendWebviewPrefMetrics() {
        int n2;
        if (!Harvest.isWebView_enabled()) {
            return false;
        }
        int n3 = this.harvestData.getWebViewTransactions().c();
        if (n3 + (n2 = this.harvestData.getJsErrors().c()) < 1) {
            this.log.e("stop send webviewPrefMetrics because no data");
            return false;
        }
        return true;
    }

    protected static enum State {
        UNINITIALIZED,
        DISCONNECTED,
        REDIRECTED,
        CONNECTED,
        DISABLED;

    }
}

