/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.harvest;

import com.networkbench.agent.impl.harvest.type.Harvestable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class HarvestableCache {
    private static final int DEFAULT_CACHE_LIMIT = 1024;
    private int limit = 1024;
    private final Collection<Harvestable> cache = new ArrayList<Harvestable>();

    public void add(Harvestable harvestable) {
        if (harvestable == null || this.cache.size() >= this.limit) {
            return;
        }
        this.cache.add(harvestable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Harvestable> flush() {
        if (this.cache.size() == 0) {
            return Collections.emptyList();
        }
        HarvestableCache harvestableCache = this;
        synchronized (harvestableCache) {
            ArrayList<Harvestable> arrayList = new ArrayList<Harvestable>(this.cache);
            this.cache.clear();
            return arrayList;
        }
    }

    public int getSize() {
        return this.cache.size();
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

