/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.harvest;

import com.networkbench.agent.impl.e.c;
import com.networkbench.agent.impl.e.d;
import com.networkbench.agent.impl.harvest.Harvester;
import com.networkbench.agent.impl.k.b;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class HarvestTimer
implements Runnable {
    private static final long DEFAULT_HARVEST_PERIOD = 60000L;
    private static final long HARVEST_PERIOD_LEEWAY = 1000L;
    private static final long NEVER_TICKED = -1L;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final c log = d.a();
    private ScheduledFuture<?> tickFuture;
    private long period = 60000L;
    protected final Harvester a;
    protected long b;
    private long startTimeMs;

    public HarvestTimer(Harvester harvester) {
        this.a = harvester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HarvestTimer harvestTimer = this;
        synchronized (harvestTimer) {
            try {
                this.tickIfReady();
            }
            catch (Exception exception) {
                this.log.d("HarvestTimer: Exception in timer tick: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void tickIfReady() {
        long l2 = this.timeSinceLastTick();
        if (l2 + 1000L < this.period && l2 != -1L) {
            return;
        }
        long l3 = this.now();
        try {
            this.a();
        }
        catch (Exception exception) {
            this.log.d("HarvestTimer: Exception in timer tick: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.b = l3;
    }

    protected void a() {
        b b2 = new b();
        b2.a();
        try {
            this.a.f();
        }
        catch (Exception exception) {
            this.log.d("HarvestTimer: Exception in harvest execute: " + exception.getMessage());
            exception.printStackTrace();
        }
        if (this.a.isDisabled()) {
            this.stop();
        }
        long l2 = b2.b();
    }

    public void start() {
        if (this.isRunning()) {
            this.log.e("HarvestTimer: Attempting to start while already running");
            return;
        }
        if (this.period <= 0L) {
            this.log.d("HarvestTimer: Refusing to start with a period of 0 ms");
            return;
        }
        this.startTimeMs = System.currentTimeMillis();
        this.tickFuture = this.scheduler.scheduleAtFixedRate(this, 0L, this.period, TimeUnit.MILLISECONDS);
        this.a.start();
    }

    public void stop() {
        if (!this.isRunning()) {
            this.log.e("HarvestTimer: Attempting to stop when not running");
            return;
        }
        this.startTimeMs = 0L;
        this.a.stop();
        this.tickFuture.cancel(true);
        this.tickFuture = null;
    }

    public void tickNow() {
        final HarvestTimer harvestTimer = this;
        ScheduledFuture<?> scheduledFuture = this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                harvestTimer.a();
            }
        }, 0L, TimeUnit.SECONDS);
        try {
            long l2 = System.currentTimeMillis();
            scheduledFuture.get(4L, TimeUnit.SECONDS);
            long l3 = System.currentTimeMillis();
            this.log.e("tickNow cost " + (l3 - l2) + " milliseconds. ");
        }
        catch (Exception exception) {
            this.log.d("Exception waiting for tickNow to finish: " + exception.getMessage());
        }
    }

    public boolean isRunning() {
        return this.tickFuture != null;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long timeSinceLastTick() {
        if (this.b == 0L) {
            return -1L;
        }
        return this.now() - this.b;
    }

    public long timeSinceStart() {
        if (this.startTimeMs == 0L) {
            return 0L;
        }
        return this.now() - this.startTimeMs;
    }

    private long now() {
        return System.currentTimeMillis();
    }
}

