/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.harvest;

import com.networkbench.agent.impl.harvest.HarvestConfiguration;

public class HarvestResponse {
    private int statusCode;
    private String status;
    private int errorCode;
    private String resultMessage;
    private long responseTime;
    private String responseBody;
    private HarvestConfiguration configuration;

    public Code getResponseCode() {
        if (this.isOK()) {
            return Code.OK;
        }
        for (Code code : Code.values()) {
            if (code.getStatusCode() != this.statusCode) continue;
            return code;
        }
        return Code.UNKNOWN;
    }

    public boolean isError() {
        return "error".equals(this.status) && this.errorCode > 0;
    }

    public boolean isUnknown() {
        return this.getResponseCode() == Code.UNKNOWN;
    }

    public boolean isOK() {
        return !this.isError();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Code getErrorCode() {
        if (this.isOK()) {
            return Code.OK;
        }
        for (Code code : Code.values()) {
            if (code.getStatusCode() != this.errorCode) continue;
            return code;
        }
        return Code.UNKNOWN;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if ("error".equals(this.status)) {
            stringBuilder.append("{").append("errorCode=").append(this.errorCode).append(", message=").append(this.resultMessage).append("}");
        } else {
            stringBuilder.append("{code=").append((Object)this.getResponseCode()).append("}");
        }
        return stringBuilder.toString();
    }

    public HarvestConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HarvestConfiguration configuration) {
        this.configuration = configuration;
    }

    public static enum Code {
        OK(200),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        ENTITY_TOO_LARGE(413),
        UNSUPPORTED_MEDIA_TYPE(415),
        INVALID_AGENT_ID(450),
        INVALID_LICENSE(460),
        INVALID_DATA_TOKEN(461),
        INVALID_DATA(462),
        INVALID_DEVICE_ID(463),
        EXPIRE_CONFIGURATION(470),
        INTERNAL_SERVER_ERROR(500),
        UNKNOWN(-1);

        int a;

        private Code(int statusCode) {
            this.a = statusCode;
        }

        public int getStatusCode() {
            return this.a;
        }

        public boolean isError() {
            return this != OK;
        }

        public boolean isOK() {
            return !this.isError();
        }
    }
}

