/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.harvest;

import com.networkbench.agent.impl.c.s;
import com.networkbench.agent.impl.e.c;
import com.networkbench.agent.impl.e.d;
import com.networkbench.agent.impl.l.x;
import java.util.ArrayList;
import java.util.Iterator;

public class HarvestConfiguration {
    private static c log = d.a();
    private String token;
    private String deviceId;
    private long interval;
    private int intervalOnIdle;
    private int actions;
    private int actionAge;
    private boolean enableErrTrace;
    private int errs;
    private int errRspSize;
    private int stackDepth;
    private boolean dnsconn;
    private int urlFilterMode;
    private ArrayList<s.b> urlRules;
    private ArrayList<s.a> ignoreErrRules;
    private ArrayList<s.c> urlParamArray = null;
    private int slowInteractionThreshold;
    private float uiTraceThreshold;
    private float uiTraceMaxTime = 100000.0f;
    private int uiTraceSize;
    private int uiTraceRetries;
    private int uiTraces;
    private int enabled;
    private static HarvestConfiguration defaultHarvestConfiguration;
    private int crashTrails;
    private boolean http_network_enabled = true;
    private boolean ui_enabled = true;
    private boolean crash_enabled = true;
    private boolean webview_enabled = true;
    private boolean socketdata_enabled = true;
    private boolean cross_app_enable = true;
    public static final int HTTP_NETWORK_ENABLED = 1;
    public static final int UI_ENABLED = 2;
    public static final int CRASH_ENABLED = 4;
    public static final int WEBVIEW_ENABLED = 8;
    public static final int SOCKET_DATA_ENABLE = 16;
    public static final int CROSS_APP_ENABLE = 32;
    private int betaonFlag;
    private String tyId;

    public ArrayList<s.c> getUrlParamArray() {
        if (this.urlParamArray == null) {
            // empty if block
        }
        return this.urlParamArray;
    }

    public void setUrlParamArray(ArrayList<s.c> urlParamArray) {
        this.urlParamArray = urlParamArray;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }

    public HarvestConfiguration() {
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.interval = 60L;
        this.intervalOnIdle = 20;
        this.actions = 1000;
        this.actionAge = 600;
        this.enableErrTrace = true;
        this.errs = 100;
        this.errRspSize = 2048;
        this.stackDepth = 10;
        this.dnsconn = false;
        this.urlFilterMode = 0;
        this.urlRules = new ArrayList();
        this.ignoreErrRules = new ArrayList();
        this.uiTraceThreshold = 300.0f;
        this.uiTraces = 1;
        this.uiTraceSize = 65534;
        this.uiTraceRetries = 1;
        this.crashTrails = 20;
        this.http_network_enabled = true;
        this.ui_enabled = true;
        this.crash_enabled = true;
        this.webview_enabled = true;
        this.socketdata_enabled = true;
        this.betaonFlag = 1;
    }

    public static HarvestConfiguration getDefaultHarvestConfiguration() {
        if (defaultHarvestConfiguration != null) {
            return defaultHarvestConfiguration;
        }
        defaultHarvestConfiguration = new HarvestConfiguration();
        return defaultHarvestConfiguration;
    }

    public void reconfigure(HarvestConfiguration configuration) {
        this.deviceId = configuration.getDeviceId();
        this.token = configuration.getToken();
        this.interval = configuration.getInterval();
        this.intervalOnIdle = configuration.getIntervalOnIdle();
        this.actions = configuration.getActions();
        this.actionAge = configuration.getActionAge();
        this.enableErrTrace = configuration.isEnableErrTrace();
        this.errs = configuration.getErrs();
        this.errRspSize = configuration.getErrRspSize();
        this.stackDepth = configuration.getStackDepth();
        this.dnsconn = configuration.isDnsconn();
        this.urlFilterMode = configuration.getUrlFilterMode();
        if (configuration.getUrlRules() != null) {
            this.urlRules = configuration.getUrlRules();
        }
        if (configuration.getIgnoreErrRules() != null) {
            this.ignoreErrRules = configuration.getIgnoreErrRules();
        }
        this.uiTraceThreshold = configuration.getUiTraceThreshold();
        this.uiTraces = configuration.getUiTraces();
        this.uiTraceSize = configuration.getUiTraceSize();
        this.uiTraceRetries = configuration.getUiTraceRetries();
        this.ignoreErrRules = configuration.getIgnoreErrRules();
        this.urlParamArray = configuration.getUrlParamArray();
        this.crashTrails = configuration.getCrashTrails();
        this.betaonFlag = configuration.getBetaonFlag();
        this.http_network_enabled = configuration.getHttp_network_enabled();
        this.crash_enabled = configuration.getCrash_enabled();
        this.ui_enabled = configuration.getUi_enabled();
        this.webview_enabled = configuration.getWebview_enabled();
        this.socketdata_enabled = configuration.getSocketData_enable();
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public int getIntervalOnIdle() {
        return this.intervalOnIdle;
    }

    public void setIntervalOnIdle(int intervalOnIdle) {
        this.intervalOnIdle = intervalOnIdle;
    }

    public int getActions() {
        return this.actions;
    }

    public void setActions(int actions) {
        this.actions = actions;
    }

    public int getActionAge() {
        return this.actionAge;
    }

    public void setActionAge(int actionAge) {
        this.actionAge = actionAge;
    }

    public boolean isEnableErrTrace() {
        return this.enableErrTrace;
    }

    public void setEnableErrTrace(boolean enableErrTrace) {
        this.enableErrTrace = enableErrTrace;
    }

    public int getErrs() {
        return this.errs;
    }

    public void setErrs(int errs) {
        this.errs = errs;
    }

    public int getErrRspSize() {
        return this.errRspSize;
    }

    public void setErrRspSize(int errRspSize) {
        this.errRspSize = errRspSize;
    }

    public int getStackDepth() {
        return this.stackDepth;
    }

    public void setStackDepth(int stackDepth) {
        this.stackDepth = stackDepth;
    }

    public boolean isDnsconn() {
        return this.dnsconn;
    }

    public void setDnsconn(boolean dnsconn) {
        this.dnsconn = dnsconn;
    }

    public int getUrlFilterMode() {
        return this.urlFilterMode;
    }

    public void setUrlFilterMode(int urlFilterMode) {
        this.urlFilterMode = urlFilterMode;
    }

    public ArrayList<s.b> getUrlRules() {
        return this.urlRules;
    }

    public void setUrlRules(ArrayList<s.b> urlRules) {
        this.urlRules = urlRules;
    }

    public ArrayList<s.a> getIgnoreErrRules() {
        return this.ignoreErrRules;
    }

    public void setIgnoreErrRules(ArrayList<s.a> ignoreErrRules) {
        this.ignoreErrRules = ignoreErrRules;
    }

    public float getUiTraceThreshold() {
        return this.uiTraceThreshold;
    }

    public void setUiTraceThreshold(float uiTraceThreshold) {
        this.uiTraceThreshold = uiTraceThreshold;
    }

    public int getUiTraceSize() {
        return this.uiTraceSize;
    }

    public void setUiTraceSize(int uiTraceSize) {
        this.uiTraceSize = uiTraceSize;
    }

    public int getUiTraceRetries() {
        return this.uiTraceRetries;
    }

    public void setUiTraceRetries(int uiTraceRetries) {
        this.uiTraceRetries = uiTraceRetries;
    }

    public int getUiTraces() {
        return this.uiTraces;
    }

    public void setUiTraces(int uiTraces) {
        this.uiTraces = uiTraces;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.actionAge;
        n3 = 31 * n3 + this.actions;
        n3 = 31 * n3 + (this.dnsconn ? 1231 : 1237);
        n3 = 31 * n3 + (this.enableErrTrace ? 1231 : 1237);
        n3 = 31 * n3 + this.errRspSize;
        n3 = 31 * n3 + this.errs;
        n3 = 31 * n3 + (this.ignoreErrRules == null ? 0 : this.ignoreErrRules.hashCode());
        n3 = 31 * n3 + (int)(this.interval ^ this.interval >>> 32);
        n3 = 31 * n3 + this.intervalOnIdle;
        n3 = 31 * n3 + this.stackDepth;
        n3 = 31 * n3 + this.uiTraceRetries;
        n3 = 31 * n3 + this.uiTraceSize;
        n3 = 31 * n3 + Float.floatToIntBits(this.uiTraceThreshold);
        n3 = 31 * n3 + this.uiTraces;
        n3 = 31 * n3 + this.urlFilterMode;
        n3 = 31 * n3 + (this.urlRules == null ? 0 : this.urlRules.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HarvestConfiguration harvestConfiguration = (HarvestConfiguration)obj;
        if (this.actionAge != harvestConfiguration.actionAge) {
            return false;
        }
        if (this.actions != harvestConfiguration.actions) {
            return false;
        }
        if (this.dnsconn != harvestConfiguration.dnsconn) {
            return false;
        }
        if (this.enableErrTrace != harvestConfiguration.enableErrTrace) {
            return false;
        }
        if (this.errRspSize != harvestConfiguration.errRspSize) {
            return false;
        }
        if (this.errs != harvestConfiguration.errs) {
            return false;
        }
        if (this.ignoreErrRules == null ? harvestConfiguration.ignoreErrRules != null : !this.ignoreErrRules.equals(harvestConfiguration.ignoreErrRules)) {
            return false;
        }
        if (this.interval != harvestConfiguration.interval) {
            return false;
        }
        if (this.intervalOnIdle != harvestConfiguration.intervalOnIdle) {
            return false;
        }
        if (this.stackDepth != harvestConfiguration.stackDepth) {
            return false;
        }
        if (this.uiTraceRetries != harvestConfiguration.uiTraceRetries) {
            return false;
        }
        if (this.uiTraceSize != harvestConfiguration.uiTraceSize) {
            return false;
        }
        if (Float.floatToIntBits(this.uiTraceThreshold) != Float.floatToIntBits(harvestConfiguration.uiTraceThreshold)) {
            return false;
        }
        if (this.uiTraces != harvestConfiguration.uiTraces) {
            return false;
        }
        if (this.urlFilterMode != harvestConfiguration.urlFilterMode) {
            return false;
        }
        return !(this.urlRules == null ? harvestConfiguration.urlRules != null : !this.urlRules.equals(harvestConfiguration.urlRules));
    }

    public String toString() {
        Object object;
        Iterator<Object> iterator;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("did:" + this.deviceId + ",");
        stringBuilder.append("token:" + this.token + ",");
        stringBuilder.append("interval:" + this.interval + ",");
        stringBuilder.append("intervalOnIdle:" + this.intervalOnIdle + ",");
        stringBuilder.append("urlFilterMode:" + this.urlFilterMode + ",");
        stringBuilder.append("uiTraces:" + this.uiTraces + ",");
        stringBuilder.append("uiTraceSize:" + this.uiTraceSize + ",");
        stringBuilder.append("uiTraceRetries:" + this.uiTraceRetries + ",");
        stringBuilder.append("uiTraceThreshold:" + this.uiTraceThreshold + ",");
        stringBuilder.append("crashTrails:" + this.crashTrails + ",");
        stringBuilder.append("http_network_enabled:" + this.http_network_enabled + ",");
        stringBuilder.append("ui_enabled:" + this.ui_enabled + ",");
        stringBuilder.append("crash_enabled:" + this.crash_enabled + ",");
        stringBuilder.append("webview_enabled:" + this.webview_enabled + ",");
        stringBuilder.append("socket_enabled:" + this.socketdata_enabled + ",");
        if (this.urlRules != null) {
            iterator = this.urlRules.iterator();
            stringBuilder.append("urlRules:");
            while (iterator.hasNext()) {
                object = (s.b)iterator.next();
                stringBuilder.append("matchMode:" + ((s.b)object).a + ",");
                stringBuilder.append("rule:" + ((s.b)object).b + ",");
            }
        }
        if (this.urlParamArray != null) {
            iterator = this.urlParamArray.iterator();
            stringBuilder.append("urlParmas:");
            while (iterator.hasNext()) {
                object = (s.c)iterator.next();
                stringBuilder.append(((s.c)object).a).append(",");
                stringBuilder.append(((s.c)object).b).append(",");
                stringBuilder.append(((s.c)object).c).append(",");
                stringBuilder.append(((s.c)object).d);
            }
        }
        return stringBuilder.toString();
    }

    public int getCrashTrails() {
        return this.crashTrails;
    }

    public void setCrashTrails(int crashTrails) {
        this.crashTrails = crashTrails;
    }

    public int getBetaonFlag() {
        return this.betaonFlag;
    }

    public void setBetaonFlag(int flag) {
        this.betaonFlag = flag;
    }

    public boolean getHttp_network_enabled() {
        return this.http_network_enabled;
    }

    public void setHttp_network_enabled(boolean http_network_enabled) {
        this.http_network_enabled = http_network_enabled;
    }

    public boolean getUi_enabled() {
        return this.ui_enabled;
    }

    public void setUi_enabled(boolean ui_enabled) {
        this.ui_enabled = ui_enabled;
    }

    public boolean getCrash_enabled() {
        return this.crash_enabled;
    }

    public void setCrash_enabled(boolean crash_enabled) {
        this.crash_enabled = crash_enabled;
        x.c().f(crash_enabled);
    }

    public boolean getWebview_enabled() {
        return this.webview_enabled;
    }

    public void setWebview_enabled(boolean webview_enabled) {
        this.webview_enabled = webview_enabled;
        x.c().g(webview_enabled);
    }

    public boolean getSocketData_enable() {
        return this.socketdata_enabled;
    }

    public void setSocketdata_enabled(boolean socketdata_enabled) {
        this.socketdata_enabled = socketdata_enabled;
    }

    public double getUiTraceMaxTime() {
        return this.uiTraceMaxTime;
    }

    public boolean getCrossApplicationEnable() {
        return this.cross_app_enable;
    }

    public void setCrossApplicationEnable(boolean cross_app_enable) {
        this.cross_app_enable = cross_app_enable;
        log.a("CrossApplicationEnable is " + cross_app_enable);
        x.c().h(cross_app_enable);
    }

    public void setTyId(String tyId) {
        this.tyId = tyId;
        x.c().h(tyId);
    }

    public String getTyId() {
        return this.tyId;
    }

    public void setSlowInteractionThreshold(int slowInteractionThreshold) {
        this.slowInteractionThreshold = slowInteractionThreshold;
        x.c().c(slowInteractionThreshold);
    }
}

