/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.TimingLogger;
import com.networkbench.agent.impl.NBSAgent;
import com.networkbench.agent.impl.a.d;
import com.networkbench.agent.impl.a.f;
import com.networkbench.agent.impl.b.c;
import com.networkbench.agent.impl.harvest.Harvest;
import com.networkbench.agent.impl.j.e;
import com.networkbench.agent.impl.j.g;
import com.networkbench.agent.impl.l.am;
import com.networkbench.agent.impl.l.n;
import com.networkbench.agent.impl.l.x;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NBSAppAgent {
    public static final boolean DEBUG_MODE = false;
    public static int LOG_LEVEL_INFO = 1;
    public static int LOG_LEVEL_VERBOSE = 2;
    public static int LOG_LEVEL_DEBUG = 4;
    public static int LOG_LEVEL_ERROR = 8;
    public static int LOG_LEVEL_WARNING = 16;
    public static final int LOG_LEVEL_FLAG = LOG_LEVEL_INFO;
    public static final long DEFAULT_LOCATION_UPDATE_TIMEOUT_IN_MS = 60000L;
    public static final long DEFAULT_LOCATION_UPDATE_INTERVAL_IN_MS = 3000L;
    public static final float DEFAULT_LOCATION_UPDATE_DISTANCE_IN_METERS = 1.0f;
    private static com.networkbench.agent.impl.e.c log = com.networkbench.agent.impl.e.d.a();
    private ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor(new com.networkbench.agent.impl.l.e());
    private boolean ssl = true;
    private boolean locationServicesEnabled = true;
    private boolean crashReportEnabled = true;
    private boolean anrReportEnabled = true;
    private volatile boolean apmIsRunning = false;
    private int ratio = 100;
    private boolean X5Enabled = false;
    private static volatile NBSAppAgent appAgent = null;
    private f tracelistener = null;
    public static final boolean BUSINESSS = false;

    private NBSAppAgent() {
    }

    private NBSAppAgent(String licenseKey) {
        x.c().b(licenseKey);
    }

    public static NBSAppAgent setLicenseKey(String key) {
        if (appAgent == null && appAgent == null) {
            appAgent = new NBSAppAgent(key);
        }
        return appAgent;
    }

    public NBSAppAgent withLocationServiceEnabled(boolean enabled) {
        this.locationServicesEnabled = enabled;
        return this;
    }

    public NBSAppAgent withCrashReportEnabled(boolean enabled) {
        this.crashReportEnabled = enabled;
        return this;
    }

    private NBSAppAgent withLoggingEnabled(boolean enabled) {
        return this;
    }

    public NBSAppAgent withSampleRatio(int ratio) {
        this.ratio = ratio;
        return this;
    }

    public boolean isSslEnabled() {
        return this.ssl;
    }

    public NBSAppAgent setHttpEnabled(boolean isEnabled) {
        this.ssl = !isEnabled;
        return this;
    }

    public NBSAppAgent setX5Enable(boolean isEnabled) {
        this.X5Enabled = isEnabled;
        return this;
    }

    public static void setUserCrashMessage(String key, String value) {
        com.networkbench.agent.impl.b.d.a(key, value);
    }

    public synchronized void start(Context context) {
        TimingLogger timingLogger = new TimingLogger("NBSAgent", "NBSAppAgent start");
        if (this.apmIsRunning) {
            log.b("NBSAgent is already running.");
            return;
        }
        try {
            com.networkbench.agent.impl.e.d.a(new com.networkbench.agent.impl.e.e());
            String string = x.g(context.getPackageName());
            SharedPreferences sharedPreferences = context.getSharedPreferences(string, 0);
            long l2 = sharedPreferences.getLong("disabledTimeout", 0L);
            if (System.currentTimeMillis() < l2) {
                log.b("NBSAgent disabled.");
                return;
            }
            if (!this.hitPercent()) {
                return;
            }
            log.b("NBSAgent start.");
            timingLogger.addSplit("setLog");
            if (this.isInstrumented()) {
                String string2 = am.a(context);
                if (null == Harvest.currentActivityName) {
                    log.b("please init NBSAgent in" + string2);
                    return;
                }
                log.b("NBSAgent enabled.");
                log.b(MessageFormat.format("NBSAgent V{0}", NBSAgent.getVersion()));
                log.a("tencent X5 is " + this.X5Enabled);
                x.c().d(this.X5Enabled);
                this.initializeNetworkMonitoring();
                if (this.crashReportEnabled) {
                    this.enableCrashReporting(context);
                }
                if (this.anrReportEnabled) {
                    this.enableAnrReporting(context);
                }
            } else {
                log.b("NBSAgent not enabled.");
                return;
            }
            x.c().a(context);
            x.c().a(this.locationServicesEnabled);
            x.c().c(this.ssl);
            n.d(context);
            this.apmIsRunning = true;
            timingLogger.addSplit("instrument");
        }
        catch (Throwable throwable) {
            log.a("Error occurred while starting the NBS agent!", throwable);
        }
        timingLogger.dumpToLog();
    }

    private boolean hitPercent() {
        Random random = new Random();
        int n2 = 101;
        int n3 = 1;
        int n4 = random.nextInt(n2 - n3) + n3;
        return n4 <= this.ratio;
    }

    private synchronized void initializeNetworkMonitoring() {
        if (this.X5Enabled) {
            boolean bl = false;
            if (g.b()) {
                try {
                    e e2 = new e();
                    Socket.setSocketImplFactory(e2);
                    bl = true;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
            }
            if (bl) {
                log.a("Network monitoring was initialized successfully!");
            }
        }
    }

    private void enableCrashReporting(Context context) {
        com.networkbench.agent.impl.b.f.a(context);
        c.a(com.networkbench.agent.impl.b.f.a());
    }

    private void enableAnrReporting(Context context) {
        this.tracelistener = new f(context, "/data/anr/", 8);
        this.tracelistener.startWatching();
        d.a(context);
    }

    private boolean isInstrumented() {
        return false;
    }

    @Deprecated
    public void instrument() {
        log.a("for  test");
    }
}

