/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.com.google.gson.internal;

import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class UnsafeAllocator {
    public abstract <T> T newInstance(Class<T> var1) throws Exception;

    public static UnsafeAllocator create() {
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            final Object object = field.get(null);
            final Method method = clazz.getMethod("allocateInstance", Class.class);
            return new UnsafeAllocator(){

                @Override
                public <T> T newInstance(Class<T> c2) throws Exception {
                    return (T)method.invoke(object, c2);
                }
            };
        }
        catch (Exception exception) {
            try {
                final Method method = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
                method.setAccessible(true);
                return new UnsafeAllocator(){

                    @Override
                    public <T> T newInstance(Class<T> c2) throws Exception {
                        return (T)method.invoke(null, c2, Object.class);
                    }
                };
            }
            catch (Exception exception2) {
                try {
                    Method method = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
                    method.setAccessible(true);
                    final int n2 = (Integer)method.invoke(null, Object.class);
                    final Method method2 = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, Integer.TYPE);
                    method2.setAccessible(true);
                    return new UnsafeAllocator(){

                        @Override
                        public <T> T newInstance(Class<T> c2) throws Exception {
                            return (T)method2.invoke(null, c2, n2);
                        }
                    };
                }
                catch (Exception exception3) {
                    return new UnsafeAllocator(){

                        @Override
                        public <T> T newInstance(Class<T> c2) {
                            throw new UnsupportedOperationException("Cannot allocate " + c2);
                        }
                    };
                }
            }
        }
    }
}

