/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.com.google.gson.internal;

import com.networkbench.com.google.gson.ExclusionStrategy;
import com.networkbench.com.google.gson.FieldAttributes;
import com.networkbench.com.google.gson.Gson;
import com.networkbench.com.google.gson.TypeAdapter;
import com.networkbench.com.google.gson.TypeAdapterFactory;
import com.networkbench.com.google.gson.annotations.Expose;
import com.networkbench.com.google.gson.annotations.Since;
import com.networkbench.com.google.gson.annotations.Until;
import com.networkbench.com.google.gson.reflect.TypeToken;
import com.networkbench.com.google.gson.stream.JsonReader;
import com.networkbench.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    private static final double IGNORE_VERSIONS = -1.0;
    public static final Excluder DEFAULT = new Excluder();
    private double version = -1.0;
    private int modifiers = 136;
    private boolean serializeInnerClasses = true;
    private boolean requireExpose;
    private List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    private List<ExclusionStrategy> deserializationStrategies = Collections.emptyList();

    protected Excluder a() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public Excluder withVersion(double ignoreVersionsAfter) {
        Excluder excluder = this.a();
        excluder.version = ignoreVersionsAfter;
        return excluder;
    }

    public Excluder withModifiers(int ... modifiers) {
        Excluder excluder = this.a();
        excluder.modifiers = 0;
        for (int n2 : modifiers) {
            excluder.modifiers |= n2;
        }
        return excluder;
    }

    public Excluder disableInnerClassSerialization() {
        Excluder excluder = this.a();
        excluder.serializeInnerClasses = false;
        return excluder;
    }

    public Excluder excludeFieldsWithoutExposeAnnotation() {
        Excluder excluder = this.a();
        excluder.requireExpose = true;
        return excluder;
    }

    public Excluder withExclusionStrategy(ExclusionStrategy exclusionStrategy, boolean serialization, boolean deserialization) {
        Excluder excluder = this.a();
        if (serialization) {
            excluder.serializationStrategies = new ArrayList<ExclusionStrategy>(this.serializationStrategies);
            excluder.serializationStrategies.add(exclusionStrategy);
        }
        if (deserialization) {
            excluder.deserializationStrategies = new ArrayList<ExclusionStrategy>(this.deserializationStrategies);
            excluder.deserializationStrategies.add(exclusionStrategy);
        }
        return excluder;
    }

    @Override
    public <T> TypeAdapter<T> create(final Gson gson, final TypeToken<T> type) {
        Class<T> clazz = type.getRawType();
        final boolean bl = this.excludeClass(clazz, true);
        final boolean bl2 = this.excludeClass(clazz, false);
        if (!bl && !bl2) {
            return null;
        }
        return new TypeAdapter<T>(){
            private TypeAdapter<T> f;

            @Override
            public T read(JsonReader in) throws IOException {
                if (bl2) {
                    in.skipValue();
                    return null;
                }
                return this.a().read(in);
            }

            @Override
            public void write(JsonWriter out, T value) throws IOException {
                if (bl) {
                    out.nullValue();
                    return;
                }
                this.a().write(out, value);
            }

            private TypeAdapter<T> a() {
                TypeAdapter typeAdapter = this.f;
                return typeAdapter != null ? typeAdapter : (this.f = gson.getDelegateAdapter(Excluder.this, type));
            }
        };
    }

    public boolean excludeField(Field field, boolean serialize) {
        Object object;
        if ((this.modifiers & field.getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.isValidVersion(field.getAnnotation(Since.class), field.getAnnotation(Until.class))) {
            return true;
        }
        if (field.isSynthetic()) {
            return true;
        }
        if (this.requireExpose && ((object = field.getAnnotation(Expose.class)) == null || (serialize ? !object.serialize() : !object.deserialize()))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(field.getType())) {
            return true;
        }
        if (this.isAnonymousOrLocal(field.getType())) {
            return true;
        }
        Object object2 = object = serialize ? this.serializationStrategies : this.deserializationStrategies;
        if (!object.isEmpty()) {
            FieldAttributes fieldAttributes = new FieldAttributes(field);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ExclusionStrategy exclusionStrategy = (ExclusionStrategy)iterator.next();
                if (!exclusionStrategy.shouldSkipField(fieldAttributes)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean excludeClass(Class<?> clazz, boolean serialize) {
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(clazz)) {
            return true;
        }
        if (this.isAnonymousOrLocal(clazz)) {
            return true;
        }
        List<ExclusionStrategy> list = serialize ? this.serializationStrategies : this.deserializationStrategies;
        for (ExclusionStrategy exclusionStrategy : list) {
            if (!exclusionStrategy.shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnonymousOrLocal(Class<?> clazz) {
        return !Enum.class.isAssignableFrom(clazz) && (clazz.isAnonymousClass() || clazz.isLocalClass());
    }

    private boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !this.isStatic(clazz);
    }

    private boolean isStatic(Class<?> clazz) {
        return (clazz.getModifiers() & 8) != 0;
    }

    private boolean isValidVersion(Since since, Until until) {
        return this.isValidSince(since) && this.isValidUntil(until);
    }

    private boolean isValidSince(Since annotation) {
        double d2;
        return annotation == null || !((d2 = annotation.value()) > this.version);
    }

    private boolean isValidUntil(Until annotation) {
        double d2;
        return annotation == null || !((d2 = annotation.value()) <= this.version);
    }

    protected /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.a();
    }
}

