/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.com.google.gson;

import com.networkbench.com.google.gson.FieldNamingPolicy;
import com.networkbench.com.google.gson.FieldNamingStrategy;
import com.networkbench.com.google.gson.InstanceCreator;
import com.networkbench.com.google.gson.JsonDeserializationContext;
import com.networkbench.com.google.gson.JsonElement;
import com.networkbench.com.google.gson.JsonIOException;
import com.networkbench.com.google.gson.JsonNull;
import com.networkbench.com.google.gson.JsonParseException;
import com.networkbench.com.google.gson.JsonSerializationContext;
import com.networkbench.com.google.gson.JsonSyntaxException;
import com.networkbench.com.google.gson.LongSerializationPolicy;
import com.networkbench.com.google.gson.TypeAdapter;
import com.networkbench.com.google.gson.TypeAdapterFactory;
import com.networkbench.com.google.gson.internal.ConstructorConstructor;
import com.networkbench.com.google.gson.internal.Excluder;
import com.networkbench.com.google.gson.internal.Primitives;
import com.networkbench.com.google.gson.internal.Streams;
import com.networkbench.com.google.gson.internal.a.b;
import com.networkbench.com.google.gson.internal.a.c;
import com.networkbench.com.google.gson.internal.a.d;
import com.networkbench.com.google.gson.internal.a.e;
import com.networkbench.com.google.gson.internal.a.f;
import com.networkbench.com.google.gson.internal.a.g;
import com.networkbench.com.google.gson.internal.a.h;
import com.networkbench.com.google.gson.internal.a.i;
import com.networkbench.com.google.gson.internal.a.j;
import com.networkbench.com.google.gson.internal.a.k;
import com.networkbench.com.google.gson.internal.a.m;
import com.networkbench.com.google.gson.reflect.TypeToken;
import com.networkbench.com.google.gson.stream.JsonReader;
import com.networkbench.com.google.gson.stream.JsonToken;
import com.networkbench.com.google.gson.stream.JsonWriter;
import com.networkbench.com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Gson {
    static final boolean a = false;
    private static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    private final ThreadLocal<Map<TypeToken<?>, a<?>>> calls = new ThreadLocal();
    private final Map<TypeToken<?>, TypeAdapter<?>> typeTokenCache = Collections.synchronizedMap(new HashMap());
    private boolean inConstructorPhase = true;
    private Set<TypeAdapter<?>> preconfiguredGeneratedTypeAdapters = new HashSet();
    private final ThreadLocal<Set<TypeAdapter<?>>> runtimeGeneratedTypeAdapters = new ThreadLocal();
    private final List<TypeAdapterFactory> factories;
    private final ConstructorConstructor constructorConstructor;
    private final boolean serializeNulls;
    private final boolean htmlSafe;
    private final boolean generateNonExecutableJson;
    private final boolean prettyPrinting;
    final JsonDeserializationContext b = new JsonDeserializationContext(){

        @Override
        public <T> T deserialize(JsonElement json, Type typeOfT) throws JsonParseException {
            return Gson.this.fromJson(json, typeOfT);
        }
    };
    final JsonSerializationContext c = new JsonSerializationContext(){

        @Override
        public JsonElement serialize(Object src) {
            return Gson.this.toJsonTree(src);
        }

        @Override
        public JsonElement serialize(Object src, Type typeOfSrc) {
            return Gson.this.toJsonTree(src, typeOfSrc);
        }
    };

    public Gson() {
        this(Excluder.DEFAULT, FieldNamingPolicy.IDENTITY, Collections.emptyMap(), false, false, false, true, false, false, LongSerializationPolicy.DEFAULT, Collections.emptyList());
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingPolicy, Map<Type, InstanceCreator<?>> instanceCreators, boolean serializeNulls, boolean complexMapKeySerialization, boolean generateNonExecutableGson, boolean htmlSafe, boolean prettyPrinting, boolean serializeSpecialFloatingPointValues, LongSerializationPolicy longSerializationPolicy, List<TypeAdapterFactory> typeAdapterFactories) {
        this.constructorConstructor = new ConstructorConstructor(instanceCreators);
        this.serializeNulls = serializeNulls;
        this.generateNonExecutableJson = generateNonExecutableGson;
        this.htmlSafe = htmlSafe;
        this.prettyPrinting = prettyPrinting;
        ArrayList<TypeAdapterFactory> arrayList = new ArrayList<TypeAdapterFactory>();
        arrayList.add(m.Q);
        arrayList.add(h.a);
        arrayList.add(excluder);
        arrayList.addAll(typeAdapterFactories);
        arrayList.add(m.x);
        arrayList.add(m.m);
        arrayList.add(m.g);
        arrayList.add(m.i);
        arrayList.add(m.k);
        arrayList.add(m.a(Long.TYPE, Long.class, this.longAdapter(longSerializationPolicy)));
        arrayList.add(m.a(Double.TYPE, Double.class, this.doubleAdapter(serializeSpecialFloatingPointValues)));
        arrayList.add(m.a(Float.TYPE, Float.class, this.floatAdapter(serializeSpecialFloatingPointValues)));
        arrayList.add(m.r);
        arrayList.add(m.t);
        arrayList.add(m.z);
        arrayList.add(m.B);
        arrayList.add(m.a(BigDecimal.class, m.v));
        arrayList.add(m.a(BigInteger.class, m.w));
        arrayList.add(m.D);
        arrayList.add(m.F);
        arrayList.add(m.J);
        arrayList.add(m.O);
        arrayList.add(m.H);
        arrayList.add(m.d);
        arrayList.add(d.a);
        arrayList.add(m.M);
        arrayList.add(k.a);
        arrayList.add(j.a);
        arrayList.add(m.K);
        arrayList.add(com.networkbench.com.google.gson.internal.a.b.a);
        arrayList.add(m.R);
        arrayList.add(m.b);
        arrayList.add(new c(this.constructorConstructor));
        arrayList.add(new g(this.constructorConstructor, complexMapKeySerialization));
        arrayList.add(new com.networkbench.com.google.gson.internal.a.a(this.constructorConstructor));
        arrayList.add(new i(this.constructorConstructor, fieldNamingPolicy, excluder));
        this.factories = Collections.unmodifiableList(arrayList);
        this.preconfiguredGeneratedTypeAdapters = Collections.unmodifiableSet(this.preconfiguredGeneratedTypeAdapters);
        this.inConstructorPhase = false;
    }

    private TypeAdapter<Number> doubleAdapter(boolean serializeSpecialFloatingPointValues) {
        if (serializeSpecialFloatingPointValues) {
            return m.p;
        }
        return new TypeAdapter<Number>(){

            public Double a(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextDouble();
            }

            public void a(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                double d2 = number.doubleValue();
                Gson.this.checkValidFloatingPoint(d2);
                jsonWriter.value(number);
            }

            @Override
            public /* synthetic */ Object read(JsonReader x0) throws IOException {
                return this.a(x0);
            }

            @Override
            public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
                this.a(x0, (Number)x1);
            }
        };
    }

    private TypeAdapter<Number> floatAdapter(boolean serializeSpecialFloatingPointValues) {
        if (serializeSpecialFloatingPointValues) {
            return m.o;
        }
        return new TypeAdapter<Number>(){

            public Float a(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Float.valueOf((float)jsonReader.nextDouble());
            }

            public void a(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                float f2 = number.floatValue();
                Gson.this.checkValidFloatingPoint(f2);
                jsonWriter.value(number);
            }

            @Override
            public /* synthetic */ Object read(JsonReader x0) throws IOException {
                return this.a(x0);
            }

            @Override
            public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
                this.a(x0, (Number)x1);
            }
        };
    }

    private void checkValidFloatingPoint(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException(value + " is not a valid double value as per JSON specification. To override this" + " behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.");
        }
    }

    private TypeAdapter<Number> longAdapter(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return m.n;
        }
        return new TypeAdapter<Number>(){

            public Number a(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextLong();
            }

            public void a(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.value(number.toString());
            }

            @Override
            public /* synthetic */ Object read(JsonReader x0) throws IOException {
                return this.a(x0);
            }

            @Override
            public /* synthetic */ void write(JsonWriter x0, Object x1) throws IOException {
                this.a(x0, (Number)x1);
            }
        };
    }

    public <T> TypeAdapter<T> getAdapter(TypeToken<T> type) {
        a<?> a2;
        TypeAdapter<?> typeAdapter = this.typeTokenCache.get(type);
        if (typeAdapter != null) {
            return typeAdapter;
        }
        Map<TypeToken<?>, a<?>> map = this.calls.get();
        boolean bl = false;
        if (map == null) {
            map = new HashMap();
            this.calls.set(map);
            bl = true;
        }
        if ((a2 = map.get(type)) != null) {
            return a2;
        }
        try {
            a<T> a3 = new a<T>();
            map.put(type, a3);
            for (TypeAdapterFactory typeAdapterFactory : this.factories) {
                TypeAdapter<T> typeAdapter2 = typeAdapterFactory.create(this, type);
                if (typeAdapter2 == null) continue;
                a3.a(typeAdapter2);
                this.typeTokenCache.put(type, typeAdapter2);
                TypeAdapter<T> typeAdapter3 = typeAdapter2;
                return typeAdapter3;
            }
            throw new IllegalArgumentException("GSON cannot handle " + type);
        }
        finally {
            map.remove(type);
            if (bl) {
                this.calls.remove();
            }
        }
    }

    public <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory skipPast, TypeToken<T> type) {
        boolean bl = false;
        for (TypeAdapterFactory typeAdapterFactory : this.factories) {
            if (!bl) {
                if (typeAdapterFactory != skipPast) continue;
                bl = true;
                continue;
            }
            TypeAdapter<T> typeAdapter = typeAdapterFactory.create(this, type);
            if (typeAdapter == null) continue;
            return typeAdapter;
        }
        throw new IllegalArgumentException("GSON cannot serialize " + type);
    }

    public <T> TypeAdapter<T> getAdapter(Class<T> type) {
        return this.getAdapter(TypeToken.get(type));
    }

    public JsonElement toJsonTree(Object src) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        return this.toJsonTree(src, src.getClass());
    }

    public JsonElement toJsonTree(Object src, Type typeOfSrc) {
        f f2 = new f();
        this.toJson(src, typeOfSrc, f2);
        return f2.a();
    }

    public String toJson(Object src) {
        if (src == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        return this.toJson(src, src.getClass());
    }

    public String toJson(Object src, Type typeOfSrc) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(src, typeOfSrc, stringWriter);
        return stringWriter.toString();
    }

    public void toJson(Object src, Appendable writer) throws JsonIOException {
        if (src != null) {
            this.toJson(src, src.getClass(), writer);
        } else {
            this.toJson((JsonElement)JsonNull.INSTANCE, writer);
        }
    }

    public void toJson(Object src, Type typeOfSrc, Appendable writer) throws JsonIOException {
        try {
            JsonWriter jsonWriter = this.newJsonWriter(Streams.writerForAppendable(writer));
            this.toJson(src, typeOfSrc, jsonWriter);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public void toJson(Object src, Type typeOfSrc, JsonWriter writer) throws JsonIOException {
        TypeAdapter<?> typeAdapter = this.getAdapter(TypeToken.get(typeOfSrc));
        boolean bl = writer.isLenient();
        writer.setLenient(true);
        boolean bl2 = writer.isHtmlSafe();
        writer.setHtmlSafe(this.htmlSafe);
        boolean bl3 = writer.getSerializeNulls();
        writer.setSerializeNulls(this.serializeNulls);
        try {
            typeAdapter.write(writer, src);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        finally {
            writer.setLenient(bl);
            writer.setHtmlSafe(bl2);
            writer.setSerializeNulls(bl3);
        }
    }

    public String toJson(JsonElement jsonElement) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(jsonElement, (Appendable)stringWriter);
        return stringWriter.toString();
    }

    public void toJson(JsonElement jsonElement, Appendable writer) throws JsonIOException {
        try {
            JsonWriter jsonWriter = this.newJsonWriter(Streams.writerForAppendable(writer));
            this.toJson(jsonElement, jsonWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private JsonWriter newJsonWriter(Writer writer) throws IOException {
        if (this.generateNonExecutableJson) {
            writer.write(JSON_NON_EXECUTABLE_PREFIX);
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        if (this.prettyPrinting) {
            jsonWriter.setIndent("  ");
        }
        jsonWriter.setSerializeNulls(this.serializeNulls);
        return jsonWriter;
    }

    public void toJson(JsonElement jsonElement, JsonWriter writer) throws JsonIOException {
        boolean bl = writer.isLenient();
        writer.setLenient(true);
        boolean bl2 = writer.isHtmlSafe();
        writer.setHtmlSafe(this.htmlSafe);
        boolean bl3 = writer.getSerializeNulls();
        writer.setSerializeNulls(this.serializeNulls);
        try {
            Streams.write(jsonElement, writer);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        finally {
            writer.setLenient(bl);
            writer.setHtmlSafe(bl2);
            writer.setSerializeNulls(bl3);
        }
    }

    public <T> T fromJson(String json, Class<T> classOfT) throws JsonSyntaxException {
        T t2 = this.fromJson(json, (Type)classOfT);
        return Primitives.wrap(classOfT).cast(t2);
    }

    public <T> T fromJson(String json, Type typeOfT) throws JsonSyntaxException {
        if (json == null) {
            return null;
        }
        StringReader stringReader = new StringReader(json);
        T t2 = this.fromJson((Reader)stringReader, typeOfT);
        return t2;
    }

    public <T> T fromJson(Reader json, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        JsonReader jsonReader = new JsonReader(json);
        T t2 = this.fromJson(jsonReader, classOfT);
        Gson.assertFullConsumption(t2, jsonReader);
        return Primitives.wrap(classOfT).cast(t2);
    }

    public <T> T fromJson(Reader json, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        JsonReader jsonReader = new JsonReader(json);
        T t2 = this.fromJson(jsonReader, typeOfT);
        Gson.assertFullConsumption(t2, jsonReader);
        return t2;
    }

    private static void assertFullConsumption(Object obj, JsonReader reader) {
        try {
            if (obj != null && reader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public <T> T fromJson(JsonReader reader, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        boolean bl = true;
        boolean bl2 = reader.isLenient();
        reader.setLenient(true);
        try {
            Object obj;
            reader.peek();
            bl = false;
            TypeToken<?> typeToken = TypeToken.get(typeOfT);
            TypeAdapter<?> typeAdapter = this.getAdapter(typeToken);
            Object obj2 = obj = typeAdapter.read(reader);
            return (T)obj2;
        }
        catch (EOFException eOFException) {
            if (bl) {
                T t2 = null;
                return t2;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JsonSyntaxException(illegalStateException);
        }
        catch (IOException iOException) {
            throw new JsonSyntaxException(iOException);
        }
        finally {
            reader.setLenient(bl2);
        }
    }

    public <T> T fromJson(JsonElement json, Class<T> classOfT) throws JsonSyntaxException {
        T t2 = this.fromJson(json, (Type)classOfT);
        return Primitives.wrap(classOfT).cast(t2);
    }

    public <T> T fromJson(JsonElement json, Type typeOfT) throws JsonSyntaxException {
        if (json == null) {
            return null;
        }
        return this.fromJson(new e(json), typeOfT);
    }

    public String toString() {
        return "{serializeNulls:" + this.serializeNulls + "factories:" + this.factories + ",instanceCreators:" + this.constructorConstructor + "}";
    }

    static /* synthetic */ boolean a(Gson gson) {
        return gson.inConstructorPhase;
    }

    static /* synthetic */ Set b(Gson gson) {
        return gson.preconfiguredGeneratedTypeAdapters;
    }

    static /* synthetic */ ThreadLocal c(Gson gson) {
        return gson.runtimeGeneratedTypeAdapters;
    }

    static class a<T>
    extends TypeAdapter<T> {
        private TypeAdapter<T> a;

        a() {
        }

        public void a(TypeAdapter<T> typeAdapter) {
            if (this.a != null) {
                throw new AssertionError();
            }
            this.a = typeAdapter;
        }

        @Override
        public T read(JsonReader in) throws IOException {
            if (this.a == null) {
                throw new IllegalStateException();
            }
            return this.a.read(in);
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            if (this.a == null) {
                throw new IllegalStateException();
            }
            this.a.write(out, value);
        }
    }
}

