/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.com.google.gson;

import com.networkbench.com.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;

public enum FieldNamingPolicy implements FieldNamingStrategy
{
    IDENTITY{

        @Override
        public String translateName(Field f2) {
            return f2.getName();
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public String translateName(Field f2) {
            return FieldNamingPolicy.upperCaseFirstLetter(f2.getName());
        }
    }
    ,
    UPPER_CAMEL_CASE_WITH_SPACES{

        @Override
        public String translateName(Field f2) {
            return FieldNamingPolicy.upperCaseFirstLetter(FieldNamingPolicy.separateCamelCase(f2.getName(), " "));
        }
    }
    ,
    LOWER_CASE_WITH_UNDERSCORES{

        @Override
        public String translateName(Field f2) {
            return FieldNamingPolicy.separateCamelCase(f2.getName(), "_").toLowerCase();
        }
    }
    ,
    LOWER_CASE_WITH_DASHES{

        @Override
        public String translateName(Field f2) {
            return FieldNamingPolicy.separateCamelCase(f2.getName(), "-").toLowerCase();
        }
    };


    private static String separateCamelCase(String name, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (Character.isUpperCase(c2) && stringBuilder.length() != 0) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static String upperCaseFirstLetter(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        char c2 = name.charAt(n2);
        while (n2 < name.length() - 1 && !Character.isLetter(c2)) {
            stringBuilder.append(c2);
            c2 = name.charAt(++n2);
        }
        if (n2 == name.length()) {
            return stringBuilder.toString();
        }
        if (!Character.isUpperCase(c2)) {
            String string = FieldNamingPolicy.modifyString(Character.toUpperCase(c2), name, ++n2);
            return stringBuilder.append(string).toString();
        }
        return name;
    }

    private static String modifyString(char firstCharacter, String srcString, int indexOfSubstring) {
        return indexOfSubstring < srcString.length() ? firstCharacter + srcString.substring(indexOfSubstring) : String.valueOf(firstCharacter);
    }
}

