/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.tracing;

import com.networkbench.agent.impl.activity.NamedActivity;
import com.networkbench.agent.impl.d.c;
import com.networkbench.agent.impl.d.d;
import com.networkbench.agent.impl.e.j;
import com.networkbench.agent.impl.g.a;
import com.networkbench.agent.impl.g.b;
import com.networkbench.agent.impl.harvest.type.HarvestableArray;
import com.networkbench.agent.impl.instrumentation.NBSTraceUnit;
import com.networkbench.agent.impl.j.ah;
import com.networkbench.com.google.gson.JsonArray;
import com.networkbench.com.google.gson.JsonElement;
import com.networkbench.com.google.gson.JsonObject;
import com.networkbench.com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ActivityTrace
extends HarvestableArray {
    public static final int MAX_TRACES = 2000;
    public NBSTraceUnit rootTrace;
    private final ConcurrentHashMap<UUID, NBSTraceUnit> traces = new ConcurrentHashMap();
    private int traceCount = 0;
    private final Set<UUID> missingChildren = Collections.synchronizedSet(new HashSet());
    private NamedActivity measuredActivity;
    private long reportAttemptCount = 0L;
    public long lastUpdatedAt;
    public long startedAt;
    private boolean complete = false;
    private Map<b, Collection<a>> vitals;
    private final c log = d.a();

    public ActivityTrace() {
    }

    public ActivityTrace(NBSTraceUnit rootTrace) {
        this.rootTrace = rootTrace;
        this.startedAt = this.lastUpdatedAt = rootTrace.entryTimestamp;
        this.measuredActivity = (NamedActivity)j.a(rootTrace.displayName);
        this.measuredActivity.setStartTime(rootTrace.entryTimestamp);
    }

    public void addTrace(NBSTraceUnit trace) {
        this.missingChildren.add(trace.myUUID);
        this.lastUpdatedAt = System.currentTimeMillis();
    }

    public void addCompletedTrace(NBSTraceUnit trace) {
        trace.tracer = null;
        this.missingChildren.remove(trace.myUUID);
        if (this.traceCount > 2000) {
            this.log.e("Maximum trace limit reached, discarding trace " + trace.myUUID);
            return;
        }
        this.traces.put(trace.myUUID, trace);
        ++this.traceCount;
        if (trace.exitTimestamp > this.rootTrace.exitTimestamp) {
            this.rootTrace.exitTimestamp = trace.exitTimestamp;
        }
        this.log.c("Added trace " + trace.myUUID.toString() + " missing children: " + this.missingChildren.size());
        this.lastUpdatedAt = System.currentTimeMillis();
    }

    public boolean hasMissingChildren() {
        return !this.missingChildren.isEmpty();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void complete() {
        if (this.rootTrace.exitTimestamp == 0L) {
            this.rootTrace.exitTimestamp = System.currentTimeMillis();
        }
        if (this.traces.isEmpty()) {
            this.log.e("trace is empty");
            this.rootTrace.tracer = null;
            this.complete = true;
            j.b(this.measuredActivity);
            return;
        }
        this.measuredActivity.setEndTime(this.rootTrace.exitTimestamp);
        j.a(this.measuredActivity);
        this.rootTrace.tracer = null;
        this.complete = true;
        ah.a(this);
    }

    public Map<UUID, NBSTraceUnit> getTraces() {
        return this.traces;
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArray jsonArray = new JsonArray();
        if (!this.complete) {
            this.log.e("Attempted to serialize trace " + this.rootTrace.myUUID.toString() + " but it has yet to be finalized");
            return null;
        }
        this.log.c("collect activity trace");
        jsonArray.add(new JsonPrimitive(TimeUnit.SECONDS.convert(this.rootTrace.entryTimestamp, TimeUnit.MILLISECONDS)));
        jsonArray.add(new JsonPrimitive(this.rootTrace.getDuration()));
        jsonArray.add(new JsonPrimitive(this.rootTrace.metricName));
        JsonArray jsonArray2 = new JsonArray();
        jsonArray2.add(new JsonPrimitive(TimeUnit.SECONDS.convert(this.rootTrace.entryTimestamp, TimeUnit.MILLISECONDS)));
        jsonArray2.add(this.getCPUSampleData());
        jsonArray2.add(this.getMemorySampleData());
        jsonArray2.add(this.traceToTree(this.rootTrace));
        jsonArray.add(new JsonPrimitive(jsonArray2.toString()));
        return jsonArray;
    }

    private JsonArray traceToTree(NBSTraceUnit trace) {
        Object object;
        Object object2;
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(new JsonPrimitive(trace.entryTimestamp - this.rootTrace.entryTimestamp));
        jsonArray.add(new JsonPrimitive(trace.exitTimestamp - this.rootTrace.entryTimestamp));
        jsonArray.add(new JsonPrimitive(trace.displayName));
        JsonArray jsonArray2 = new JsonArray();
        jsonArray2.add(new JsonPrimitive(trace.threadId));
        jsonArray2.add(new JsonPrimitive(trace.threadName));
        jsonArray.add(jsonArray2);
        if (trace.getParams() != null && trace.getParams().size() > 0) {
            object2 = (ConcurrentHashMap)trace.getParams();
            Iterator<Object> iterator = ((ConcurrentHashMap)object2).keySet().iterator();
            JsonObject object3 = new JsonObject();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Object v2 = ((ConcurrentHashMap)object2).get(object);
                object3.add((String)object, new JsonPrimitive(v2));
            }
            this.log.c("traceToTreeadd:" + object3);
            jsonArray.add(object3);
        } else {
            jsonArray.add(new JsonObject());
        }
        if (trace.getChildren().isEmpty()) {
            jsonArray.add(new JsonArray());
        } else {
            object2 = new JsonArray();
            for (UUID uUID : trace.getChildren()) {
                object = this.traces.get(uUID);
                if (object == null) continue;
                ((JsonArray)object2).add(this.traceToTree((NBSTraceUnit)object));
            }
            jsonArray.add((JsonElement)object2);
        }
        return jsonArray;
    }

    private JsonArray traceToTreeO(NBSTraceUnit trace) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(new JsonPrimitive(0));
        jsonArray.add(new JsonPrimitive(trace.getDuration()));
        jsonArray.add(new JsonPrimitive(trace.displayName));
        JsonArray jsonArray2 = new JsonArray();
        jsonArray2.add(new JsonPrimitive(0));
        jsonArray2.add(new JsonPrimitive("main"));
        jsonArray.add(jsonArray2);
        jsonArray.add(new JsonObject());
        JsonArray jsonArray3 = new JsonArray();
        if (trace.getChildren().isEmpty()) {
            jsonArray.add(new JsonArray());
        } else {
            for (UUID uUID : trace.getChildren()) {
                NBSTraceUnit nBSTraceUnit = this.traces.get(uUID);
                if (nBSTraceUnit != null) {
                    JsonArray jsonArray4 = new JsonArray();
                    jsonArray4.add(new JsonPrimitive(nBSTraceUnit.entryTimestamp - this.rootTrace.entryTimestamp));
                    jsonArray4.add(new JsonPrimitive(nBSTraceUnit.exitTimestamp - this.rootTrace.entryTimestamp));
                    jsonArray4.add(new JsonPrimitive(nBSTraceUnit.displayName));
                    JsonArray jsonArray5 = new JsonArray();
                    jsonArray5.add(new JsonPrimitive(nBSTraceUnit.threadId));
                    jsonArray5.add(new JsonPrimitive(nBSTraceUnit.threadName));
                    jsonArray4.add(jsonArray5);
                    jsonArray4.add(new JsonObject());
                    JsonArray jsonArray6 = new JsonArray();
                    Set<UUID> set = nBSTraceUnit.getChildren();
                    if (set != null && set.size() > 0) {
                        for (UUID uUID2 : set) {
                            if (this.traces.get(uUID2) == null) continue;
                            jsonArray6.add(this.traceToTree(this.traces.get(uUID2)));
                        }
                    }
                    jsonArray4.add(jsonArray6);
                    jsonArray3.add(jsonArray4);
                }
                jsonArray.add(jsonArray3);
            }
        }
        return jsonArray;
    }

    private JsonArray traceToTreeOld(NBSTraceUnit trace) {
        Object object;
        Object object2;
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(new JsonPrimitive(0));
        jsonArray.add(new JsonPrimitive(trace.getDuration()));
        jsonArray.add(new JsonPrimitive(trace.metricName));
        JsonArray jsonArray2 = new JsonArray();
        jsonArray2.add(new JsonPrimitive(0));
        jsonArray2.add(new JsonPrimitive("main"));
        jsonArray.add(jsonArray2);
        jsonArray.add(new JsonObject());
        JsonObject jsonObject = new JsonObject();
        if (trace.getChildren().isEmpty()) {
            jsonArray.add(new JsonArray());
        } else {
            for (UUID object32 : trace.getChildren()) {
                long l2;
                long jsonArray3;
                object2 = this.traces.get(object32);
                if (object2 == null) continue;
                object = (JsonObject)jsonObject.get(((NBSTraceUnit)object2).threadName);
                if (object == null) {
                    object = new JsonObject();
                    ((JsonObject)object).add("entryTimestamp", new JsonPrimitive(((NBSTraceUnit)object2).entryTimestamp - this.rootTrace.entryTimestamp));
                    ((JsonObject)object).add("exitTimestamp", new JsonPrimitive(((NBSTraceUnit)object2).exitTimestamp - this.rootTrace.entryTimestamp));
                    ((JsonObject)object).add("data", new JsonArray());
                    JsonArray jsonArray4 = new JsonArray();
                    jsonArray4.add(new JsonPrimitive(((NBSTraceUnit)object2).threadId));
                    jsonArray4.add(new JsonPrimitive(((NBSTraceUnit)object2).threadName));
                    jsonArray.add(jsonArray4);
                    ((JsonObject)object).add("thread", jsonArray4);
                    jsonObject.add(((NBSTraceUnit)object2).threadName, (JsonElement)object);
                }
                if ((jsonArray3 = ((JsonObject)object).get("exitTimestamp").getAsLong()) < (l2 = ((NBSTraceUnit)object2).exitTimestamp - this.rootTrace.entryTimestamp)) {
                    ((JsonObject)object).add("exitTimestamp", new JsonPrimitive(l2));
                }
                ((JsonArray)((JsonObject)object).get("data")).add(this.traceToTree1((NBSTraceUnit)object2));
            }
        }
        Set<Map.Entry<String, JsonElement>> set = jsonObject.entrySet();
        JsonArray jsonArray3 = new JsonArray();
        if (set != null) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                JsonArray jsonArray4 = new JsonArray();
                JsonObject jsonObject2 = (JsonObject)object.getValue();
                jsonArray4.add(jsonObject2.get("entryTimestamp"));
                jsonArray4.add(jsonObject2.get("exitTimestamp"));
                jsonArray4.add(new JsonPrimitive((String)object.getKey()));
                jsonArray4.add(jsonObject2.get("thread"));
                jsonArray4.add(new JsonObject());
                jsonArray4.add(jsonObject2.get("data"));
                jsonArray3.add(jsonArray4);
            }
        }
        jsonArray.add(jsonArray3);
        return jsonArray;
    }

    private JsonArray traceToTree1(NBSTraceUnit trace) {
        Object object;
        Object object2;
        this.log.c("traceToTree1" + trace.toString());
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(new JsonPrimitive(trace.entryTimestamp - this.rootTrace.entryTimestamp));
        jsonArray.add(new JsonPrimitive(trace.exitTimestamp - this.rootTrace.entryTimestamp));
        jsonArray.add(new JsonPrimitive(trace.displayName));
        JsonArray jsonArray2 = new JsonArray();
        jsonArray2.add(new JsonPrimitive(trace.threadId));
        jsonArray2.add(new JsonPrimitive(trace.threadName));
        jsonArray.add(jsonArray2);
        if (trace.getParams() != null && trace.getParams().size() > 0) {
            object2 = (ConcurrentHashMap)trace.getParams();
            Iterator<Object> iterator = ((ConcurrentHashMap)object2).keySet().iterator();
            JsonObject object3 = new JsonObject();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Object v2 = ((ConcurrentHashMap)object2).get(object);
                object3.add((String)object, new JsonPrimitive(v2));
            }
            this.log.c("traceToTreeadd:" + object3);
            jsonArray.add(object3);
        } else {
            jsonArray.add(new JsonObject());
        }
        if (trace.getChildren().isEmpty()) {
            jsonArray.add(new JsonArray());
        } else {
            object2 = new JsonArray();
            for (UUID uUID : trace.getChildren()) {
                object = this.traces.get(uUID);
                if (object == null) continue;
                ((JsonArray)object2).add(this.traceToTree1((NBSTraceUnit)object));
            }
            jsonArray.add((JsonElement)object2);
        }
        return jsonArray;
    }

    private JsonArray getMemorySampleData() {
        Collection<a> collection;
        JsonArray jsonArray = new JsonArray();
        if (this.vitals != null && (collection = this.vitals.get((Object)b.a)) != null) {
            for (a a2 : collection) {
                if (a2.a() > this.lastUpdatedAt) continue;
                jsonArray.add(new a(a2.a() - this.rootTrace.entryTimestamp, a2.b()).asJsonArray());
            }
        }
        return jsonArray;
    }

    private JsonArray getCPUSampleData() {
        Collection<a> collection;
        JsonArray jsonArray = new JsonArray();
        if (this.vitals != null && (collection = this.vitals.get((Object)b.b)) != null) {
            for (a a2 : collection) {
                if (a2.a() > this.lastUpdatedAt) continue;
                jsonArray.add(new a(a2.a() - this.rootTrace.entryTimestamp, a2.b()).asJsonArray());
            }
        }
        return jsonArray;
    }

    public void setVitals(Map<b, Collection<a>> vitals) {
        this.vitals = vitals;
    }

    public void setLastUpdatedAt(long lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public long getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public long getReportAttemptCount() {
        return this.reportAttemptCount;
    }

    public void incrementReportAttemptCount() {
        ++this.reportAttemptCount;
    }
}

