/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation.httpclient;

import com.networkbench.agent.impl.NBSAgent;
import com.networkbench.agent.impl.api.a.b;
import com.networkbench.agent.impl.d.c;
import com.networkbench.agent.impl.d.d;
import com.networkbench.agent.impl.e.b.a;
import com.networkbench.agent.impl.e.j;
import com.networkbench.agent.impl.harvest.HarvestConfiguration;
import com.networkbench.agent.impl.instrumentation.NBSTransactionState;
import com.networkbench.agent.impl.instrumentation.NBSTransactionStateUtil;
import com.networkbench.agent.impl.instrumentation.io.NBSCountingInputStream;
import com.networkbench.agent.impl.instrumentation.io.NBSCountingOutputStream;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteEvent;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteListener;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteListenerSource;
import com.networkbench.agent.impl.j.ah;
import com.networkbench.agent.impl.j.al;
import com.networkbench.agent.impl.j.n;
import com.networkbench.agent.impl.j.z;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.HttpEntityWrapper;

public final class NBSHttpResponseEntityWrapperImpl
extends HttpEntityWrapper
implements NBSStreamCompleteListener {
    private final HttpEntity impl;
    private final NBSTransactionState transactionState;
    private final long contentLengthFromHeader;
    private NBSCountingInputStream contentStream;
    private HttpResponse response;
    private static final c log = d.a();

    public NBSHttpResponseEntityWrapperImpl(HttpResponse response, NBSTransactionState transactionState, long contentLengthFromHeader) {
        super(response.getEntity());
        this.response = response;
        this.impl = response.getEntity();
        this.transactionState = transactionState;
        this.contentLengthFromHeader = contentLengthFromHeader;
    }

    public void consumeContent() throws IOException {
        try {
            this.impl.consumeContent();
        }
        catch (IOException iOException) {
            NBSTransactionStateUtil.setErrorCodeFromException(this.transactionState, iOException);
            if (!this.transactionState.isComplete()) {
                b b2 = this.transactionState.end();
                ah.a(new a(b2.c(), b2.e(), b2.f(), b2.m(), b2.n(), b2.h(), b2.i(), b2.j(), b2.g(), b2.b(), b2.k()));
                if (this.transactionState.isError()) {
                    String string = "";
                    if (this.transactionState.getException() != null) {
                        string = this.transactionState.getException();
                    }
                    j.a(this.transactionState.getUrl(), this.transactionState.getFormattedUrlParams(), this.transactionState.getUrlParams(), this.transactionState.getStatusCode(), "", string, this.transactionState.getRequestMethodType());
                }
            }
            throw iOException;
        }
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        if (this.contentStream != null) {
            return this.contentStream;
        }
        try {
            boolean bl = true;
            if (this.impl instanceof HttpEntityWrapper) {
                HttpEntityWrapper httpEntityWrapper = (HttpEntityWrapper)this.impl;
                bl = !httpEntityWrapper.isChunked();
            }
            this.contentStream = new NBSCountingInputStream(this.impl.getContent(), bl);
            this.contentStream.addStreamCompleteListener(this);
            return this.contentStream;
        }
        catch (IOException iOException) {
            NBSTransactionStateUtil.setErrorCodeFromException(this.transactionState, iOException);
            if (!this.transactionState.isComplete()) {
                b b2 = this.transactionState.end();
                ah.a(new a(b2.c(), b2.e(), b2.f(), b2.m(), b2.n(), b2.h(), b2.i(), b2.j(), b2.g(), b2.b(), b2.k()));
            }
            throw iOException;
        }
    }

    public Header getContentEncoding() {
        return this.impl.getContentEncoding();
    }

    public long getContentLength() {
        return this.impl.getContentLength();
    }

    public Header getContentType() {
        return this.impl.getContentType();
    }

    public boolean isChunked() {
        return this.impl.isChunked();
    }

    public boolean isRepeatable() {
        return this.impl.isRepeatable();
    }

    public boolean isStreaming() {
        return this.impl.isStreaming();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (!this.transactionState.isComplete()) {
            NBSCountingOutputStream nBSCountingOutputStream = new NBSCountingOutputStream(outstream);
            try {
                this.impl.writeTo((OutputStream)nBSCountingOutputStream);
            }
            catch (IOException iOException) {
                NBSTransactionStateUtil.setErrorCodeFromException(this.transactionState, iOException);
                if (!this.transactionState.isComplete()) {
                    this.transactionState.setBytesReceived(nBSCountingOutputStream.getCount());
                    b b2 = this.transactionState.end();
                    ah.a(new a(b2.c(), b2.e(), b2.f(), b2.m(), b2.n(), b2.h(), b2.i(), b2.j(), b2.g(), b2.b(), b2.k()));
                }
                iOException.printStackTrace();
                throw iOException;
            }
            if (!this.transactionState.isComplete()) {
                if (this.contentLengthFromHeader >= 0L) {
                    this.transactionState.setBytesReceived(this.contentLengthFromHeader);
                } else {
                    this.transactionState.setBytesReceived(nBSCountingOutputStream.getCount());
                }
                this.a(this.transactionState);
            }
        } else {
            this.impl.writeTo(outstream);
        }
    }

    @Override
    public void streamComplete(NBSStreamCompleteEvent e2) {
        NBSStreamCompleteListenerSource nBSStreamCompleteListenerSource = (NBSStreamCompleteListenerSource)e2.getSource();
        nBSStreamCompleteListenerSource.removeStreamCompleteListener(this);
        log.c("streamComplete");
        if (!this.transactionState.isComplete()) {
            log.c("transaction not complete");
            if (this.contentLengthFromHeader >= 0L) {
                this.transactionState.setBytesReceived(this.contentLengthFromHeader);
            } else {
                this.transactionState.setBytesReceived(e2.getBytes());
            }
            this.a(this.transactionState);
        }
    }

    @Override
    public void streamError(NBSStreamCompleteEvent e2) {
        NBSStreamCompleteListenerSource nBSStreamCompleteListenerSource = (NBSStreamCompleteListenerSource)e2.getSource();
        nBSStreamCompleteListenerSource.removeStreamCompleteListener(this);
        NBSTransactionStateUtil.setErrorCodeFromException(this.transactionState, e2.getException());
        if (!this.transactionState.isComplete()) {
            this.transactionState.setBytesReceived(e2.getBytes());
        }
    }

    private void a(NBSTransactionState nBSTransactionState) {
        block11: {
            try {
                Object object;
                n n2 = NBSAgent.getImpl();
                if (n2 == null) {
                    return;
                }
                HarvestConfiguration harvestConfiguration = n2.q();
                if (harvestConfiguration == null) {
                    return;
                }
                b b2 = nBSTransactionState.end();
                if (null == b2) {
                    log.e("HttpResponseEntityWrapperImpl transactionData is null!");
                    return;
                }
                if (!al.b(b2.c(), harvestConfiguration.getUrlFilterMode(), harvestConfiguration.getUrlRules())) {
                    return;
                }
                if (nBSTransactionState.isError() && al.a(b2.c(), b2.e(), harvestConfiguration.getIgnoreErrRules())) {
                    nBSTransactionState.setStatusCode(200);
                    b2.a(200);
                    b2.b(0);
                }
                ah.a(new a(b2.c(), b2.e(), b2.f(), b2.m(), b2.n(), b2.h(), b2.i(), b2.j(), b2.g(), b2.b(), b2.k()));
                if (!nBSTransactionState.isError()) break block11;
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    object = this.getContent();
                    if (object instanceof NBSCountingInputStream) {
                        stringBuilder.append(((NBSCountingInputStream)object).getBufferAsString());
                    }
                }
                catch (Exception exception) {
                    log.d(exception.toString());
                }
                object = z.a(this.response);
                object.put("Content-Length", nBSTransactionState.getBytesReceived());
                String string = "";
                if (nBSTransactionState.getException() != null) {
                    string = nBSTransactionState.getException();
                }
                log.d("error message:" + string);
                j.a(b2, stringBuilder.toString(), (Map<String, Object>)object, string);
            }
            catch (Exception exception) {
                log.a("addTransactionAndErrorData", exception);
            }
        }
    }
}

