/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import com.networkbench.agent.impl.d.c;
import com.networkbench.agent.impl.d.d;
import com.networkbench.agent.impl.h.b;
import com.networkbench.agent.impl.h.l;
import com.networkbench.agent.impl.h.m;
import com.networkbench.agent.impl.tracing.SocketEvent;
import java.util.concurrent.ConcurrentHashMap;

public class NativeDCJNILib {
    private static final c log = d.a();
    private static ConcurrentHashMap<Integer, SocketEvent> fd = new ConcurrentHashMap();

    public static void startSocketMonitor() {
        NativeDCJNILib.init();
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    SocketEvent socketEvent;
                    String[] stringArray;
                    if (null != (stringArray = (socketEvent = NativeDCJNILib.getSocketEvent()).getAddressArray()) && stringArray.length > 0) {
                        socketEvent.setConnectAddr(socketEvent.getAddressArray()[0]);
                    }
                    NativeDCJNILib.addDNSData(socketEvent);
                }
            }
        };
        thread.start();
    }

    private static void addDNSData(SocketEvent event) {
        try {
            if (null != event) {
                String string = event.getHost();
                if (null != string && string.equals("") && event.getErrorNumber() == 101 && m.values()[event.getSocketType()].name().equals("SOCKET_CONNECT")) {
                    fd.put(event.getFd(), event);
                    log.a("connect network is unreachable " + event.toString());
                }
                if (string != null && !string.equals("null") && string != "") {
                    String string2 = m.values()[event.getSocketType()].name();
                    if (string2.equals("SOCKET_DNS")) {
                        if (!string.contains("networkbench") && b.a(string)) {
                            b.a().put(new l(m.c, string), event);
                            log.a("dns:" + event.toString());
                        }
                    } else if (string2.equals("SOCKET_SSL")) {
                        if (b.b(string)) {
                            b.a().put(new l(m.d, string), event);
                            log.a("ssl:" + event.toString());
                        }
                    } else if (string2.equals("SOCKET_CONNECT") && b.b(string) && !NativeDCJNILib.isJavaConnectExist(event)) {
                        if (event.getErrorNumber() != 115) {
                            SocketEvent socketEvent = fd.get(event.getFd());
                            if (socketEvent != null && event.getStartTime() - socketEvent.getEndTime() < 2000.0) {
                                log.a("libc connect filter :101/* Network is unreachable */" + event.toString());
                                return;
                            }
                            b.a().put(new l(m.a, string), event);
                            log.a("libc connect:" + event.toString());
                        } else {
                            b.a().put(new l(m.a, string), event);
                            b.b().put(event.getFd(), event);
                            log.a("libc connect: errornumber 115 connect:" + event.toString());
                        }
                    }
                } else if (m.values()[event.getSocketType()].name().equals("SOCKET_WRITE")) {
                    int n2 = event.getFd();
                    SocketEvent socketEvent = b.b().get(n2);
                    if (socketEvent != null) {
                        int n3 = (int)(event.getStartTime() - socketEvent.getStartTime());
                        socketEvent.setTimeElapsed(n3 > 0 ? n3 : 0);
                        socketEvent.setErrorNumber(0);
                        if (!NativeDCJNILib.isJavaConnectExist(socketEvent)) {
                            b.a().put(new l(m.a, socketEvent.getHost()), socketEvent);
                            log.a("libc connect from socket_write:" + socketEvent.toString());
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            log.d("add data from so error, msg = " + exception.getMessage());
        }
    }

    private static boolean isJavaConnectExist(SocketEvent event) {
        boolean bl = false;
        l l2 = new l(m.m, event.getHost());
        SocketEvent socketEvent = b.a().get(l2);
        if (null != socketEvent) {
            double d2 = event.getStartTime();
            double d3 = event.getEndTime();
            if (d2 >= socketEvent.getStartTime() && d3 <= socketEvent.getEndTime()) {
                bl = true;
            }
        }
        return bl;
    }

    public static native void init();

    public static native SocketEvent getSocketEvent();

    @Deprecated
    void a() {
    }

    static {
        System.loadLibrary("nbsdc-jni1.1.0");
    }
}

