/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import com.networkbench.agent.impl.api.a.b;
import com.networkbench.agent.impl.d.c;
import com.networkbench.agent.impl.d.d;
import com.networkbench.agent.impl.h.l;
import com.networkbench.agent.impl.h.m;
import com.networkbench.agent.impl.harvest.HttpLibType;
import com.networkbench.agent.impl.harvest.RequestMethodType;
import com.networkbench.agent.impl.instrumentation.NBSTraceEngine;
import com.networkbench.agent.impl.j.am;
import com.networkbench.agent.impl.l.a.h;
import com.networkbench.agent.impl.tracing.SocketEvent;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

public final class NBSTransactionState {
    private static final c log = d.a();
    private String url;
    private String methodType;
    private int statusCode;
    private int errorCode;
    private long bytesSent;
    private long bytesReceived;
    private long startTime;
    private long endTime;
    private String appData;
    private String carrier = "Other";
    private a state;
    private String contentType;
    private b transactionData;
    private String exception = null;
    private String formattedUrlParams = null;
    private String urlParams = null;
    private h urlBuilder = new h();
    private boolean inQueue = false;
    private RequestMethodType requestMethod;
    private HttpLibType httpLibType;
    private int tyIdRandomInt;

    public void setRequestMethod(RequestMethodType request) {
        this.requestMethod = request;
    }

    public String getRequestMethod() {
        return this.requestMethod.name();
    }

    public RequestMethodType getRequestMethodType() {
        return this.requestMethod;
    }

    public String getUrlParams() {
        return this.urlParams;
    }

    public void setUrlParams(String urlParams) {
        this.urlParams = urlParams;
    }

    public String getFormattedUrlParams() {
        return this.formattedUrlParams;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setFormattedUrlParams(String formattedUrlParams) {
        this.formattedUrlParams = formattedUrlParams;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("url:" + this.url);
        stringBuilder.append("statusCode:" + this.statusCode);
        stringBuilder.append("errorCode:" + this.errorCode);
        stringBuilder.append("bytesSent:" + this.bytesSent);
        stringBuilder.append("bytesReceived:" + this.bytesReceived);
        stringBuilder.append("startTime:" + this.startTime);
        stringBuilder.append("endTime:" + this.endTime);
        stringBuilder.append("appData:" + this.appData);
        stringBuilder.append("carrier:" + this.carrier);
        stringBuilder.append("state:" + this.state.ordinal());
        stringBuilder.append("contentType:" + this.contentType);
        if (this.transactionData != null) {
            stringBuilder.append("trancastionData:" + this.transactionData.toString());
        }
        if (this.formattedUrlParams != null) {
            stringBuilder.append("formattedUrlParams:" + this.formattedUrlParams);
        }
        stringBuilder.append("Requestmethodtype:" + (Object)((Object)this.requestMethod));
        stringBuilder.append("httplibType:" + (Object)((Object)this.httpLibType));
        stringBuilder.append("urlBuilder:" + this.urlBuilder);
        return stringBuilder.toString();
    }

    public NBSTransactionState() {
        this.startTime = System.currentTimeMillis();
        this.state = a.a;
        this.errorCode = com.networkbench.agent.impl.l.b.b.a.a();
        this.requestMethod = RequestMethodType.GET;
        this.httpLibType = HttpLibType.URLConnection;
        NBSTraceEngine.enterNetworkSegment("External/unknownhost");
    }

    public NBSTransactionState(String x5) {
        this.startTime = System.currentTimeMillis();
        this.state = a.a;
        this.errorCode = com.networkbench.agent.impl.l.b.b.a.a();
        this.requestMethod = RequestMethodType.GET;
        this.httpLibType = HttpLibType.URLConnection;
    }

    public a getState() {
        return this.state;
    }

    public void setState(int st) {
        if (st == a.a.ordinal()) {
            this.state = a.a;
        } else if (st == a.b.ordinal()) {
            this.state = a.b;
        } else if (st == a.c.ordinal()) {
            this.state = a.c;
        }
    }

    public void setCarrier(String carrier) {
        if (!this.isSent()) {
            this.carrier = carrier;
            NBSTraceEngine.setCurrentTraceParam("carrier", carrier);
        } else {
            log.e("setCarrier(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void setAppData(String appData) {
        if (!this.isComplete()) {
            this.appData = appData;
            if ("".equals(appData)) {
                return;
            }
            try {
                JSONObject jSONObject = new JSONObject(appData);
                int n2 = jSONObject.getInt("r");
                if (this.getTyIdRandomInt() != 0 && n2 == this.getTyIdRandomInt()) {
                    NBSTraceEngine.setCurrentTraceParam("txData", appData);
                } else if (this.getTyIdRandomInt() == 0) {
                    NBSTraceEngine.setCurrentTraceParam("txData", appData);
                }
            }
            catch (JSONException jSONException) {
                log.a("setAppData:", jSONException);
            }
            catch (Exception exception) {
                log.a("setAppData:", exception);
            }
        } else {
            log.e("setAppData(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public String getAppData() {
        return this.appData;
    }

    public String getMethodType() {
        return this.methodType;
    }

    public void setMethodType(String methodType) {
        this.methodType = methodType;
    }

    public void setAddress(InetAddress address) {
        this.urlBuilder.a(address);
    }

    public void setPort(int port) {
        this.urlBuilder.a(port);
    }

    public void setHttpPath(String httpPath) {
        this.urlBuilder.b(httpPath);
    }

    public void setScheme(h.a scheme) {
        this.urlBuilder.a(scheme);
    }

    public String getScheme() {
        return this.urlBuilder.b().a();
    }

    public String getHttpPath() {
        return this.urlBuilder.a();
    }

    public void setHost(String host) {
        this.urlBuilder.a(host);
    }

    public void setUrlValue(String url) {
        this.url = url == null ? "" : url;
    }

    public void setUrl(String urlString) {
        String string = am.a(urlString);
        if (string == null) {
            return;
        }
        if (!this.isSent()) {
            this.url = string;
            try {
                String string2 = new URL(string).getHost();
                NBSTraceEngine.setCurrentDisplayName("External/" + string2);
                try {
                    SocketEvent socketEvent;
                    SocketEvent socketEvent2 = com.networkbench.agent.impl.h.b.a(new l(m.m, string2));
                    if (null != socketEvent2) {
                        socketEvent2.setIsHttp(true);
                    }
                    if (null != (socketEvent = com.networkbench.agent.impl.h.b.a(new l(m.c, string2)))) {
                        socketEvent.setIsHttp(true);
                    }
                }
                catch (Exception exception) {
                    log.a("load .so error");
                }
            }
            catch (MalformedURLException malformedURLException) {
                log.d("unable to parse host name from " + string);
            }
            NBSTraceEngine.setCurrentTraceParam("url", string);
        } else {
            log.e("setUrl(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSent() {
        return this.state.ordinal() >= a.b.ordinal();
    }

    public boolean isComplete() {
        return this.state.ordinal() >= a.c.ordinal();
    }

    public void setStatusCode(int statusCode) {
        if (!this.isComplete()) {
            this.statusCode = statusCode;
            if (statusCode == 200) {
                NBSTraceEngine.setCurrentTraceParam("httpStatus", statusCode);
                log.c("set status code:" + statusCode);
            }
        } else {
            this.statusCode = statusCode;
            log.e("setStatusCode(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void markAsEnqueue() {
        this.inQueue = true;
    }

    public boolean ifInQueue() {
        return this.inQueue;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isError() {
        return this.statusCode >= 400 || this.statusCode == -1;
    }

    public void setErrorCode(int errorCode, String exception) {
        if (!this.isComplete()) {
            this.errorCode = errorCode;
            this.exception = exception;
            log.a("errorCode:" + this.errorCode + ", errorInfo:" + this.exception);
            NBSTraceEngine.setCurrentTraceParam("errorCode", errorCode);
        } else {
            if (this.transactionData != null) {
                this.transactionData.b(errorCode);
            }
            log.e("setErrorCode(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(long bytesSent) {
        if (!this.isComplete()) {
            log.c(bytesSent + " bytes sent");
            this.bytesSent = bytesSent;
            NBSTraceEngine.setCurrentTraceParam("bytesSent", bytesSent);
            this.state = a.b;
        } else {
            log.e("setBytesSent(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void setBytesSentAfterComplete(long bytesSent) {
        log.c("After Complete " + bytesSent + " bytes sent.");
        this.bytesSent = bytesSent;
        this.state = a.b;
    }

    public void setBytesReceived(long bytesReceived) {
        if (!this.isComplete()) {
            this.bytesReceived = bytesReceived;
            log.c(bytesReceived + "bytes received");
            NBSTraceEngine.setCurrentTraceParam("bytesReceived", bytesReceived);
        } else {
            log.e("setBytesReceived(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public HttpLibType getHttpLibType() {
        return this.httpLibType;
    }

    public void setHttpLibType(HttpLibType httpLibType) {
        this.httpLibType = httpLibType;
    }

    public b end() {
        if (!this.isComplete()) {
            this.state = a.c;
            this.endTime = System.currentTimeMillis();
            NBSTraceEngine.exitMethod();
        }
        return this.toTransactionData();
    }

    private b toTransactionData() {
        if (!this.isComplete()) {
            log.e("toTransactionData() called on incomplete TransactionState");
        }
        if (this.url == null) {
            log.d("Attempted to convert a TransactionState instance with no URL into a TransactionData");
            return null;
        }
        if (this.transactionData == null) {
            this.transactionData = new b(this.url, this.carrier, (int)(this.endTime - this.startTime), this.statusCode, this.errorCode, this.bytesSent, this.bytesReceived, this.appData, this.formattedUrlParams, this.urlParams, this.requestMethod, this.httpLibType);
        }
        return this.transactionData;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public int getTyIdRandomInt() {
        return this.tyIdRandomInt;
    }

    public void setTyIdRandomInt(int tyIdRandomInt) {
        this.tyIdRandomInt = tyIdRandomInt;
    }

    private static enum a {
        a,
        b,
        c;

    }
}

