/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import com.networkbench.agent.impl.api.v2.ISystemTrace;
import com.networkbench.agent.impl.api.v2.TraceFieldInterface;
import com.networkbench.agent.impl.d.c;
import com.networkbench.agent.impl.d.d;
import com.networkbench.agent.impl.e.j;
import com.networkbench.agent.impl.harvest.Harvest;
import com.networkbench.agent.impl.harvest.HarvestAdapter;
import com.networkbench.agent.impl.instrumentation.NBSTraceUnit;
import com.networkbench.agent.impl.j.ah;
import com.networkbench.agent.impl.tracing.ActivityTrace;
import com.networkbench.agent.impl.tracing.TraceLifecycleAware;
import com.networkbench.agent.impl.tracing.TraceType;
import com.networkbench.agent.impl.tracing.TracingInactiveException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;

public class NBSTraceEngine
extends HarvestAdapter {
    public static final String NBS_TRACE_FIELD = "_nbs_trace";
    public static final String NBS_TRACE_TYPE = "Lcom/networkbench/agent/impl/tracing/Trace;";
    private static final c log = d.a();
    public static final int HEALTHY_TRACE_TIMEOUT = 500;
    public static final int UNHEALTHY_TRACE_TIMEOUT = 60000;
    private static final Collection<TraceLifecycleAware> traceListeners = new CopyOnWriteArrayList<TraceLifecycleAware>();
    private static ThreadLocal<NBSTraceUnit> threadLocalTrace = new ThreadLocal();
    private static ThreadLocal<a> threadLocalTraceStack = new ThreadLocal();
    private static NBSTraceEngine tracer = null;
    private static ISystemTrace systemTrace;
    private ActivityTrace activityTrace;

    protected NBSTraceEngine(NBSTraceUnit rootTrace) {
        this.activityTrace = new ActivityTrace(rootTrace);
        Harvest.addHarvestListener(this);
    }

    public static NBSTraceEngine getTraceMachine() {
        return tracer;
    }

    public static void addTraceListener(TraceLifecycleAware listener) {
        traceListeners.add(listener);
    }

    public static void removeTraceListener(TraceLifecycleAware listener) {
        traceListeners.remove(listener);
    }

    public static void setSystemTrace(ISystemTrace systemTrace) {
        NBSTraceEngine.systemTrace = systemTrace;
    }

    public static void startTracing(String name) {
        log.c("startTracing");
        try {
            if (!Harvest.shouldCollectActivityTraces()) {
                log.a("not collect data");
                return;
            }
            NBSTraceUnit nBSTraceUnit = new NBSTraceUnit();
            nBSTraceUnit.metricName = NBSTraceEngine.formatActivityMetricName(name);
            nBSTraceUnit.metricBackgroundName = NBSTraceEngine.formatActivityBackgroundMetricName(name);
            nBSTraceUnit.displayName = name;
            nBSTraceUnit.entryTimestamp = System.currentTimeMillis();
            log.c("Started trace of " + name + ":" + nBSTraceUnit.myUUID.toString());
            if (NBSTraceEngine.isTracingActive()) {
                tracer.completeActivityTrace();
            }
            threadLocalTrace.remove();
            threadLocalTraceStack.set(new a());
            nBSTraceUnit.tracer = tracer = new NBSTraceEngine(nBSTraceUnit);
            NBSTraceEngine.pushTraceContext(nBSTraceUnit);
            for (TraceLifecycleAware traceLifecycleAware : traceListeners) {
                traceLifecycleAware.onTraceStart(NBSTraceEngine.tracer.activityTrace);
            }
        }
        catch (Throwable throwable) {
            log.a("Caught error while initializing Tracer, shutting it down", throwable);
            tracer = null;
            threadLocalTrace.remove();
            threadLocalTraceStack.remove();
        }
    }

    public static void enterMethod(String name) {
        NBSTraceEngine.enterMethod(null, name, null);
    }

    public static void enterMethod(String name, ArrayList<String> annotationParams) {
        NBSTraceEngine.enterMethod(null, name, annotationParams);
    }

    public static void enterMethod(NBSTraceUnit trace, String name, ArrayList<String> annotationParams) {
        try {
            if (NBSTraceEngine.isTracingInactive()) {
                return;
            }
            long l2 = System.currentTimeMillis();
            long l3 = NBSTraceEngine.tracer.activityTrace.lastUpdatedAt;
            long l4 = NBSTraceEngine.tracer.activityTrace.startedAt;
            if (l3 + 500L < l2 && !NBSTraceEngine.tracer.activityTrace.hasMissingChildren()) {
                log.e("Completing activity trace after hitting healthy timeout (500ms)");
                tracer.completeActivityTrace();
                return;
            }
            if (l4 + 60000L < l2) {
                log.e("Completing activity trace after hitting unhealthy timeout (60000ms)");
                tracer.completeActivityTrace();
                return;
            }
            NBSTraceEngine.loadTraceContext(trace);
            NBSTraceUnit nBSTraceUnit = NBSTraceEngine.registerNewTrace(name);
            NBSTraceEngine.pushTraceContext(nBSTraceUnit);
            nBSTraceUnit.scope = NBSTraceEngine.getCurrentScope();
            nBSTraceUnit.setAnnotationParams(annotationParams);
            for (TraceLifecycleAware traceLifecycleAware : traceListeners) {
                traceLifecycleAware.onEnterMethod();
            }
            nBSTraceUnit.entryTimestamp = System.currentTimeMillis();
        }
        catch (TracingInactiveException tracingInactiveException) {
            log.d("tracing inactive!");
        }
        catch (Throwable throwable) {
            log.a("Caught error while calling enterMethod()", throwable);
        }
    }

    private static NBSTraceUnit registerNewTrace(String name) throws TracingInactiveException {
        if (NBSTraceEngine.isTracingInactive()) {
            log.e("Tried to register a new trace but tracing is inactive!");
            throw new TracingInactiveException();
        }
        NBSTraceUnit nBSTraceUnit = NBSTraceEngine.getCurrentTrace();
        NBSTraceUnit nBSTraceUnit2 = new NBSTraceUnit(name, nBSTraceUnit.myUUID, tracer);
        nBSTraceUnit2.metricName = NBSTraceEngine.formatActivityMetricName(name);
        try {
            NBSTraceEngine.tracer.activityTrace.addTrace(nBSTraceUnit2);
        }
        catch (Exception exception) {
            throw new TracingInactiveException();
        }
        log.c("Registering trace of " + name + " with parent UUID" + nBSTraceUnit.myUUID);
        nBSTraceUnit.addChild(nBSTraceUnit2);
        return nBSTraceUnit2;
    }

    public static void exitMethod() {
        log.c("exitMethod");
        try {
            if (NBSTraceEngine.isTracingInactive()) {
                return;
            }
            NBSTraceUnit nBSTraceUnit = threadLocalTrace.get();
            if (nBSTraceUnit == null) {
                log.e("threadLocalTrace is null");
                return;
            }
            nBSTraceUnit.exitTimestamp = System.currentTimeMillis();
            if (nBSTraceUnit.threadId == 0L && systemTrace != null) {
                nBSTraceUnit.threadId = systemTrace.getCurrentThreadId();
                nBSTraceUnit.threadName = systemTrace.getCurrentThreadName();
            }
            for (TraceLifecycleAware traceLifecycleAware : traceListeners) {
                traceLifecycleAware.onExitMethod();
            }
            try {
                nBSTraceUnit.complete();
            }
            catch (TracingInactiveException tracingInactiveException) {
                threadLocalTrace.remove();
                threadLocalTraceStack.remove();
                if (nBSTraceUnit.getType() == TraceType.TRACE) {
                    ah.a(nBSTraceUnit);
                }
                return;
            }
            threadLocalTraceStack.get().pop();
            if (threadLocalTraceStack.get().empty()) {
                threadLocalTrace.set(null);
            } else {
                NBSTraceUnit nBSTraceUnit2 = (NBSTraceUnit)threadLocalTraceStack.get().peek();
                threadLocalTrace.set(nBSTraceUnit2);
                nBSTraceUnit2.childExclusiveTime += nBSTraceUnit.getDuration();
            }
            if (nBSTraceUnit.getType() == TraceType.TRACE) {
                ah.a(nBSTraceUnit);
            }
        }
        catch (Throwable throwable) {
            log.a("Caught error while calling exitMethod()", throwable);
        }
    }

    public static void haltTracing() {
        if (NBSTraceEngine.isTracingInactive()) {
            return;
        }
        tracer.completeActivityTrace();
        threadLocalTrace.remove();
        threadLocalTraceStack.remove();
    }

    public static String formatActivityMetricName(String name) {
        return "MobileView/Activity/" + name;
    }

    public static String formatActivityBackgroundMetricName(String name) {
        return "MobileView/Background/" + name;
    }

    private void completeActivityTrace() {
        log.c("completeActivityTrace");
        NBSTraceEngine nBSTraceEngine = tracer;
        tracer = null;
        for (TraceLifecycleAware traceLifecycleAware : traceListeners) {
            traceLifecycleAware.onTraceComplete(nBSTraceEngine.activityTrace);
        }
        nBSTraceEngine.activityTrace.complete();
        Harvest.removeHarvestListener(nBSTraceEngine);
    }

    public static void enterNetworkSegment(String name) {
        try {
            if (NBSTraceEngine.isTracingInactive()) {
                return;
            }
            NBSTraceUnit nBSTraceUnit = NBSTraceEngine.getCurrentTrace();
            log.c("currentTrace info:" + nBSTraceUnit.toString());
            if (nBSTraceUnit.getType() == TraceType.NETWORK) {
                NBSTraceEngine.exitMethod();
            }
            NBSTraceEngine.enterMethod(null, name, null);
            NBSTraceUnit nBSTraceUnit2 = NBSTraceEngine.getCurrentTrace();
            nBSTraceUnit2.setType(TraceType.NETWORK);
        }
        catch (TracingInactiveException tracingInactiveException) {
            log.d("tracing inactive!");
        }
        catch (Throwable throwable) {
            log.a("Caught error while calling enterNetworkSegment()", throwable);
        }
    }

    private static void pushTraceContext(NBSTraceUnit trace) {
        if (NBSTraceEngine.isTracingInactive() || trace == null) {
            return;
        }
        a a2 = threadLocalTraceStack.get();
        if (a2.empty()) {
            a2.push(trace);
        } else if (a2.peek() != trace) {
            a2.push(trace);
        }
        threadLocalTrace.set(trace);
    }

    private static void loadTraceContext(NBSTraceUnit trace) {
        if (NBSTraceEngine.isTracingInactive()) {
            return;
        }
        if (threadLocalTrace.get() == null) {
            threadLocalTrace.set(trace);
            threadLocalTraceStack.set(new a());
            if (trace == null) {
                return;
            }
            threadLocalTraceStack.get().push(trace);
        } else if (trace == null) {
            if (threadLocalTraceStack.get().isEmpty()) {
                threadLocalTrace.set(null);
                return;
            }
            trace = (NBSTraceUnit)threadLocalTraceStack.get().peek();
            threadLocalTrace.set(trace);
        }
        log.c("Trace " + trace.myUUID.toString() + " is now active");
    }

    public static void unloadTraceContext(Object object) {
        try {
            if (NBSTraceEngine.isTracingInactive()) {
                return;
            }
            if (systemTrace != null && systemTrace.isUIThread()) {
                return;
            }
            if (threadLocalTrace.get() != null) {
                // empty if block
            }
            threadLocalTrace.remove();
            threadLocalTraceStack.remove();
            ((TraceFieldInterface)object)._nbs_setTrace(null);
        }
        catch (Throwable throwable) {
            log.a("Caught error while calling unloadTraceContext()", throwable);
        }
    }

    public static NBSTraceUnit getCurrentTrace() throws TracingInactiveException {
        if (NBSTraceEngine.isTracingInactive()) {
            throw new TracingInactiveException();
        }
        NBSTraceUnit nBSTraceUnit = threadLocalTrace.get();
        if (nBSTraceUnit != null) {
            return nBSTraceUnit;
        }
        return NBSTraceEngine.getRootTrace();
    }

    public static Map<String, Object> getCurrentTraceParams() throws TracingInactiveException {
        return NBSTraceEngine.getCurrentTrace().getParams();
    }

    public static void setCurrentTraceParam(String key, Object value) {
        if (NBSTraceEngine.isTracingInactive()) {
            return;
        }
        try {
            NBSTraceUnit nBSTraceUnit = NBSTraceEngine.getCurrentTrace();
            log.c("current trace before setparams:" + nBSTraceUnit.toString());
            log.c("key:" + key + ", value:" + value);
            if (value != null) {
                NBSTraceEngine.getCurrentTrace().getParams().put(key, value);
            }
            log.c("current trace after setparams:" + nBSTraceUnit.toString());
        }
        catch (TracingInactiveException tracingInactiveException) {
            // empty catch block
        }
    }

    public static void setCurrentDisplayName(String name) {
        if (NBSTraceEngine.isTracingInactive()) {
            return;
        }
        try {
            NBSTraceEngine.getCurrentTrace().displayName = name;
        }
        catch (TracingInactiveException tracingInactiveException) {
            // empty catch block
        }
    }

    public static void setRootDisplayName(String name) {
        if (NBSTraceEngine.isTracingInactive()) {
            return;
        }
        try {
            NBSTraceUnit nBSTraceUnit = NBSTraceEngine.getRootTrace();
            j.a(nBSTraceUnit.displayName, name);
            nBSTraceUnit.metricName = NBSTraceEngine.formatActivityMetricName(name);
            nBSTraceUnit.metricBackgroundName = NBSTraceEngine.formatActivityBackgroundMetricName(name);
            nBSTraceUnit.displayName = name;
            NBSTraceUnit nBSTraceUnit2 = NBSTraceEngine.getCurrentTrace();
            nBSTraceUnit2.scope = NBSTraceEngine.getCurrentScope();
        }
        catch (TracingInactiveException tracingInactiveException) {
            // empty catch block
        }
    }

    public static String getCurrentScope() {
        try {
            if (NBSTraceEngine.isTracingInactive()) {
                return null;
            }
            if (systemTrace == null || systemTrace.isUIThread()) {
                return NBSTraceEngine.tracer.activityTrace.rootTrace.metricName;
            }
            return NBSTraceEngine.tracer.activityTrace.rootTrace.metricBackgroundName;
        }
        catch (Throwable throwable) {
            log.a("Caught error while calling getCurrentScope()", throwable);
            return null;
        }
    }

    public static boolean isTracingActive() {
        return tracer != null;
    }

    public static boolean isTracingInactive() {
        return tracer == null;
    }

    public void storeCompletedTrace(NBSTraceUnit trace) {
        try {
            if (NBSTraceEngine.isTracingInactive()) {
                return;
            }
            this.activityTrace.addCompletedTrace(trace);
        }
        catch (Throwable throwable) {
            log.a("Caught error while calling storeCompletedTrace()", throwable);
        }
    }

    public static NBSTraceUnit getRootTrace() throws TracingInactiveException {
        try {
            return NBSTraceEngine.tracer.activityTrace.rootTrace;
        }
        catch (NullPointerException nullPointerException) {
            throw new TracingInactiveException();
        }
    }

    public static ActivityTrace getActivityTrace() throws TracingInactiveException {
        try {
            return NBSTraceEngine.tracer.activityTrace;
        }
        catch (NullPointerException nullPointerException) {
            throw new TracingInactiveException();
        }
    }

    @Override
    public void onHarvestBefore() {
        if (NBSTraceEngine.isTracingActive()) {
            long l2 = System.currentTimeMillis();
            long l3 = NBSTraceEngine.tracer.activityTrace.lastUpdatedAt;
            long l4 = NBSTraceEngine.tracer.activityTrace.startedAt;
            if (l3 + 500L < l2 && !NBSTraceEngine.tracer.activityTrace.hasMissingChildren()) {
                this.completeActivityTrace();
                return;
            }
            if (l4 + 60000L < l2) {
                this.completeActivityTrace();
                return;
            }
        }
    }

    @Override
    public void onHarvestSendFailed() {
        try {
            NBSTraceEngine.tracer.activityTrace.incrementReportAttemptCount();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static class a
    extends Stack<NBSTraceUnit> {
        private static final long a = -2599047099967913529L;

        private a() {
        }
    }
}

