/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import com.networkbench.agent.impl.harvest.type.MetricCategory;
import com.networkbench.agent.impl.instrumentation.NBSReplaceCallSite;
import com.networkbench.agent.impl.instrumentation.NBSTraceEngine;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class NBSObjectInstrumentation {
    private static final ArrayList<String> categoryParams = new ArrayList<String>(Arrays.asList("category", MetricCategory.class.getName(), "JSON"));

    public static JSONObject init(String json) throws JSONException {
        JSONObject jSONObject;
        try {
            NBSTraceEngine.enterMethod(null, "JSONObject#<init>", categoryParams);
            jSONObject = new JSONObject(json);
            NBSTraceEngine.exitMethod();
        }
        catch (JSONException jSONException) {
            NBSTraceEngine.exitMethod();
            throw jSONException;
        }
        return jSONObject;
    }

    @NBSReplaceCallSite(scope="org.json.JSONObject")
    public static String toString(JSONObject jsonObject) {
        NBSTraceEngine.enterMethod(null, "JSONObject#toString", categoryParams);
        String string = jsonObject.toString();
        NBSTraceEngine.exitMethod();
        return string;
    }

    @NBSReplaceCallSite(scope="org.json.JSONObject")
    public static String toString(JSONObject jsonObject, int indentFactor) throws JSONException {
        String string;
        NBSTraceEngine.enterMethod(null, "JSONObject#toString", categoryParams);
        try {
            string = jsonObject.toString(indentFactor);
            NBSTraceEngine.exitMethod();
        }
        catch (JSONException jSONException) {
            NBSTraceEngine.exitMethod();
            throw jSONException;
        }
        return string;
    }

    @Deprecated
    void a() {
    }
}

