/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import com.networkbench.agent.impl.harvest.type.MetricCategory;
import com.networkbench.agent.impl.instrumentation.NBSReplaceCallSite;
import com.networkbench.agent.impl.instrumentation.NBSTraceEngine;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;

public class NBSJSONArrayInstrumentation {
    private static final ArrayList<String> categoryParams = new ArrayList<String>(Arrays.asList("category", MetricCategory.class.getName(), "JSON"));

    public static JSONArray init(String json) throws JSONException {
        JSONArray jSONArray;
        try {
            NBSTraceEngine.enterMethod("JSONArray#<init>", categoryParams);
            jSONArray = new JSONArray(json);
            NBSTraceEngine.exitMethod();
        }
        catch (JSONException jSONException) {
            NBSTraceEngine.exitMethod();
            throw jSONException;
        }
        return jSONArray;
    }

    @NBSReplaceCallSite(scope="org.json.JSONArray")
    public static String toString(JSONArray jsonArray) {
        NBSTraceEngine.enterMethod("JSONArray#toString", categoryParams);
        String string = jsonArray.toString();
        NBSTraceEngine.exitMethod();
        return string;
    }

    @NBSReplaceCallSite(scope="org.json.JSONArray")
    public static String toString(JSONArray jsonArray, int indentFactor) throws JSONException {
        String string;
        try {
            NBSTraceEngine.enterMethod("JSONArray#toString", categoryParams);
            string = jsonArray.toString(indentFactor);
            NBSTraceEngine.exitMethod();
        }
        catch (JSONException jSONException) {
            NBSTraceEngine.exitMethod();
            throw jSONException;
        }
        return string;
    }

    @Deprecated
    void a() {
    }
}

