/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import com.networkbench.agent.impl.NBSAgent;
import com.networkbench.agent.impl.api.a.b;
import com.networkbench.agent.impl.d.c;
import com.networkbench.agent.impl.d.d;
import com.networkbench.agent.impl.e.b.a;
import com.networkbench.agent.impl.e.j;
import com.networkbench.agent.impl.harvest.HarvestConfiguration;
import com.networkbench.agent.impl.harvest.HttpLibType;
import com.networkbench.agent.impl.instrumentation.NBSTransactionState;
import com.networkbench.agent.impl.instrumentation.NBSTransactionStateUtil;
import com.networkbench.agent.impl.instrumentation.io.NBSCountingInputStream;
import com.networkbench.agent.impl.instrumentation.io.NBSCountingOutputStream;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteEvent;
import com.networkbench.agent.impl.instrumentation.io.NBSStreamCompleteListener;
import com.networkbench.agent.impl.j.ah;
import com.networkbench.agent.impl.j.al;
import com.networkbench.agent.impl.j.n;
import com.networkbench.agent.impl.j.z;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.util.List;
import java.util.Map;

public class NBSHttpURLConnectionExtension
extends HttpURLConnection {
    private HttpURLConnection impl;
    private NBSTransactionState transactionState;
    private static final c log = d.a();
    NBSCountingInputStream a;

    public NBSHttpURLConnectionExtension(HttpURLConnection impl) {
        super(impl.getURL());
        this.impl = impl;
        NBSTransactionStateUtil.setCrossProcessHeader(impl);
    }

    @Override
    public void addRequestProperty(String field, String newValue) {
        this.impl.addRequestProperty(field, newValue);
    }

    @Override
    public void disconnect() {
        if (this.transactionState != null && !this.transactionState.isComplete()) {
            this.addTransactionAndErrorData(this.transactionState);
        }
        this.impl.disconnect();
    }

    @Override
    public boolean usingProxy() {
        return this.impl.usingProxy();
    }

    @Override
    public void connect() throws IOException {
        this.getTransactionState();
        try {
            this.impl.connect();
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.impl.getAllowUserInteraction();
    }

    @Override
    public int getConnectTimeout() {
        return this.impl.getConnectTimeout();
    }

    @Override
    public Object getContent() throws IOException {
        NBSTransactionState nBSTransactionState;
        Object object;
        this.getTransactionState();
        try {
            object = this.impl.getContent();
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        int n2 = this.impl.getContentLength();
        if (n2 >= 0 && !(nBSTransactionState = this.getTransactionState()).isComplete()) {
            nBSTransactionState.setBytesReceived(n2);
            this.addTransactionAndErrorData(nBSTransactionState);
        }
        return object;
    }

    public Object getContent(Class[] types) throws IOException {
        Object object;
        this.getTransactionState();
        try {
            object = this.impl.getContent(types);
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        this.checkResponse();
        return object;
    }

    @Override
    public String getContentEncoding() {
        this.getTransactionState();
        String string = this.impl.getContentEncoding();
        this.checkResponse();
        return string;
    }

    @Override
    public int getContentLength() {
        this.getTransactionState();
        int n2 = this.impl.getContentLength();
        this.checkResponse();
        return n2;
    }

    @Override
    public String getContentType() {
        this.getTransactionState();
        String string = this.impl.getContentType();
        this.checkResponse();
        return string;
    }

    @Override
    public long getDate() {
        this.getTransactionState();
        long l2 = this.impl.getDate();
        this.checkResponse();
        return l2;
    }

    @Override
    public long getHeaderFieldDate(String field, long defaultValue) {
        this.getTransactionState();
        long l2 = this.impl.getHeaderFieldDate(field, defaultValue);
        this.checkResponse();
        return l2;
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.impl.getInstanceFollowRedirects();
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.impl.getPermission();
    }

    @Override
    public String getRequestMethod() {
        NBSTransactionState nBSTransactionState = this.getTransactionState();
        String string = this.impl.getRequestMethod();
        NBSTransactionStateUtil.setRequestMethod(nBSTransactionState, string);
        this.transactionState.setHttpLibType(HttpLibType.URLConnection);
        return string;
    }

    @Override
    public int getResponseCode() throws IOException {
        int n2;
        this.getTransactionState();
        try {
            n2 = this.impl.getResponseCode();
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        this.checkResponse();
        return n2;
    }

    @Override
    public String getResponseMessage() throws IOException {
        String string;
        this.getTransactionState();
        try {
            string = this.impl.getResponseMessage();
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        this.checkResponse();
        return string;
    }

    @Override
    public void setChunkedStreamingMode(int chunkLength) {
        this.impl.setChunkedStreamingMode(chunkLength);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.impl.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.impl.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.getTransactionState();
        try {
            this.impl.setRequestMethod(method);
            this.transactionState.setMethodType(method);
            this.transactionState.setHttpLibType(HttpLibType.URLConnection);
            NBSTransactionStateUtil.setRequestMethod(this.getTransactionState(), method);
        }
        catch (ProtocolException protocolException) {
            this.error(protocolException);
            throw protocolException;
        }
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.impl.getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return this.impl.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this.impl.getDoOutput();
    }

    @Override
    public long getExpiration() {
        this.getTransactionState();
        long l2 = this.impl.getExpiration();
        this.checkResponse();
        return l2;
    }

    @Override
    public String getHeaderField(int pos) {
        this.getTransactionState();
        String string = this.impl.getHeaderField(pos);
        this.checkResponse();
        return string;
    }

    @Override
    public String getHeaderField(String key) {
        this.getTransactionState();
        String string = this.impl.getHeaderField(key);
        this.checkResponse();
        return string;
    }

    @Override
    public int getHeaderFieldInt(String field, int defaultValue) {
        this.getTransactionState();
        int n2 = this.impl.getHeaderFieldInt(field, defaultValue);
        this.checkResponse();
        return n2;
    }

    @Override
    public String getHeaderFieldKey(int posn) {
        this.getTransactionState();
        String string = this.impl.getHeaderFieldKey(posn);
        this.checkResponse();
        return string;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        this.getTransactionState();
        Map<String, List<String>> map = this.impl.getHeaderFields();
        this.checkResponse();
        return map;
    }

    @Override
    public long getIfModifiedSince() {
        this.getTransactionState();
        long l2 = this.impl.getIfModifiedSince();
        this.checkResponse();
        return l2;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        final NBSTransactionState nBSTransactionState = this.getTransactionState();
        NBSCountingInputStream nBSCountingInputStream = null;
        try {
            nBSCountingInputStream = new NBSCountingInputStream(this.impl.getInputStream());
            NBSTransactionStateUtil.inspectAndInstrumentResponse(nBSTransactionState, this.impl);
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        if (nBSCountingInputStream != null) {
            nBSCountingInputStream.addStreamCompleteListener(new NBSStreamCompleteListener(){

                @Override
                public void streamError(NBSStreamCompleteEvent e2) {
                    log.d("streamError:" + e2.toString());
                    if (!nBSTransactionState.isComplete()) {
                        nBSTransactionState.setBytesReceived(e2.getBytes());
                    }
                    try {
                        int n2 = NBSHttpURLConnectionExtension.this.impl.getResponseCode();
                        nBSTransactionState.setStatusCode(n2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    NBSHttpURLConnectionExtension.this.error(e2.getException());
                }

                @Override
                public void streamComplete(NBSStreamCompleteEvent e2) {
                    if (!nBSTransactionState.isComplete()) {
                        long l2 = NBSHttpURLConnectionExtension.this.impl.getContentLength();
                        long l3 = e2.getBytes();
                        if (l2 >= 0L) {
                            l3 = l2;
                        }
                        nBSTransactionState.setBytesReceived(l3);
                        try {
                            int n2 = NBSHttpURLConnectionExtension.this.impl.getResponseCode();
                            nBSTransactionState.setStatusCode(n2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        NBSHttpURLConnectionExtension.this.addTransactionAndErrorData(nBSTransactionState);
                    }
                }
            });
        }
        return nBSCountingInputStream;
    }

    @Override
    public InputStream getErrorStream() {
        this.getTransactionState();
        if (this.a != null) {
            return this.a;
        }
        try {
            this.a = new NBSCountingInputStream(this.impl.getErrorStream(), true);
        }
        catch (Exception exception) {
            log.d(exception.toString());
            return this.impl.getErrorStream();
        }
        this.a.addStreamCompleteListener(new NBSStreamCompleteListener(){

            @Override
            public void streamError(NBSStreamCompleteEvent e2) {
                log.d("streamError:" + e2.toString());
                if (!NBSHttpURLConnectionExtension.this.transactionState.isComplete()) {
                    NBSHttpURLConnectionExtension.this.transactionState.setBytesReceived(e2.getBytes());
                }
                NBSHttpURLConnectionExtension.this.error(e2.getException());
            }

            @Override
            public void streamComplete(NBSStreamCompleteEvent e2) {
                if (!NBSHttpURLConnectionExtension.this.transactionState.isComplete()) {
                    HttpURLConnection httpURLConnection = NBSHttpURLConnectionExtension.this.impl;
                    long l2 = httpURLConnection.getContentLength();
                    long l3 = e2.getBytes();
                    if (l2 >= 0L) {
                        l3 = l2;
                    }
                    try {
                        int n2 = httpURLConnection.getResponseCode();
                        NBSHttpURLConnectionExtension.this.transactionState.setStatusCode(n2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    NBSHttpURLConnectionExtension.this.transactionState.setBytesReceived(l3);
                    NBSHttpURLConnectionExtension.this.addTransactionAndErrorData(NBSHttpURLConnectionExtension.this.transactionState);
                }
            }
        });
        return this.a;
    }

    @Override
    public long getLastModified() {
        this.getTransactionState();
        long l2 = this.impl.getLastModified();
        this.checkResponse();
        return l2;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        NBSCountingOutputStream nBSCountingOutputStream;
        try {
            nBSCountingOutputStream = new NBSCountingOutputStream(this.impl.getOutputStream());
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw iOException;
        }
        if (nBSCountingOutputStream != null) {
            nBSCountingOutputStream.addStreamCompleteListener(new NBSStreamCompleteListener(){

                @Override
                public void streamError(NBSStreamCompleteEvent e2) {
                    NBSTransactionState nBSTransactionState = NBSHttpURLConnectionExtension.this.getTransactionState();
                    if (!nBSTransactionState.isComplete()) {
                        nBSTransactionState.setBytesSent(e2.getBytes());
                    }
                    try {
                        int n2 = NBSHttpURLConnectionExtension.this.impl.getResponseCode();
                        nBSTransactionState.setStatusCode(n2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    NBSHttpURLConnectionExtension.this.error(e2.getException());
                }

                @Override
                public void streamComplete(NBSStreamCompleteEvent e2) {
                    NBSTransactionState nBSTransactionState = NBSHttpURLConnectionExtension.this.getTransactionState();
                    if (!nBSTransactionState.isComplete()) {
                        String string = NBSHttpURLConnectionExtension.this.impl.getRequestProperty("content-length");
                        long l2 = e2.getBytes();
                        if (string != null) {
                            try {
                                l2 = Long.parseLong(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        try {
                            int n2 = NBSHttpURLConnectionExtension.this.impl.getResponseCode();
                            nBSTransactionState.setStatusCode(n2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        nBSTransactionState.setBytesSentAfterComplete(l2);
                        NBSHttpURLConnectionExtension.this.addTransactionAndErrorData(nBSTransactionState);
                    }
                }
            });
        }
        return nBSCountingOutputStream;
    }

    @Override
    public int getReadTimeout() {
        return this.impl.getReadTimeout();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.impl.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String field) {
        return this.impl.getRequestProperty(field);
    }

    @Override
    public URL getURL() {
        return this.impl.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this.impl.getUseCaches();
    }

    @Override
    public void setAllowUserInteraction(boolean newValue) {
        this.impl.setAllowUserInteraction(newValue);
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.impl.setConnectTimeout(timeoutMillis);
    }

    @Override
    public void setDefaultUseCaches(boolean newValue) {
        this.impl.setDefaultUseCaches(newValue);
    }

    @Override
    public void setDoInput(boolean newValue) {
        this.impl.setDoInput(newValue);
    }

    @Override
    public void setDoOutput(boolean newValue) {
        this.impl.setDoOutput(newValue);
    }

    @Override
    public void setIfModifiedSince(long newValue) {
        this.impl.setIfModifiedSince(newValue);
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        this.impl.setReadTimeout(timeoutMillis);
    }

    @Override
    public void setRequestProperty(String field, String newValue) {
        this.impl.setRequestProperty(field, newValue);
    }

    @Override
    public void setUseCaches(boolean newValue) {
        this.impl.setUseCaches(newValue);
    }

    @Override
    public String toString() {
        return this.impl.toString();
    }

    private void checkResponse() {
        if (!this.getTransactionState().isComplete()) {
            NBSTransactionStateUtil.inspectAndInstrumentResponse(this.getTransactionState(), this.impl);
        }
    }

    private NBSTransactionState getTransactionState() {
        if (this.transactionState == null) {
            this.transactionState = new NBSTransactionState();
            NBSTransactionStateUtil.setUrlAndCarrier(this.transactionState, this.impl);
        } else {
            log.c("transaction state is not null");
        }
        return this.transactionState;
    }

    private void error(Exception e2) {
        n n2 = NBSAgent.getImpl();
        if (n2 == null) {
            return;
        }
        HarvestConfiguration harvestConfiguration = n2.q();
        if (harvestConfiguration == null) {
            return;
        }
        NBSTransactionState nBSTransactionState = this.getTransactionState();
        NBSTransactionStateUtil.setErrorCodeFromException(nBSTransactionState, e2);
        if (!al.b(nBSTransactionState.getUrl(), harvestConfiguration.getUrlFilterMode(), harvestConfiguration.getUrlRules())) {
            return;
        }
        if (!nBSTransactionState.isComplete()) {
            String string = "";
            if (nBSTransactionState.getException() != null) {
                string = nBSTransactionState.getException();
            }
            log.a("error message:" + string);
            b b2 = nBSTransactionState.end();
            log.a("isError:" + nBSTransactionState.isError());
            if (nBSTransactionState.isError() && al.a(b2.c(), b2.e(), harvestConfiguration.getIgnoreErrRules())) {
                nBSTransactionState.setStatusCode(200);
                b2.a(200);
                b2.b(0);
            }
            if (nBSTransactionState.isError()) {
                j.a(nBSTransactionState.getUrl(), nBSTransactionState.getFormattedUrlParams(), nBSTransactionState.getUrlParams(), nBSTransactionState.getStatusCode(), string, nBSTransactionState.getRequestMethodType());
            }
            ah.a(new a(b2.c(), b2.e(), b2.f(), b2.m(), b2.n(), b2.h(), b2.i(), b2.j(), b2.g(), b2.b(), b2.k()));
        }
    }

    private void addTransactionAndErrorData(NBSTransactionState transactionState) {
        n n2 = NBSAgent.getImpl();
        if (n2 == null) {
            return;
        }
        HarvestConfiguration harvestConfiguration = n2.q();
        if (harvestConfiguration == null) {
            return;
        }
        b b2 = transactionState.end();
        if (b2 == null) {
            return;
        }
        if (!al.b(b2.c(), harvestConfiguration.getUrlFilterMode(), harvestConfiguration.getUrlRules())) {
            return;
        }
        if (transactionState.isError() && al.a(b2.c(), b2.e(), harvestConfiguration.getIgnoreErrRules())) {
            transactionState.setStatusCode(200);
            b2.a(200);
            b2.b(0);
        }
        ah.a(new a(b2.c(), b2.e(), b2.f(), b2.m(), b2.n(), b2.h(), b2.i(), b2.j(), b2.g(), b2.b(), b2.k()));
        if (transactionState.isError()) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                object = this.getErrorStream();
                if (object instanceof NBSCountingInputStream) {
                    stringBuilder.append(((NBSCountingInputStream)object).getBufferAsString());
                }
            }
            catch (Exception exception) {
                log.d(exception.toString());
            }
            object = z.a(this.impl.getHeaderFields());
            object.put("Content-Length", transactionState.getBytesReceived());
            log.c("response body content:" + stringBuilder.toString());
            String string = "";
            if (transactionState.getException() != null) {
                string = transactionState.getException();
            }
            log.c("error message:" + string);
            j.a(b2.c(), b2.g(), b2.a(), b2.e(), stringBuilder.toString(), (Map<String, Object>)object, string, transactionState.getRequestMethodType());
        }
    }
}

