/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.instrumentation;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.networkbench.agent.impl.harvest.type.MetricCategory;
import com.networkbench.agent.impl.instrumentation.NBSReplaceCallSite;
import com.networkbench.agent.impl.instrumentation.NBSTraceEngine;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;

public class NBSGsonInstrumentation {
    private static final ArrayList<String> categoryParams = new ArrayList<String>(Arrays.asList("category", MetricCategory.class.getName(), "JSON"));

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static String toJson(Gson gson, Object src) {
        NBSTraceEngine.enterMethod("Gson#toJson", categoryParams);
        String string = gson.toJson(src);
        NBSTraceEngine.exitMethod();
        return string;
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static String toJson(Gson gson, Object src, Type typeOfSrc) {
        NBSTraceEngine.enterMethod("Gson#toJson", categoryParams);
        String string = gson.toJson(src, typeOfSrc);
        NBSTraceEngine.exitMethod();
        return string;
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static void toJson(Gson gson, Object src, Appendable writer) throws JsonIOException {
        NBSTraceEngine.enterMethod("Gson#toJson", categoryParams);
        gson.toJson(src, writer);
        NBSTraceEngine.exitMethod();
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static void toJson(Gson gson, Object src, Type typeOfSrc, Appendable writer) throws JsonIOException {
        NBSTraceEngine.enterMethod("Gson#toJson", categoryParams);
        gson.toJson(src, typeOfSrc, writer);
        NBSTraceEngine.exitMethod();
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static void toJson(Gson gson, Object src, Type typeOfSrc, JsonWriter writer) throws JsonIOException {
        NBSTraceEngine.enterMethod("Gson#toJson", categoryParams);
        gson.toJson(src, typeOfSrc, writer);
        NBSTraceEngine.exitMethod();
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static String toJson(Gson gson, JsonElement jsonElement) {
        NBSTraceEngine.enterMethod("Gson#toJson", categoryParams);
        String string = gson.toJson(jsonElement);
        NBSTraceEngine.exitMethod();
        return string;
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static void toJson(Gson gson, JsonElement jsonElement, Appendable writer) throws JsonIOException {
        NBSTraceEngine.enterMethod("Gson#toJson", categoryParams);
        gson.toJson(jsonElement, writer);
        NBSTraceEngine.exitMethod();
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static void toJson(Gson gson, JsonElement jsonElement, JsonWriter writer) throws JsonIOException {
        NBSTraceEngine.enterMethod("Gson#toJson", categoryParams);
        gson.toJson(jsonElement, writer);
        NBSTraceEngine.exitMethod();
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static <T> T fromJson(Gson gson, String json, Class<T> classOfT) throws JsonSyntaxException {
        NBSTraceEngine.enterMethod("Gson#fromJson", categoryParams);
        Object object = gson.fromJson(json, classOfT);
        NBSTraceEngine.exitMethod();
        return (T)object;
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static <T> T fromJson(Gson gson, String json, Type typeOfT) throws JsonSyntaxException {
        NBSTraceEngine.enterMethod("Gson#fromJson", categoryParams);
        Object object = gson.fromJson(json, typeOfT);
        NBSTraceEngine.exitMethod();
        return (T)object;
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static <T> T fromJson(Gson gson, Reader json, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        NBSTraceEngine.enterMethod("Gson#fromJson", categoryParams);
        Object object = gson.fromJson(json, classOfT);
        NBSTraceEngine.exitMethod();
        return (T)object;
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static <T> T fromJson(Gson gson, Reader json, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        NBSTraceEngine.enterMethod("Gson#fromJson", categoryParams);
        Object object = gson.fromJson(json, typeOfT);
        NBSTraceEngine.exitMethod();
        return (T)object;
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static <T> T fromJson(Gson gson, JsonReader reader, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        NBSTraceEngine.enterMethod("Gson#fromJson", categoryParams);
        Object object = gson.fromJson(reader, typeOfT);
        NBSTraceEngine.exitMethod();
        return (T)object;
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static <T> T fromJson(Gson gson, JsonElement json, Class<T> classOfT) throws JsonSyntaxException {
        NBSTraceEngine.enterMethod("Gson#fromJson", categoryParams);
        Object object = gson.fromJson(json, classOfT);
        NBSTraceEngine.exitMethod();
        return (T)object;
    }

    @NBSReplaceCallSite(scope="com.google.gson.Gson")
    public static <T> T fromJson(Gson gson, JsonElement json, Type typeOfT) throws JsonSyntaxException {
        NBSTraceEngine.enterMethod("Gson#fromJson", categoryParams);
        Object object = gson.fromJson(json, typeOfT);
        NBSTraceEngine.exitMethod();
        return (T)object;
    }

    @Deprecated
    void a() {
    }
}

