/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.harvest.type;

import java.util.HashMap;
import java.util.Map;

public enum MetricCategory {
    NONE("None"),
    VIEW_LOADING("ViewLoading"),
    VIEW_LAYOUT("ViewLayout"),
    DATABASE("Storage"),
    IMAGE("Image"),
    JSON("Json"),
    NETWORK("Network"),
    BACKGROUND("Background");

    private String categoryName;
    private static final Map<String, MetricCategory> methodMap;

    private MetricCategory(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public static MetricCategory categoryForMethod(String fullMethodName) {
        MetricCategory metricCategory;
        if (fullMethodName == null) {
            return NONE;
        }
        String string = null;
        int n2 = fullMethodName.indexOf("#");
        if (n2 >= 0) {
            string = fullMethodName.substring(n2 + 1);
        }
        if ((metricCategory = methodMap.get(string)) == null) {
            metricCategory = NONE;
        }
        return metricCategory;
    }

    static {
        methodMap = new HashMap<String, MetricCategory>(){
            private static final long a = -1342597889479051466L;
            {
                this.put("onCreate", VIEW_LOADING);
            }
        };
    }
}

