/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.harvest;

import com.networkbench.agent.impl.NBSAgent;
import com.networkbench.agent.impl.c.r;
import com.networkbench.agent.impl.d.c;
import com.networkbench.agent.impl.d.d;
import com.networkbench.agent.impl.harvest.ConnectInformation;
import com.networkbench.agent.impl.harvest.HarvestConfiguration;
import com.networkbench.agent.impl.harvest.HarvestResponse;
import com.networkbench.agent.impl.harvest.type.Harvestable;
import com.networkbench.agent.impl.i.b;
import com.networkbench.agent.impl.j.x;
import com.networkbench.com.google.gson.Gson;
import com.networkbench.com.google.gson.GsonBuilder;
import com.networkbench.com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HarvestConnection {
    public static final int NSURLErrorUnknown = -1;
    public static final int NSURLErrorBadURL = -1000;
    public static final int NSURLErrorTimedOut = -1001;
    public static final int NSURLErrorCannotConnectToHost = -1004;
    public static final int NSURLErrorDNSLookupFailed = -1006;
    public static final int NSURLErrorBadServerResponse = -1011;
    public static final int NSURLErrorSecureConnectionFailed = -1200;
    private final c log = d.a();
    private static final Boolean DISABLE_COMPRESSION_FOR_DEBUGGING = false;
    public static String redirectHost = "redirect.networkbench.com";
    private String collectorHost;
    private String licenseKey;
    private String applicationToken;
    private long serverTimestamp;
    private final HttpClient collectorClient;
    private ConnectInformation connectInformation;
    private boolean useSsl;

    public HarvestConnection() {
        int n2 = 5;
        int n3 = (int)TimeUnit.MILLISECONDS.convert(n2, TimeUnit.SECONDS);
        int n4 = 8192;
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)n3);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)n3);
        HttpConnectionParams.setTcpNoDelay((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)n4);
        this.collectorClient = new DefaultHttpClient((HttpParams)basicHttpParams);
        if (x.c().w()) {
            this.useSsl = true;
        }
    }

    public HttpPost createPost(String uri, String message) {
        String string = message.length() <= 512 || DISABLE_COMPRESSION_FOR_DEBUGGING != false ? "identity" : "deflate";
        HttpPost httpPost = new HttpPost(uri);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.addHeader("Content-Encoding", string);
        httpPost.addHeader("User-Agent", this.connectInformation.userAgent);
        httpPost.addHeader("X-App-Sign", com.networkbench.agent.impl.c.d.n());
        if (this.licenseKey == null) {
            this.log.d("Cannot create POST without an Application Token.");
            return null;
        }
        httpPost.addHeader("X-License-Key", this.licenseKey);
        if (this.serverTimestamp != 0L) {
            httpPost.addHeader("X-NBS-Connect-Time", Long.valueOf(this.serverTimestamp).toString());
        }
        if ("deflate".equals(string)) {
            byte[] byArray = this.deflate(message);
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(byArray));
        } else {
            try {
                httpPost.setEntity((HttpEntity)new StringEntity(message, "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.log.d("UTF-8 is unsupported");
                throw new IllegalArgumentException(unsupportedEncodingException);
            }
        }
        return httpPost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarvestResponse sendNew(HttpPost post) {
        HttpResponse httpResponse;
        HarvestResponse harvestResponse = new HarvestResponse();
        try {
            b b2 = new b();
            b2.a();
            httpResponse = this.collectorClient.execute((HttpUriRequest)post);
            harvestResponse.setResponseTime(b2.b());
        }
        catch (Exception exception) {
            this.log.d("Failed to send POST to collector: " + exception.getMessage());
            this.recordCollectorError(exception);
            return null;
        }
        int n2 = httpResponse.getStatusLine().getStatusCode();
        if (n2 > 400) {
            this.log.b("connect server failed! statuscode:" + n2);
        }
        harvestResponse.setStatusCode(n2);
        String string = null;
        try {
            string = HarvestConnection.readResponse(httpResponse);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        harvestResponse.setResponseBody(string);
        HarvestConnection harvestConnection = this;
        synchronized (harvestConnection) {
            long l2;
            long l3;
            block33: {
                l3 = -1L;
                l2 = -1L;
                int n3 = 0;
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    String string2 = jSONObject.getString("status");
                    if (string2.equals("success")) {
                        JSONArray jSONArray;
                        JSONArray jSONArray2;
                        Object object;
                        String string3;
                        JSONObject jSONObject2;
                        int n4;
                        jSONObject = jSONObject.getJSONObject("result");
                        JSONObject jSONObject3 = jSONObject.getJSONObject("cfg");
                        HarvestConfiguration harvestConfiguration = new HarvestConfiguration();
                        ArrayList<r.b> arrayList = harvestConfiguration.getUrlRules();
                        ArrayList<r.a> arrayList2 = harvestConfiguration.getIgnoreErrRules();
                        ArrayList<r.c> arrayList3 = harvestConfiguration.getUrlParamArray();
                        String string4 = jSONObject.getString("did");
                        String string5 = jSONObject.getString("token");
                        int n5 = jSONObject.getInt("enabled");
                        harvestConfiguration.setEnabled(n5);
                        this.log.a("did:" + string4 + ", token:" + string5 + ", enabled:" + n5);
                        harvestConfiguration.setDeviceId(string4);
                        harvestConfiguration.setToken(string5);
                        this.log.a("cfgObj:" + jSONObject3.toString());
                        harvestConfiguration.setInterval(jSONObject3.getInt("interval"));
                        harvestConfiguration.setIntervalOnIdle(jSONObject3.getInt("intervalOnIdle"));
                        harvestConfiguration.setActions(jSONObject3.getInt("actions"));
                        harvestConfiguration.setActionAge(jSONObject3.getInt("actionAge"));
                        harvestConfiguration.setEnableErrTrace(jSONObject3.getBoolean("enableErrTrace"));
                        harvestConfiguration.setErrs(jSONObject3.getInt("errs"));
                        harvestConfiguration.setErrRspSize(jSONObject3.getInt("errRspSize"));
                        harvestConfiguration.setStackDepth(jSONObject3.getInt("stackDepth"));
                        try {
                            harvestConfiguration.setUiTraces(jSONObject3.getInt("uiTraces"));
                            harvestConfiguration.setUiTraceSize(jSONObject3.getInt("uiTraceSize"));
                            harvestConfiguration.setUiTraceRetries(jSONObject3.getInt("uiTraceRetries"));
                            harvestConfiguration.setUiTraceThreshold(jSONObject3.getInt("uiTraceThreshold"));
                        }
                        catch (Exception exception) {
                            this.log.d("Error while unpacking UITrace JSON response during connect");
                        }
                        try {
                            harvestConfiguration.setCrashTrails(jSONObject3.getInt("crashTrails"));
                            int n6 = jSONObject3.getInt("betaOn");
                            harvestConfiguration.setBetaonFlag(n6);
                            n4 = jSONObject3.getInt("features");
                            harvestConfiguration.setHttp_network_enabled((1 & n4) != 0);
                            harvestConfiguration.setUi_enabled((2 & n4) != 0);
                            harvestConfiguration.setCrash_enabled((4 & n4) != 0);
                            harvestConfiguration.setWebview_enabled((8 & n4) != 0);
                            if (n6 == 0) {
                                harvestConfiguration.setSocketdata_enabled(false);
                            } else {
                                harvestConfiguration.setSocketdata_enabled((0x10 & n4) != 0);
                            }
                            harvestConfiguration.setCrossApplicationEnable((0x20 & n4) != 0);
                            harvestConfiguration.setTyId(jSONObject.getString("tyId"));
                        }
                        catch (Exception exception) {
                            this.log.d("Error while unpacking JSON response during connect");
                        }
                        n3 = jSONObject3.getInt("urlFilterMode");
                        harvestConfiguration.setUrlFilterMode(n3);
                        if (n3 != 0) {
                            JSONArray jSONArray3 = jSONObject3.getJSONArray("urlRules");
                            for (n4 = 0; n4 < jSONArray3.length(); ++n4) {
                                jSONObject2 = jSONArray3.getJSONObject(n4);
                                int n7 = jSONObject2.getInt("matchMode");
                                string3 = jSONObject2.getString("rule");
                                object = new r.b();
                                ((r.b)object).a = n7;
                                ((r.b)object).b = string3;
                                if (arrayList == null) {
                                    arrayList = new ArrayList();
                                }
                                arrayList.add((r.b)object);
                            }
                        }
                        harvestConfiguration.setUrlRules(arrayList);
                        if (jSONObject3.has("urlParams") && (jSONArray2 = jSONObject3.getJSONArray("urlParams")) != null) {
                            for (n4 = 0; n4 < jSONArray2.length(); ++n4) {
                                jSONObject2 = (JSONObject)jSONArray2.get(n4);
                                r.c c2 = new r.c();
                                c2.a = string3 = jSONObject2.getString("url");
                                if (jSONObject2.has("get")) {
                                    c2.b = jSONObject2.getString("get");
                                }
                                if (jSONObject2.has("post")) {
                                    c2.c = jSONObject2.getString("post");
                                }
                                if (jSONObject2.has("headers")) {
                                    c2.d = jSONObject2.getString("headers");
                                }
                                if (arrayList3 == null) {
                                    arrayList3 = new ArrayList();
                                }
                                arrayList3.add(c2);
                            }
                            harvestConfiguration.setUrlParamArray(arrayList3);
                        }
                        if (jSONObject3.has("ignoredErrRules") && !jSONObject3.isNull("ignoredErrRules") && (jSONArray = jSONObject3.getJSONArray("ignoredErrRules")) != null) {
                            for (n4 = 0; n4 < jSONArray.length(); ++n4) {
                                jSONObject2 = (JSONObject)jSONArray.get(n4);
                                int n8 = jSONObject2.getInt("matchMode");
                                string3 = jSONObject2.getString("rule");
                                object = jSONObject2.getString("errs");
                                r.a a2 = new r.a();
                                a2.a = n8;
                                a2.b = string3;
                                a2.c = object;
                                if (arrayList2 == null) {
                                    arrayList2 = new ArrayList();
                                }
                                arrayList2.add(a2);
                            }
                            harvestConfiguration.setIgnoreErrRules(arrayList2);
                        }
                        harvestResponse.setConfiguration(harvestConfiguration);
                        break block33;
                    }
                    if (string2.equals("error")) {
                        GsonBuilder gsonBuilder = new GsonBuilder();
                        Gson gson = gsonBuilder.create();
                        Map map = (Map)gson.fromJson(string, new TypeToken<Map<String, Object>>(){}.getType());
                        harvestResponse.setStatus("error");
                        Object v2 = map.get("result");
                        if (v2 instanceof Map) {
                            Map map2 = (Map)map.get("result");
                            harvestResponse.setErrorCode(((Double)map2.get("errorCode")).intValue());
                            harvestResponse.setResultMessage(map2.get("errorMessage").toString());
                        }
                        this.log.a(harvestResponse.toString());
                    }
                }
                catch (JSONException jSONException) {
                    this.log.d("Error while unpacking JSON response during connect" + jSONException.toString());
                }
            }
            if (l3 < 0L) {
                // empty if block
            }
            if (l2 <= 0L || l2 > 600L) {
                l2 = 600L;
            }
        }
        return harvestResponse;
    }

    public HarvestResponse send(HttpPost post) {
        HttpResponse httpResponse;
        HarvestResponse harvestResponse = new HarvestResponse();
        try {
            b b2 = new b();
            b2.a();
            httpResponse = this.collectorClient.execute((HttpUriRequest)post);
            harvestResponse.setResponseTime(b2.b());
        }
        catch (Exception exception) {
            this.log.d("Failed to send POST to collector: " + exception.getMessage());
            this.recordCollectorError(exception);
            return null;
        }
        int n2 = httpResponse.getStatusLine().getStatusCode();
        harvestResponse.setStatusCode(n2);
        try {
            String string = HarvestConnection.readResponse(httpResponse);
            harvestResponse.setResponseBody(string);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            Map map = (Map)gson.fromJson(string, new TypeToken<Map<String, Object>>(){}.getType());
            if ("success".equals(map.get("status"))) {
                harvestResponse.setStatus("success");
                this.log.a("result content:" + map.get("result"));
                harvestResponse.setResultMessage(map.containsKey("result") ? map.get("result").toString() : "");
            } else if ("error".equals(map.get("status"))) {
                harvestResponse.setStatus("error");
                Object v2 = map.get("result");
                if (v2 instanceof Map) {
                    Map map2 = (Map)map.get("result");
                    harvestResponse.setErrorCode(((Double)map2.get("errorCode")).intValue());
                    harvestResponse.setResultMessage(map2.get("errorMessage").toString());
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.log.d("Failed to retrieve collector response: " + iOException.getMessage());
        }
        return harvestResponse;
    }

    public HarvestResponse getRedirectHost() {
        HttpPost httpPost = this.createRedirectPost();
        b b2 = new b();
        b2.a();
        HarvestResponse harvestResponse = this.send(httpPost);
        return harvestResponse;
    }

    public HarvestResponse sendConnect() {
        if (this.connectInformation == null) {
            throw new IllegalArgumentException();
        }
        String string = this.connectInformation.toJsonString();
        HttpPost httpPost = this.createConnectPost(string);
        if (httpPost == null) {
            this.log.d("Failed to create connect POST");
            return null;
        }
        b b2 = new b();
        b2.a();
        HarvestResponse harvestResponse = this.sendNew(httpPost);
        return harvestResponse;
    }

    public HarvestResponse sendData(Harvestable harvestable) {
        if (harvestable == null) {
            throw new IllegalArgumentException();
        }
        String string = harvestable.toJsonString();
        HttpPost httpPost = this.createDataPost(string);
        if (httpPost == null) {
            this.log.d("Failed to create data POST");
            return null;
        }
        return this.send(httpPost);
    }

    public HttpPost createRedirectPost() {
        return this.createPost(this.getRedirectUri(), "");
    }

    public HttpPost createConnectPost(String message) {
        return this.createPost(this.getCollectorConnectUri(), message);
    }

    public HttpPost createDataPost(String message) {
        return this.createPost(this.getCollectorDataUri(), message);
    }

    private byte[] deflate(String message) {
        int n2 = 8192;
        Deflater deflater = new Deflater();
        deflater.setInput(message.getBytes());
        deflater.finish();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[n2];
        while (!deflater.finished()) {
            int n3 = deflater.deflate(byArray);
            if (n3 <= 0) {
                this.log.d("HTTP request contains an incomplete payload");
            }
            byteArrayOutputStream.write(byArray, 0, n3);
        }
        deflater.end();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResponse(HttpResponse response) throws IOException {
        int n2 = 8192;
        char[] cArray = new char[n2];
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = response.getEntity().getContent();
        try {
            int n3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((n3 = bufferedReader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n3);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    private void recordCollectorError(Exception e2) {
    }

    private int exceptionToErrorCode(Exception e2) {
        if (e2 instanceof ClientProtocolException) {
            return -1011;
        }
        if (e2 instanceof UnknownHostException) {
            return -1006;
        }
        if (e2 instanceof SocketTimeoutException) {
            return -1001;
        }
        if (e2 instanceof ConnectTimeoutException) {
            return -1001;
        }
        if (e2 instanceof ConnectException) {
            return -1004;
        }
        if (e2 instanceof MalformedURLException) {
            return -1000;
        }
        if (e2 instanceof SSLException) {
            return -1200;
        }
        return -1;
    }

    private String getCollectorUri(String host, String resource) {
        String string = this.useSsl ? "https://" : "http://";
        return string + host + resource;
    }

    private String getRedirectUri() {
        return this.getCollectorUri(redirectHost, "/getMobileRedirectHost");
    }

    private String getCollectorConnectUri() {
        return this.getCollectorUri(this.collectorHost, "/initMobileApp?version=" + NBSAgent.getDataVersion());
    }

    private String getCollectorDataUri() {
        return this.getCollectorUri(this.collectorHost, "/uploadMobileData?version=" + NBSAgent.getDataVersion() + "&token=" + this.applicationToken);
    }

    public void setServerTimestamp(long serverTimestamp) {
        this.serverTimestamp = serverTimestamp;
    }

    public void useSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public String getApplicationToken() {
        return this.applicationToken;
    }

    public void setApplicationToken(String applicationToken) {
        this.applicationToken = applicationToken;
    }

    public void setCollectorHost(String collectorHost) {
        this.collectorHost = collectorHost;
    }

    public void setConnectInformation(ConnectInformation connectInformation) {
        this.connectInformation = connectInformation;
    }

    public ConnectInformation getConnectInformation() {
        return this.connectInformation;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }
}

